package com.xforceplus.ultraman.oqsengine.sdk.service.export;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;
import java.util.Optional;

/**
 * custom field value to String
 */
public interface ExportCustomFieldToString {

    Logger log = LoggerFactory.getLogger(ExportCustomFieldToString.class);

    boolean isSupport(IEntityClass entityClass, IEntityField field);

    Optional<String> getString(IEntityClass entityClass, IEntityField entityField, String value, Map<String, Object> context, FormattedString formattedString);

    Optional<String> getString(IEntityClass entityClass, IEntityField entityField, String value, Map<String, Object> context);

    default Optional<String> safeGetString(IEntityClass entityClass, IEntityField entityField, String value, Map<String, Object> context, FormattedString formattedString) {
        try {
            return getString(entityClass, entityField, value, context, formattedString);
        } catch (Exception ex) {
            log.error("{} fallback", ex);
            return Optional.ofNullable(value);
        }
    }

    default boolean isDefault() {
        return false;
    }
}
