package com.xforceplus.ultraman.oqsengine.sdk.service.export;

import akka.stream.IOResult;
import akka.stream.javadsl.Sink;
import akka.util.ByteString;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import io.vavr.Tuple2;

import java.io.InputStream;
import java.util.concurrent.CompletionStage;

/**
 * ExportSink Sinker
 */
public interface ExportSink {

    Sink<ByteString,  CompletionStage<Tuple2<IOResult, String[]>>> getSink(String type, String... token);

    String getDownloadUrl(String type, String... token);

    InputStream getInputStream(String... token);

}
