package com.xforceplus.ultraman.oqsengine.sdk.service.export.entity;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@Data
public class ImportResult {
    private Integer successCount = 0;
    private Integer failedCount = 0;
    private Integer totalCount = 0;
    private List<SheetImportResult> sheetImportResultList;

    public void summary() {
        for (SheetImportResult sheetImportResult : this.sheetImportResultList) {
            this.successCount += sheetImportResult.getSuccessCount().get();
            this.failedCount += sheetImportResult.getFailedCount().get();
            this.totalCount += sheetImportResult.getTotalCount();
        }
    }

    public String toHumanFormatString() {
        String format = "导入成功%s条，导入失败%s条，总计%s条。";
        String sheetFormat = "\n表单【%s】，导入对象【%s】，导入成功%s条，导入失败%s条，表单小计%s条。";
        String errorListFormat = "导入失败列表：";
        String errorRowFormat = "\n第%s行：%s；";
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(format, this.successCount, this.failedCount, this.totalCount));
        if (this.failedCount > 0) {
            if (sheetImportResultList == null) {
                return null;
            }
            sheetImportResultList.forEach(sheetImportResult -> {
                StringBuilder sb1 = new StringBuilder();
                if (this.sheetImportResultList.size() > 1) {
                    sb1.append(String.format(sheetFormat, sheetImportResult.getSheetName(), sheetImportResult.boCode, sheetImportResult.getSuccessCount(), sheetImportResult.getFailedCount(), sheetImportResult.getTotalCount()));
                }
                if (sheetImportResult.getFailedCount().get() > 0) {
                    sb1.append(errorListFormat);
                    StringBuilder sb2 = new StringBuilder();
                    sheetImportResult.getRowImportErrorResultList().forEach(rowImportErrorResult -> {
                        sb2.append(String.format(errorRowFormat, rowImportErrorResult.getRowIndex(), rowImportErrorResult.getErrorMsg()));
                    });
                    sb1.append(sb2);
                }
                sb.append(sb1);
            });
        }
        if (sb.length() > 1000) {
            return sb.substring(0, 1000) + "...（长度超过1000后省略）";
        }
        return sb.toString();
    }

    @Data
    public static class SheetImportResult {
        private String boCode;
        private String sheetName;
        private AtomicInteger successCount = new AtomicInteger(0);
        private AtomicInteger failedCount = new AtomicInteger(0);
        private Integer totalCount = 0;
        private String errorMsg;
        private List<rowImportErrorResult> rowImportErrorResultList = new ArrayList<>();

        public void addErrorResult(Integer rowIndex, String errorMsg) {
            if (this.rowImportErrorResultList.size() >= 20) {
                this.errorMsg = "错误行信息过多，只收集前20条";
                return;
            }
            this.rowImportErrorResultList.add(new rowImportErrorResult(rowIndex, errorMsg));
        }

        @Data
        public static class rowImportErrorResult {
            private Integer rowIndex;
            private String errorMsg;

            public rowImportErrorResult(Integer rowIndex, String errorMsg) {
                this.rowIndex = rowIndex;
                this.errorMsg = errorMsg;
            }
        }
    }

}
