package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import com.xforceplus.ultraman.oqsengine.sdk.event.EntityErrorExported;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityExported;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportCallBack;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

import java.util.function.Supplier;

/**
 * a default exportCallback
 */
public class DefaultExportCallBack implements ExportCallBack, ApplicationEventPublisherAware {

    private ApplicationEventPublisher publisher;


    @Override
    public void onSuccess(Supplier<EntityExported> exported) {
        EntityExported entityExported = exported.get();
        publisher.publishEvent(entityExported);
    }

    @Override
    public void onFailure(Supplier<EntityErrorExported> errorExported) {
        EntityErrorExported entityErrorExported = errorExported.get();
        publisher.publishEvent(entityErrorExported);
    }

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }
}
