package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityImported;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.CreateMultiResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.CreateOneResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.QueryResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.ResultStatus;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.*;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ImportService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.PostImportAware;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.DefaultTransactionManager;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransaction;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransactionManager;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import io.vavr.control.Either;
import io.vavr.control.Validation;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;

import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class ImprovedImportDefaultExcelServiceImpl extends ImportDefaultExcelServiceImpl {

    private Logger logger = LoggerFactory.getLogger(ImportService.class);

    private int defaultStep = 1000;

    public ImprovedImportDefaultExcelServiceImpl(EntityFacade entityFacade
            , ContextService contextService
            , ExecutorService importThreadPool
            , OqsTransactionManager manager
            , ApplicationEventPublisher publisher
    ) {
        super(entityFacade, contextService, importThreadPool, manager, publisher);
    }


    private RecordTaskQueue createQueue(IEntityClass entityClass, int step, Map<String, Object> context) {
        return new RecordTaskQueue(entityClass, step, context);
    }


    class RecordTaskQueue {

        private IEntityClass entityClass;

        private int step;

        private Map<String, Object> context;

        private Queue<Map<String, Object>> queue = new LinkedList<>();

        private BiConsumer<List<Map<String, Object>>, Map<String, Object>> consumer;

        public RecordTaskQueue(IEntityClass entityClass, int step, Map<String, Object> context) {
            this.entityClass = entityClass;
            this.step = step;
            this.context = context;
        }

        public void flush() {
            if (!queue.isEmpty()) {

                if (consumer != null) {
                    this.consumer.accept(queue.stream().collect(Collectors.toList()), context);
                }

                CompletionStage<Either<CreateMultiResult, Integer>> multi =
                        entityFacade.createMulti(entityClass, queue.stream(), context);
                Either<CreateMultiResult, Integer> join = multi.toCompletableFuture().join();
                if (join.isLeft()) {
                    CreateMultiResult left = join.getLeft();
                    if (left.getOriginCause() != ResultStatus.OriginStatus.HALF_SUCCESS) {
                        throw new RuntimeException(join.getLeft().getMessage());
                    }
                }
                queue.clear();
            }
        }

        public void onFlush(BiConsumer<List<Map<String, Object>>, Map<String, Object>> consumer) {
            this.consumer = consumer;
        }

        public void offer(Map<String, Object> elem) {
            queue.offer(elem);
            if (queue.size() % step == 0) {
                this.flush();
            }
        }
    }

    /**
     * @param sheet
     * @param contextMap
     */
    private void insertMain(IEntityClass entityClass, XSSFSheet sheet, List<String> relatedCode, boolean useBatch, int step, Map<String, Object> contextMap) {
        Iterator<Row> rowIterator = sheet.rowIterator();


        Row headerRow = null;
        boolean isFirstRow = true;
        short size = 0;

        RecordTaskQueue queue = null;

        while (rowIterator.hasNext()) {
            Map<String, Object> map = new HashMap<>();
            Row row = rowIterator.next();
            if (isFirstRow) {
                headerRow = row;
                isFirstRow = false;
                size = headerRow.getLastCellNum();
                continue;
            }

            int i;
            map.clear();
            for (i = 0; i < size; i++) {
                Cell cell = row.getCell(i);
                map.put(getBoFieldCodeFromExcelHeader(headerRow.getCell(i).getStringCellValue(), entityClass)
                        , cell == null ? null : readCellRawValue(cell));
            }

            if (useBatch) {
                if (queue == null) {
                    queue = createQueue(entityClass, step, contextMap);
                }
                //use batch
                Optional<Validation<String, Map<String, Object>>> first = postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, map, contextMap))
                        .filter(Validation::isInvalid).findFirst();
                //store in cache
                if (!first.isPresent()) {
                    //store
                    queue.offer(map);
                } else {
                    //TODO
                }
            } else {
                //insert one by one
                CompletableFuture<Either<CreateOneResult, Long>> insertResult;
                Optional<Validation<String, Map<String, Object>>> first = postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, map, contextMap))
                        .filter(Validation::isInvalid).findFirst();
                if (!first.isPresent()) {
                    //insert one by one
                    insertResult = entityFacade.create(entityClass, map, contextMap)
                            .toCompletableFuture()
                            .thenApplyAsync(x -> x, importThreadPool);
                    Either<CreateOneResult, Long> join = insertResult.join();
                    List<String> finalRelatedCodeList = relatedCode;
                    if (join.isRight()) {
                        for (String related : finalRelatedCodeList) {
                            buildRelatedIndex(related, contextMap, map, join.get());
                        }
                    } else {
                        if (join.getLeft().getOriginCause() == ResultStatus.OriginStatus.HALF_SUCCESS) {
                            logger.warn("Half success detect {}", join.getLeft().getErrorMap());
                            for (String related : finalRelatedCodeList) {
                                buildRelatedIndex(related, contextMap, map, join.getLeft().getId());
                            }
                        } else {
                            throw new RuntimeException(join.getLeft().getMessage());
                        }
                    }
                } else {
                    //TODO
                    Validation<String, Map<String, Object>> validation = first.get();
                    CompletableFuture.completedFuture(Either.left(CreateOneResult.from(new RuntimeException(validation.getError()))));
                }
            }
        }

        if (queue != null) {
            queue.flush();
        }
    }

    protected void putIndexMapping(Map<String, Object> context, String relatedCode, String code, Long value) {
        Object index = context.get("index");

        if (index != null) {
            Map<String, Map<String, Long>> indexMapping = (Map<String, Map<String, Long>>) index;
            Map<String, Long> schemaMapping = indexMapping.get(relatedCode);
            if (schemaMapping == null) {
                schemaMapping = new HashMap<>();
                indexMapping.put(relatedCode, schemaMapping);
            }

            schemaMapping.put(code, value);
        }
    }

    /**
     * insert related
     *
     * @param entityClass
     * @param sheet
     * @param contextMap
     */
    private void insertRelated(IEntityClass mainClass, IEntityClass entityClass, String relatedCode
            , XSSFSheet sheet, Map<String, Object> contextMap, boolean useBatch, int step) {

        Row headerRow = null;
        boolean isFirstRow = true;
        short size = 0;
        Iterator<Row> rowIterator = sheet.rowIterator();

        /**
         * get related sheetname
         */
        String sheetName = sheet.getSheetName();
        RecordTaskQueue queue = createQueue(entityClass, step, contextMap);

        queue.onFlush((list, ctx) -> {
            Object unresolved = ctx.get("unresolved");
            Object unresolvedKey = ctx.get("unresolved-key");
            if (unresolved != null && unresolvedKey != null) {
                List<Map<String, Object>> unresolvedKeys = (List<Map<String, Object>>) unresolved;
                if (!unresolvedKeys.isEmpty()) {
                    Map<String, Long> mapping = getMainIdMappingWithKeys(mainClass, sheetName, unresolvedKeys, contextMap);
                    list.forEach(body -> {
                        //modify
                        Object o = body.get(unresolvedKey.toString());
                        body.put(relatedCode.concat(".id"), mapping.get(o.toString()));
                    });
                    unresolvedKeys.clear();
                }
            }
        });

        while (rowIterator.hasNext()) {
            Map<String, Object> map = new HashMap<>();
            Row row = rowIterator.next();
            if (isFirstRow) {
                headerRow = row;
                isFirstRow = false;
                size = headerRow.getLastCellNum();
                continue;
            }

            int i;
            map.clear();
            StringBuilder sb = new StringBuilder();
            Map<String, Object> keyValueMapping = new HashMap<>();
            for (i = 0; i < size; i++) {
                Cell cell = row.getCell(i);

                if (cell != null) {
                    Object rawValue = readCellRawValue(cell);
                    Cell headerCell = headerRow.getCell(i);
                    if (headerCell.getCellComment() != null) {
                        keyValueMapping.put(headerCell.getCellComment().getString().getString(), rawValue);
                        if (sb.length() > 0) {
                            sb.append("%^%");
                        }
                        sb.append(rawValue);
                    }

                    map.put(getBoFieldCodeFromExcelHeader(headerCell.getStringCellValue(), entityClass)
                            , cell == null ? null : readCellRawValue(cell));
                }
            }

            String s = sb.toString();
            Map<String, Long> indexMapping = getRelatedIndexMapping(contextMap, sheetName);

            //get related id
            Long related = indexMapping.get(s);

            if (related == null) {
                logger.warn("{} has no related value, body: {}", sheetName, map);
                //add key to unresolved
                Object o = contextMap.get("unresolved-key");

                if (o == null) {
                    String key = String.join("%^%", keyValueMapping.keySet());
                    contextMap.put("unresolved-key", key);
                }

                Object resolved = contextMap.get("unresolved");
                if (resolved == null) {
                    resolved = new ArrayList<Map<String, Object>>();
                    contextMap.put("unresolved", resolved);
                }

                ((List<Map<String, Object>>) resolved).add(keyValueMapping);
            } else {
                if (related != -1L) {
                    map.put(sheetName.concat(".id"), related);
                }
            }

            if (!useBatch) {

                Optional<Validation<String, Map<String, Object>>> first = postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, map, contextMap))
                        .filter(Validation::isInvalid).findFirst();
                if (!first.isPresent()) {
                    //insert one by one
                    entityFacade.create(entityClass, map, contextMap)
                            .toCompletableFuture()
                            .thenApplyAsync(x -> x, importThreadPool).join();
                } else {
                    //do nothing
                    logger.error("{}, {}, {} is not execute", entityClass.code(), map, contextMap);
                }
            } else {

                Optional<Validation<String, Map<String, Object>>> first = postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, map, contextMap))
                        .filter(Validation::isInvalid).findFirst();
                if (!first.isPresent()) {
                    queue.offer(map);
                } else {
                    logger.error("{}, {}, {} is not execute", entityClass.code(), map, contextMap);
                }
            }
        }

        if (queue != null) {
            queue.flush();
        }
    }

    /**
     * //try to find one
     * ExpQuery query = ExpFactory.createFrom(keyValueMapping).range(1, 1);
     * Either<QueryResult, DataCollection<Record>> result = entityFacade.query(mainClass, query, contextMap).toCompletableFuture().join();
     * if (result.isRight() && !result.get().getRows().isEmpty()) {
     * Record record = result.get().getRows().get(0);
     * Long id = record.getId();
     * putIndexMapping(contextMap, relatedCode, s, id);
     * } else {
     * putIndexMapping(contextMap, relatedCode, s, -1L);
     * }
     * batch query related main
     * TODO a related optimized
     *
     * @param mainClass
     * @param unresolvedKeys
     * @return
     */
    private Map<String, Long> getMainIdMappingWithKeys(IEntityClass mainClass, String relatedCode, List<Map<String, Object>> unresolvedKeys, Map<String, Object> contextMap) {

        boolean singleQuery = unresolvedKeys.stream().allMatch(x -> x.size() == 1);

        Map<String, Long> retMapping = new HashMap<>();

        if (singleQuery) {
            String singleKey = unresolvedKeys.get(0).keySet().stream().findFirst().get();
            Map<String, Collection<Object>> collect = unresolvedKeys.stream().collect(Collectors.groupingBy(x -> {
                Set<String> keys = x.keySet();
                String s = keys.stream().findFirst().get();
                return s;
            }, Collectors.reducing(new ArrayList<>(), x -> x.values(), (l, a) -> {
                l.addAll(a);
                return l;
            })));

            List<ExpNode> conditions = collect.entrySet().stream().map(entry -> {
                return ExpCondition.call(ExpOperator.IN, ExpField.field(entry.getKey()), ExpValue.from(entry.getValue().stream().distinct().collect(Collectors.toList())));
            }).collect(Collectors.toList());

            ExpQuery query = new ExpQuery().filters(conditions).range(1, 1000);
            Either<QueryResult, DataCollection<Record>> result = entityFacade.query(mainClass, query, contextMap).toCompletableFuture().join();
            if (result.isRight() && !result.get().getRows().isEmpty()) {
                DataCollection<Record> records = result.get();
                List<Record> rows = records.getRows();
                rows.forEach(record -> {
                    Long id = record.getId();

                    record.get(singleKey).ifPresent(m -> {
                        putIndexMapping(contextMap, relatedCode, m.toString(), id);
                        retMapping.put(m.toString(), id);
                    });
                });
            } else {
                collect.values().stream().flatMap(x -> x.stream()).forEach(s -> {
                    putIndexMapping(contextMap, relatedCode, s.toString(), -1L);
                });
            }
        } else {
            throw new RuntimeException("currently Not supported multi");
        }

        return retMapping;
    }

    /**
     * consume in transaction
     *
     * @param entityClassGroup
     * @param useBatch
     * @param timeout
     * @param step
     * @param inputStream
     * @param isAsync
     * @param orderedCode
     * @param appId
     * @throws IOException
     */
    public void consumeStep(IEntityClassGroup entityClassGroup, boolean useBatch, int timeout, int step, InputStream
            inputStream, boolean isAsync, List<String> orderedCode, String appId) throws IOException {
        if (step <= 0) {
            step = defaultStep;
        }

        XSSFWorkbook xssfwb = new XSSFWorkbook(inputStream);
        IEntityClass entityClass = entityClassGroup.getEntityClass();


        int numberOfSheets = xssfwb.getNumberOfSheets();


        try {
            Map<String, Object> contextMap = Optional.ofNullable(contextService)
                    .map(ContextService::getAll)
                    .orElseGet(Collections::emptyMap);

            contextMap.put("index", new HashMap());

            if (numberOfSheets > 1) {

                //do 1 to n insert
                XSSFSheet mainSheet = xssfwb.getSheetAt(0);

                if (mainSheet != null) {
                    List<String> relatedCode = new ArrayList<>();
                    for (int i = 1; i < numberOfSheets; i++) {
                        XSSFSheet sheetAt = xssfwb.getSheetAt(i);
                        prepareRelatedHeader(sheetAt, contextMap, entityClassGroup);
                        if (orderedCode.isEmpty()) {
                            relatedCode.add(sheetAt.getSheetName());
                        } else {
                            relatedCode = orderedCode;
                        }
                    }

                    /**
                     * no batch way the context is full with index
                     * batch way query in further
                     */
                    insertMain(entityClass, mainSheet, relatedCode, useBatch, step, contextMap);

                    for (int i = 1; i < numberOfSheets; i++) {
                        XSSFSheet sheetAt = xssfwb.getSheetAt(i);
                        String code;
                        if (orderedCode.isEmpty()) {
                            code = sheetAt.getSheetName();
                        } else {
                            //TODO maybe not safe
                            code = orderedCode.get(i - 1);
                        }
                        Optional<IEntityClass> iEntityClass = entityClassGroup.relatedEntityClass(code);
                        int finalStep = step;
                        iEntityClass.ifPresent(relatedEntityClass -> {
                            insertRelated(entityClass, relatedEntityClass, code, sheetAt, contextMap, useBatch, finalStep);
                        });
                    }

                    Map<String, Object> notifyContext = new HashMap<>();
                    notifyContext.put("appId", appId);
                    publisher.publishEvent(new EntityImported(isAsync ? "async" : "sync", entityClass.code(), entityClass.code(), notifyContext, contextMap));
                }
            } else {
                //do one insert
                XSSFSheet sheetAt = xssfwb.getSheetAt(0);

                Map<String, Object> map = new HashMap<>();
                Row headerRow = null;
                boolean isFirstRow = true;
                Short size = 0;
                int count = 0;
                if (sheetAt != null) {

                    Iterator<Row> rowIterator = sheetAt.rowIterator();

                    while (rowIterator.hasNext()) {
                        Row row = rowIterator.next();
                        if (isFirstRow) {
                            headerRow = row;
                            isFirstRow = false;
                            size = headerRow.getLastCellNum();
                            continue;
                        }

                        int i;
                        map.clear();
                        for (i = 0; i < size; i++) {
                            Cell cell = row.getCell(i);
                            map.put(getBoFieldCodeFromExcelHeader(headerRow.getCell(i).getStringCellValue(), entityClass)
                                    , cell == null ? null : readCellRawValue(cell));
                        }

                        //--------------------------------------------------------
                        if (count % step == 0) {
                            String transKey = contextService.get(ContextKeys.StringKeys.TRANSACTION_KEY);
                            if (transKey != null) {
                                ((DefaultTransactionManager) manager).commit(transKey);
                            }

                            //then start new
                            OqsTransaction newTransaction = ((DefaultTransactionManager) manager).createNewTransaction(timeout, "");
                            contextService.set(ContextKeys.StringKeys.TRANSACTION_KEY, newTransaction.getId());
                            count = 0;
                        }

                        Optional<Validation<String, Map<String, Object>>> first = postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, map, contextMap))
                                .filter(Validation::isInvalid).findFirst();
                        if (!first.isPresent()) {
                            entityFacade.create(entityClass, map, contextMap).toCompletableFuture()
                                    .thenApplyAsync(x -> x, importThreadPool).join();
                            count++;
                        } else {
                            logger.error("{}, {}, {} is not execute", entityClass.code(), map, contextMap);
                        }
                    }

                    //close
                    String transKey = contextService.get(ContextKeys.StringKeys.TRANSACTION_KEY);
                    if (transKey != null) {
                        ((DefaultTransactionManager) manager).commit(transKey);
                    }

                    //do throw EntityImported
                    //String importType, String code, String filename, Map<String, Object> notifyContext
                    Map<String, Object> notifyContext = new HashMap<>();
                    notifyContext.put("appId", appId);
                    publisher.publishEvent(new EntityImported(isAsync ? "async" : "sync", entityClass.code(), entityClass.code(), notifyContext, contextMap));
                }
            }
        } finally {
            xssfwb.close();
        }
    }
}
