package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import akka.NotUsed;
import akka.stream.javadsl.Source;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.oqsengine.pojo.constants.SystemField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.GeneralRecord;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.ResultStatus;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.*;
import com.xforceplus.ultraman.oqsengine.sdk.service.core.ExecutionConfig;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ClassifiedRecord;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSource;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import io.vavr.control.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

/**
 * default export source
 * a sequence is a single schema source
 */
public class SequenceExportSource implements ExportSource {

    private Logger logger = LoggerFactory.getLogger(ExportSource.class);

    /**
     * step
     */
    private final int step;

    private final int maxRetryTimes = 5;

    private final EntityFacade entityService;

    private final ContextService contextService;

    private final ExecutionConfig config;

    public SequenceExportSource(
            EntityFacade entityService
            , int step
            , ContextService contextService
            , ExecutionConfig config) {
        this.entityService = entityService;
        this.step = step;
        this.contextService = contextService;
        this.config = config;
    }

    //TODO union one?
    private <T> T get(CompletionStage<T> future) {
        return future
                .toCompletableFuture()
                .join();
    }

    @Override
    public boolean isAccept(IEntityClass entityClass, boolean multiSchema, Map<String, Object> context) {
        return !multiSchema;
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Source<ClassifiedRecord, NotUsed> source(String classifier, IEntityClass entityClass, ExpRel expRel, Map<String, ExpRel> subQuery, Map<String, Object> context) {



        Object user = context.get("user");

        AtomicInteger cursor = new AtomicInteger(0);
        AtomicInteger error = new AtomicInteger(0);

        String tag = Optional.ofNullable(classifier).orElseGet(entityClass::code);

        //last record id for search
        AtomicLong lastId = new AtomicLong(0);

//        Map<String, Object> contextMap = null;
//        if (contextService != null) {
//            contextMap = contextService.getAll();
//        }

//        Map<String, Object> finalContextMap = contextMap;
        return Source.repeat(1).flatMapConcat(i -> {
            if(user != null) {
                UserInfoHolder.put((IAuthorizedUser) user);
            }

            try {

                if (contextService != null && context != null) {
                    contextService.fromMap(context);
                }

                logger.info("-----Export {}:{} ---- query {} times ----with last id {}", entityClass.code()
                        , entityClass.id()
                        , cursor.getAndIncrement()
                        , lastId.get());

                //always
                Either<String, DataCollection<Record>> byCondition =
                        get(entityService.query(entityClass
                                , toNewExpRel(expRel, step, lastId.get()),
                                Optional
                                        .ofNullable(contextService)
                                        .map(ContextService::getAll)
                                        .orElseGet(Collections::emptyMap)
                        )).mapLeft(ResultStatus::getMessage);

                if (contextService != null) {
                    contextService.clear();
                }

                if (byCondition.isRight()) {
                    //clear error
                    error.set(0);
                    List<Record> ret = byCondition.get().getRows();
                    logger.warn("-----Export {}:{} ---- clear error and found size is {} ----", entityClass.code(), entityClass.id(), ret.size());

                    if (ret.size() < step) {
                        //end here
                        LinkedList<Record> list = new LinkedList<>(ret);
                        list.addLast(GeneralRecord.empty());
                        return Source.from(list.stream().map(r -> ClassifiedRecord.of(tag, r)).collect(Collectors.toList()));
                    } else {
                        //go on
                        Record lastRecord = ret.get(ret.size() - 1);
                        if (lastRecord != null) {
                            lastId.set(lastRecord.getId());
                        }
                        return Source.from(ret.stream().map(r -> ClassifiedRecord.of(tag, r)).collect(Collectors.toList()));
                    }
                } else {
                    logger.warn("-----Export {}:{} ---- found error {} ----", entityClass.code(), entityClass.id(), byCondition.getLeft());
                    if (error.getAndIncrement() < maxRetryTimes) {
                        return Source.empty();
                    } else {
                        return Source.single(ClassifiedRecord.of(tag, GeneralRecord.empty()));
                    }
                }
            } catch (Throwable throwable) {
                logger.error("{}", throwable);
                //throw throwable;
                return Source.empty();
            } finally {
                UserInfoHolder.clearContext();
            }
        }).takeWhile(t -> t != null && t.getRecord().nonEmpty());
    }

    /**
     * side-effect
     *
     * @param rawQuery
     * @param pageSize
     * @param lastId
     * @return
     */
    public ExpRel toNewExpRel(ExpRel rawQuery, int pageSize, Long lastId) {

        ExpQuery query = (ExpQuery) rawQuery;

        query.range(1, pageSize);

        /**
         * remove sort
         */
        logger.debug("[Export]Remove Sort");
        query.sort(ExpSort.init().withSort("id", "asc"));

        //replace new id condition
        ExpCondition idCondition = ExpCondition.call(
                ExpOperator.GREATER_THAN
                , ExpField.field(SystemField.ID.getName())
                , ExpValue.from(lastId));
        //only find out one
        List<ExpNode> filters = query.getFilters();

        if (!filters.isEmpty()) {
            //only find if the last is append in preview
            ExpNode expNode = filters.get(filters.size() - 1);
            if (expNode != null) {
                ExpCondition condition = (ExpCondition) expNode;
                if (condition.isSimpleClauseWithFieldName(SystemField.ID.getName())
                        && condition.getOperator() == ExpOperator.GREATER_THAN) {
                    filters.remove(condition);
                }
            }

            filters.add(idCondition);
        } else {
            filters.add(idCondition);
        }

        return rawQuery;
    }
}
