/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.sdk.command.ImportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.entity.ImportResult;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.enums.ImportModeEnum;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;

public interface ImportService {
    public ImportModeEnum getImportMode();

    public ImportResult doImport(IEntityClassGroup var1, ImportCmd var2);

    default public String getBoFieldCodeFromExcelHeader(String excelHeader, int colIndex, List<ImportCmd.Sheet.FieldMapping> fieldMappings, String boCode) {
        return this.getBoFieldCodeFromExcelHeader(excelHeader, colIndex, fieldMappings, boCode, false);
    }

    default public String getBoFieldCodeFromExcelHeader(String excelHeader, int colIndex, List<ImportCmd.Sheet.FieldMapping> fieldMappings, String boCode, Boolean isOnlyMatchMapping) {
        int start = excelHeader.indexOf("[");
        int end = excelHeader.indexOf("]");
        String name = null;
        if (start >= 0 && end >= 0) {
            return excelHeader.substring(start + 1, end);
        }
        name = excelHeader;
        ImportCmd.Sheet.FieldMapping targetFiledMapping = null;
        if (fieldMappings.get(colIndex).getHeader().equals(name)) {
            targetFiledMapping = fieldMappings.get(colIndex);
        }
        if (!isOnlyMatchMapping.booleanValue() && targetFiledMapping == null) {
            String finalName = name;
            Optional<ImportCmd.Sheet.FieldMapping> first = fieldMappings.stream().filter(fieldMapping -> fieldMapping.getHeader().equals(finalName)).findFirst();
            if (first.isPresent()) {
                targetFiledMapping = first.get();
            }
        }
        if (targetFiledMapping != null) {
            if (boCode.equals(targetFiledMapping.getBoCode())) {
                return targetFiledMapping.getCode();
            }
            return targetFiledMapping.getBoCode() + "." + targetFiledMapping.getCode();
        }
        return null;
    }

    default public String getBoFieldCodeFromExcelHeader(String headerPart, IEntityClass entityClass) {
        int start = headerPart.indexOf("[");
        int end = headerPart.indexOf("]");
        if (start < 0 || end < 0) {
            Optional<IEntityField> first = entityClass.fields().stream().filter(filed -> filed.cnName() != null && filed.cnName().equals(headerPart.trim())).findFirst();
            if (first.isPresent()) {
                return first.get().name();
            }
            return headerPart;
        }
        return headerPart.substring(start + 1, end);
    }

    default public Object readCellRawValue(Cell cell) {
        Object rawValue = null;
        if (cell.getCellType() == CellType.FORMULA) {
            switch (cell.getCachedFormulaResultType()) {
                case BOOLEAN: {
                    rawValue = cell.getBooleanCellValue();
                    break;
                }
                case NUMERIC: {
                    rawValue = BigDecimal.valueOf(cell.getNumericCellValue());
                    break;
                }
                case STRING: {
                    rawValue = cell.getStringCellValue();
                    break;
                }
            }
        } else {
            rawValue = cell.getCellType() == CellType.BOOLEAN ? Boolean.valueOf(cell.getBooleanCellValue()) : (cell.getCellType() == CellType.NUMERIC ? (DateUtil.isCellDateFormatted((Cell)cell) ? Long.valueOf(cell.getLocalDateTimeCellValue().atZone(DateTimeValue.zoneId.systemDefault()).toInstant().toEpochMilli()) : BigDecimal.valueOf(cell.getNumericCellValue())) : (cell.getCellType() == CellType.STRING ? cell.getStringCellValue() : null));
        }
        return rawValue;
    }
}

