/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export;

import com.xforceplus.ultraman.oqsengine.sdk.service.export.ImportService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.enums.ImportModeEnum;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;

public class ImportServiceFactory
implements InitializingBean {
    private final Map<ImportModeEnum, ImportService> importServiceMap;

    public ImportServiceFactory(List<ImportService> importServiceList) {
        this.importServiceMap = importServiceList.stream().collect(Collectors.toMap(ImportService::getImportMode, Function.identity()));
    }

    public ImportService getImportService(String importModeEnumCode) {
        return this.importServiceMap.get((Object)ImportModeEnum.getByCode(importModeEnumCode));
    }

    public void afterPropertiesSet() throws Exception {
        if (this.importServiceMap.isEmpty()) {
            throw new RuntimeException("ImportServiceFactory\u521d\u59cb\u5316\u5931\u8d25");
        }
    }
}

