/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.controller;

import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSink;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ImportTemplateService;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RequestMapping(value={"/download/"})
public class DefaultDownloadController {
    private final ExportSink exportSink;
    private final ImportTemplateService importTemplateService;

    public DefaultDownloadController(ExportSink exportSink, ImportTemplateService importTemplateService) {
        this.exportSink = exportSink;
        this.importTemplateService = importTemplateService;
    }

    @GetMapping(value={"/file/template/{uuid}"})
    public ResponseEntity<StreamingResponseBody> downloadTemplateFile(@PathVariable String uuid, @RequestParam(value="filename", required=false) String filename, @RequestParam(required=false, value="type", defaultValue="xlsx") String fileType) {
        InputStream templateStream = null;
        MediaType mediaType = null;
        String innerFileName = null;
        innerFileName = filename != null ? filename : uuid;
        try {
            templateStream = this.importTemplateService.getCustomTemplateInputStream(uuid);
            mediaType = MediaType.APPLICATION_OCTET_STREAM;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InputStream finalTemplateStream = templateStream;
        StreamingResponseBody responseBody = outputStream -> {
            StreamUtils.copy((InputStream)finalTemplateStream, (OutputStream)outputStream);
            outputStream.close();
        };
        String encodedName = innerFileName;
        try {
            encodedName = URLEncoder.encode(innerFileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + encodedName + "." + fileType})).contentType(mediaType).body((Object)responseBody);
    }

    @GetMapping(value={"/file/{token}"})
    public ResponseEntity<StreamingResponseBody> uploadFile(@PathVariable String token, @RequestParam(value="filename", required=false) String filename, @RequestParam(required=false, value="type", defaultValue="xls") String fileType) {
        InputStream input = null;
        MediaType mediaType = null;
        String innerFileName = null;
        innerFileName = filename != null ? filename : token;
        try {
            input = this.exportSink.getInputStream(token, fileType);
            mediaType = MediaType.APPLICATION_OCTET_STREAM;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InputStream finalInput = input;
        StreamingResponseBody responseBody = outputStream -> {
            StreamUtils.copy((InputStream)finalInput, (OutputStream)outputStream);
            outputStream.close();
        };
        String encodedName = innerFileName;
        try {
            encodedName = URLEncoder.encode(innerFileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + encodedName + "." + fileType})).contentType(mediaType).body((Object)responseBody);
    }
}

