/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ImportResult {
    private Integer successCount = 0;
    private Integer failedCount = 0;
    private Integer totalCount = 0;
    private List<SheetImportResult> sheetImportResultList;

    public void summary() {
        for (SheetImportResult sheetImportResult : this.sheetImportResultList) {
            ImportResult importResult = this;
            Integer.valueOf(importResult.successCount + sheetImportResult.getSuccessCount().get());
            importResult.successCount = importResult.successCount;
            importResult = this;
            Integer.valueOf(importResult.failedCount + sheetImportResult.getFailedCount().get());
            importResult.failedCount = importResult.failedCount;
            importResult = this;
            Integer.valueOf(importResult.totalCount + sheetImportResult.getTotalCount());
            importResult.totalCount = importResult.totalCount;
        }
    }

    public String toHumanFormatString() {
        String format = "\u5bfc\u5165\u6210\u529f%s\u6761\uff0c\u5bfc\u5165\u5931\u8d25%s\u6761\uff0c\u603b\u8ba1%s\u6761\u3002";
        String sheetFormat = "\n\u8868\u5355\u3010%s\u3011\uff0c\u5bfc\u5165\u5bf9\u8c61\u3010%s\u3011\uff0c\u5bfc\u5165\u6210\u529f%s\u6761\uff0c\u5bfc\u5165\u5931\u8d25%s\u6761\uff0c\u8868\u5355\u5c0f\u8ba1%s\u6761\u3002";
        String errorListFormat = "\u5bfc\u5165\u5931\u8d25\u5217\u8868\uff1a";
        String errorRowFormat = "\n\u7b2c%s\u884c\uff1a%s\uff1b";
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(format, this.successCount, this.failedCount, this.totalCount));
        if (this.failedCount > 0) {
            if (this.sheetImportResultList == null) {
                return null;
            }
            this.sheetImportResultList.forEach(sheetImportResult -> {
                StringBuilder sb1 = new StringBuilder();
                if (this.sheetImportResultList.size() > 1) {
                    sb1.append(String.format(sheetFormat, sheetImportResult.getSheetName(), ((SheetImportResult)sheetImportResult).boCode, sheetImportResult.getSuccessCount(), sheetImportResult.getFailedCount(), sheetImportResult.getTotalCount()));
                }
                if (sheetImportResult.getFailedCount().get() > 0) {
                    sb1.append(errorListFormat);
                    StringBuilder sb2 = new StringBuilder();
                    sheetImportResult.getRowImportErrorResultList().forEach(rowImportErrorResult2 -> sb2.append(String.format(errorRowFormat, rowImportErrorResult2.getRowIndex(), rowImportErrorResult2.getErrorMsg())));
                    sb1.append((CharSequence)sb2);
                }
                sb.append((CharSequence)sb1);
            });
        }
        if (sb.length() > 1000) {
            return sb.substring(0, 1000) + "...\uff08\u957f\u5ea6\u8d85\u8fc71000\u540e\u7701\u7565\uff09";
        }
        return sb.toString();
    }

    public Integer getSuccessCount() {
        return this.successCount;
    }

    public Integer getFailedCount() {
        return this.failedCount;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public List<SheetImportResult> getSheetImportResultList() {
        return this.sheetImportResultList;
    }

    public void setSuccessCount(Integer successCount) {
        this.successCount = successCount;
    }

    public void setFailedCount(Integer failedCount) {
        this.failedCount = failedCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public void setSheetImportResultList(List<SheetImportResult> sheetImportResultList) {
        this.sheetImportResultList = sheetImportResultList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportResult)) {
            return false;
        }
        ImportResult other = (ImportResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$successCount = this.getSuccessCount();
        Integer other$successCount = other.getSuccessCount();
        if (this$successCount == null ? other$successCount != null : !((Object)this$successCount).equals(other$successCount)) {
            return false;
        }
        Integer this$failedCount = this.getFailedCount();
        Integer other$failedCount = other.getFailedCount();
        if (this$failedCount == null ? other$failedCount != null : !((Object)this$failedCount).equals(other$failedCount)) {
            return false;
        }
        Integer this$totalCount = this.getTotalCount();
        Integer other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        List<SheetImportResult> this$sheetImportResultList = this.getSheetImportResultList();
        List<SheetImportResult> other$sheetImportResultList = other.getSheetImportResultList();
        return !(this$sheetImportResultList == null ? other$sheetImportResultList != null : !((Object)this$sheetImportResultList).equals(other$sheetImportResultList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImportResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $successCount = this.getSuccessCount();
        result = result * 59 + ($successCount == null ? 43 : ((Object)$successCount).hashCode());
        Integer $failedCount = this.getFailedCount();
        result = result * 59 + ($failedCount == null ? 43 : ((Object)$failedCount).hashCode());
        Integer $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        List<SheetImportResult> $sheetImportResultList = this.getSheetImportResultList();
        result = result * 59 + ($sheetImportResultList == null ? 43 : ((Object)$sheetImportResultList).hashCode());
        return result;
    }

    public String toString() {
        return "ImportResult(successCount=" + this.getSuccessCount() + ", failedCount=" + this.getFailedCount() + ", totalCount=" + this.getTotalCount() + ", sheetImportResultList=" + this.getSheetImportResultList() + ")";
    }

    public static class SheetImportResult {
        private String boCode;
        private String sheetName;
        private AtomicInteger successCount = new AtomicInteger(0);
        private AtomicInteger failedCount = new AtomicInteger(0);
        private Integer totalCount = 0;
        private String errorMsg;
        private List<rowImportErrorResult> rowImportErrorResultList = new ArrayList<rowImportErrorResult>();

        public void addErrorResult(Integer rowIndex, String errorMsg) {
            if (this.rowImportErrorResultList.size() >= 20) {
                this.errorMsg = "\u9519\u8bef\u884c\u4fe1\u606f\u8fc7\u591a\uff0c\u53ea\u6536\u96c6\u524d20\u6761";
                return;
            }
            this.rowImportErrorResultList.add(new rowImportErrorResult(rowIndex, errorMsg));
        }

        public String getBoCode() {
            return this.boCode;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public AtomicInteger getSuccessCount() {
            return this.successCount;
        }

        public AtomicInteger getFailedCount() {
            return this.failedCount;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public List<rowImportErrorResult> getRowImportErrorResultList() {
            return this.rowImportErrorResultList;
        }

        public void setBoCode(String boCode) {
            this.boCode = boCode;
        }

        public void setSheetName(String sheetName) {
            this.sheetName = sheetName;
        }

        public void setSuccessCount(AtomicInteger successCount) {
            this.successCount = successCount;
        }

        public void setFailedCount(AtomicInteger failedCount) {
            this.failedCount = failedCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public void setRowImportErrorResultList(List<rowImportErrorResult> rowImportErrorResultList) {
            this.rowImportErrorResultList = rowImportErrorResultList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SheetImportResult)) {
                return false;
            }
            SheetImportResult other = (SheetImportResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$totalCount = this.getTotalCount();
            Integer other$totalCount = other.getTotalCount();
            if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
                return false;
            }
            String this$boCode = this.getBoCode();
            String other$boCode = other.getBoCode();
            if (this$boCode == null ? other$boCode != null : !this$boCode.equals(other$boCode)) {
                return false;
            }
            String this$sheetName = this.getSheetName();
            String other$sheetName = other.getSheetName();
            if (this$sheetName == null ? other$sheetName != null : !this$sheetName.equals(other$sheetName)) {
                return false;
            }
            AtomicInteger this$successCount = this.getSuccessCount();
            AtomicInteger other$successCount = other.getSuccessCount();
            if (this$successCount == null ? other$successCount != null : !this$successCount.equals(other$successCount)) {
                return false;
            }
            AtomicInteger this$failedCount = this.getFailedCount();
            AtomicInteger other$failedCount = other.getFailedCount();
            if (this$failedCount == null ? other$failedCount != null : !this$failedCount.equals(other$failedCount)) {
                return false;
            }
            String this$errorMsg = this.getErrorMsg();
            String other$errorMsg = other.getErrorMsg();
            if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
                return false;
            }
            List<rowImportErrorResult> this$rowImportErrorResultList = this.getRowImportErrorResultList();
            List<rowImportErrorResult> other$rowImportErrorResultList = other.getRowImportErrorResultList();
            return !(this$rowImportErrorResultList == null ? other$rowImportErrorResultList != null : !((Object)this$rowImportErrorResultList).equals(other$rowImportErrorResultList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SheetImportResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $totalCount = this.getTotalCount();
            result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
            String $boCode = this.getBoCode();
            result = result * 59 + ($boCode == null ? 43 : $boCode.hashCode());
            String $sheetName = this.getSheetName();
            result = result * 59 + ($sheetName == null ? 43 : $sheetName.hashCode());
            AtomicInteger $successCount = this.getSuccessCount();
            result = result * 59 + ($successCount == null ? 43 : $successCount.hashCode());
            AtomicInteger $failedCount = this.getFailedCount();
            result = result * 59 + ($failedCount == null ? 43 : $failedCount.hashCode());
            String $errorMsg = this.getErrorMsg();
            result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
            List<rowImportErrorResult> $rowImportErrorResultList = this.getRowImportErrorResultList();
            result = result * 59 + ($rowImportErrorResultList == null ? 43 : ((Object)$rowImportErrorResultList).hashCode());
            return result;
        }

        public String toString() {
            return "ImportResult.SheetImportResult(boCode=" + this.getBoCode() + ", sheetName=" + this.getSheetName() + ", successCount=" + this.getSuccessCount() + ", failedCount=" + this.getFailedCount() + ", totalCount=" + this.getTotalCount() + ", errorMsg=" + this.getErrorMsg() + ", rowImportErrorResultList=" + this.getRowImportErrorResultList() + ")";
        }

        public static class rowImportErrorResult {
            private Integer rowIndex;
            private String errorMsg;

            public rowImportErrorResult(Integer rowIndex, String errorMsg) {
                this.rowIndex = rowIndex;
                this.errorMsg = errorMsg;
            }

            public Integer getRowIndex() {
                return this.rowIndex;
            }

            public String getErrorMsg() {
                return this.errorMsg;
            }

            public void setRowIndex(Integer rowIndex) {
                this.rowIndex = rowIndex;
            }

            public void setErrorMsg(String errorMsg) {
                this.errorMsg = errorMsg;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof rowImportErrorResult)) {
                    return false;
                }
                rowImportErrorResult other = (rowImportErrorResult)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$rowIndex = this.getRowIndex();
                Integer other$rowIndex = other.getRowIndex();
                if (this$rowIndex == null ? other$rowIndex != null : !((Object)this$rowIndex).equals(other$rowIndex)) {
                    return false;
                }
                String this$errorMsg = this.getErrorMsg();
                String other$errorMsg = other.getErrorMsg();
                return !(this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg));
            }

            protected boolean canEqual(Object other) {
                return other instanceof rowImportErrorResult;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $rowIndex = this.getRowIndex();
                result = result * 59 + ($rowIndex == null ? 43 : ((Object)$rowIndex).hashCode());
                String $errorMsg = this.getErrorMsg();
                result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
                return result;
            }

            public String toString() {
                return "ImportResult.SheetImportResult.rowImportErrorResult(rowIndex=" + this.getRowIndex() + ", errorMsg=" + this.getErrorMsg() + ")";
            }
        }
    }
}

