/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import akka.NotUsed;
import akka.japi.function.Creator;
import akka.japi.function.Function;
import akka.japi.function.Procedure;
import akka.stream.ActorMaterializer;
import akka.stream.Materializer;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.stream.javadsl.StreamConverters;
import akka.util.ByteString;
import builders.dsl.spreadsheet.builder.poi.PoiSpreadsheetBuilder;
import builders.dsl.spreadsheet.parser.data.json.JsonSpreadsheetParser;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.ColumnField;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ClassifiedRecord;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportCallBack;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSchemaConfig;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSink;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSource;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportStringTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.FormattedString;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.config.ExportExcelConfig;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.impl.AbstractEntityExportService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.impl.excel.PoiCopySheet;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelEntityExportServiceImpl
extends AbstractEntityExportService {
    private ExportExcelConfig excelConfig;
    private final ActorMaterializer mat;
    private ExecutorService executorService;
    private Logger logger = LoggerFactory.getLogger(ExcelEntityExportServiceImpl.class);

    public ExcelEntityExportServiceImpl(List<ExportSource> exportSourceList, ExportSink exportSink, ExportCallBack callBack, ExportStringTransformer transformer, ExportExcelConfig excelConfig, ActorMaterializer mat, ExecutorService executorService) {
        super(exportSourceList, exportSink, transformer, callBack, mat);
        this.mat = mat;
        this.excelConfig = excelConfig;
        this.executorService = executorService;
    }

    @Override
    public boolean isAccept(String extension) {
        return "xlsx".equals(extension) || "xls".equals(extension);
    }

    @Override
    public boolean isSupportMultiSchema() {
        return true;
    }

    @Override
    public String generateFileType() {
        return "xlsx";
    }

    @Override
    public Source<ByteString, ?> toByteStringSource(List<Tuple2<String, IEntityClass>> entityClasses, Source<ClassifiedRecord, NotUsed> rawSource, Map<String, ExportSchemaConfig> schemaMapping, boolean isSkipTransformer, Map<String, Object> context) {
        Object template = context.get("template");
        InputStream inputStreamCompletionStage = (InputStream)rawSource.runWith(this.excelSink(entityClasses, schemaMapping, isSkipTransformer, context, Optional.ofNullable(template).map(Object::toString).orElse(null)), (Materializer)this.mat);
        Source source = StreamConverters.fromInputStream((Creator & Serializable)() -> inputStreamCompletionStage);
        return source;
    }

    private void prepareSheet(SXSSFWorkbook wb, List<Tuple2<String, IEntityClass>> entityClasses, Map<String, ExportSchemaConfig> schemaMapping, Map<String, Tuple2<Sheet, AtomicInteger>> sheetMapping) {
        entityClasses.forEach(entityClassTuple -> {
            String sheetCode = (String)entityClassTuple._1();
            Tuple2 sheetTuple = (Tuple2)sheetMapping.get(sheetCode);
            ExportSchemaConfig schemaConfig = (ExportSchemaConfig)schemaMapping.get(sheetCode);
            Map mapping = Optional.ofNullable(schemaConfig).map(ExportSchemaConfig::getNameMapping).orElseGet(Collections::emptyMap);
            String sheetName = Optional.ofNullable(mapping.get(sheetCode)).map(FormattedString::getText).orElse(sheetCode);
            if (sheetTuple == null) {
                SXSSFSheet sheet = wb.createSheet(sheetName);
                AtomicInteger linesInSheet = new AtomicInteger(1);
                sheetTuple = Tuple.of((Object)sheet, (Object)linesInSheet);
                sheetMapping.put(sheetCode, sheetTuple);
                this.insertHeader((Sheet)sheet, schemaConfig, (IEntityClass)entityClassTuple._2());
            }
        });
    }

    private void insertHeader(Sheet sheet, ExportSchemaConfig schemaConfig, IEntityClass entityClass) {
        Row row = sheet.createRow(0);
        List<String> orderedColumn = Optional.ofNullable(schemaConfig).map(x -> x.getOrderedColumn()).orElseGet(Collections::emptyList);
        if (orderedColumn.isEmpty()) {
            orderedColumn = entityClass.fields().stream().map(field -> field.name()).collect(Collectors.toList());
        }
        Map nameMappings = Optional.ofNullable(schemaConfig).map(x -> x.getNameMapping()).orElseGet(Collections::emptyMap);
        orderedColumn = orderedColumn.stream().map(x -> x.startsWith("_") ? x.substring(1) : x).collect(Collectors.toList());
        AtomicInteger cellIndex = new AtomicInteger(0);
        orderedColumn.forEach(x -> {
            Cell cell = row.createCell(cellIndex.getAndIncrement());
            String key = x;
            String columnName = Optional.ofNullable(nameMappings).flatMap(np -> Optional.ofNullable(np.get(key)).map(FormattedString::getText)).orElse(x);
            cell.setCellValue(Optional.ofNullable(columnName).orElse(key));
        });
    }

    private void insertCell(Record record, Row row, List<String> orderedColumn, Map<String, Object> context, boolean isSkipTransformer, Map<Integer, CellStyle> columnNumberFormatStyles, Map<String, FormattedString> mapping) {
        AtomicInteger ai = new AtomicInteger(0);
        List normalizeOrderedColumn = orderedColumn.stream().map(x -> {
            if (x.startsWith("_")) {
                return x.substring(1);
            }
            return x;
        }).collect(Collectors.toList());
        Stream<String> reNormalizeOrderedColumn = normalizeOrderedColumn.stream().map(x -> {
            if (x.contains(".")) {
                return "_".concat((String)x);
            }
            return x;
        });
        if (normalizeOrderedColumn.isEmpty()) {
            record.stream(normalizeOrderedColumn).forEach(x -> {
                Cell cell = row.createCell(ai.getAndIncrement());
                ColumnField field = (ColumnField)x._1();
                IEntityClass entityClass = field.originEntityClass();
                if (x._2() != null) {
                    try {
                        String value = x._2().toString();
                        if (!isSkipTransformer) {
                            value = this.getStringValue(entityClass, (IEntityField)field, x._2().toString(), context, mapping);
                        }
                        if (field.originField().type().equals((Object)FieldType.DECIMAL)) {
                            this.setNumberFormatStyleAndCellValue(cell, columnNumberFormatStyles, field.originField().config(), new BigDecimal(value));
                        } else {
                            cell.setCellValue(value);
                        }
                    }
                    catch (Exception ex) {
                        this.logger.error("{}", (Throwable)ex);
                        cell.setBlank();
                        cell.setCellErrorValue(FormulaError.VALUE.getCode());
                    }
                }
            });
        } else {
            List columnList = record.stream(orderedColumn).collect(Collectors.toList());
            orderedColumn.forEach(x -> {
                Cell cell = row.createCell(ai.getAndIncrement());
                Optional<Tuple2> columnOp = columnList.stream().filter(col -> ((IEntityField)col._1).acceptName(x)).findFirst();
                if (columnOp.isPresent()) {
                    ColumnField field = (ColumnField)columnOp.get()._1();
                    IEntityClass entityClass = field.originEntityClass();
                    if (columnOp.get()._2() != null) {
                        try {
                            String value = columnOp.get()._2().toString();
                            if (!isSkipTransformer) {
                                value = this.getStringValue(entityClass, (IEntityField)field, columnOp.get()._2().toString(), context, mapping);
                            }
                            if (field.originField().type().equals((Object)FieldType.DECIMAL)) {
                                this.setNumberFormatStyleAndCellValue(cell, columnNumberFormatStyles, field.originField().config(), new BigDecimal(value));
                            } else {
                                cell.setCellValue(value);
                            }
                        }
                        catch (Exception ex) {
                            this.logger.error("{}", (Throwable)ex);
                            cell.setBlank();
                            cell.setCellErrorValue(FormulaError.VALUE.getCode());
                        }
                    }
                }
            });
        }
    }

    private void insertInDefaultWorkBook(ClassifiedRecord tuple, Map<String, Tuple2<Sheet, AtomicInteger>> sheetMapping, Map<String, ExportSchemaConfig> schemaMapping, Workbook wb, Map<String, Object> context, boolean isSkipTransformer, Map<Integer, CellStyle> columnNumberFormatStyles) {
        try {
            String sheetCode = tuple.getClassifyStr();
            Tuple2 sheetTuple = sheetMapping.get(sheetCode);
            Record record = tuple.getRecord();
            ExportSchemaConfig schemaConfig = schemaMapping.get(sheetCode);
            Map mapping = Optional.ofNullable(schemaConfig).map(ExportSchemaConfig::getNameMapping).orElseGet(Collections::emptyMap);
            List orderedColumn = Optional.ofNullable(schemaConfig).map(x -> x.getOrderedColumn()).orElseGet(Collections::emptyList);
            String sheetName = Optional.ofNullable(mapping.get(sheetCode)).map(FormattedString::getText).orElse(sheetCode);
            if (sheetTuple == null) {
                Sheet sheet = wb.createSheet(sheetName);
                AtomicInteger linesInSheet = new AtomicInteger(0);
                sheetTuple = Tuple.of((Object)sheet, (Object)linesInSheet);
                sheetMapping.put(sheetCode, (Tuple2<Sheet, AtomicInteger>)sheetTuple);
            }
            Row row = ((Sheet)sheetTuple._1).createRow(((AtomicInteger)sheetTuple._2).getAndIncrement());
            this.insertCell(record, row, orderedColumn, context, isSkipTransformer, columnNumberFormatStyles, mapping);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean isTrigger(Row dynamicRow, ClassifiedRecord record) {
        Iterator cellIterator = dynamicRow.cellIterator();
        while (cellIterator.hasNext()) {
            Cell next = (Cell)cellIterator.next();
            if (next.getCellType() != CellType.STRING || !next.getStringCellValue().startsWith("$") && !next.getStringCellValue().startsWith("@")) continue;
            String dynamicVariable = next.getStringCellValue();
            Tuple2<String, String> parsed = this.parseVariable(dynamicVariable);
            String classifyStr = record.getClassifyStr();
            if (!((String)parsed._1).equalsIgnoreCase(classifyStr)) continue;
            return true;
        }
        return false;
    }

    public void renderTemplate(Workbook wb, ClassifiedRecord record, Map<String, Object> context, boolean isSkipTransformer, Map<Integer, CellStyle> columnNumberFormatStyles, Map<String, ExportSchemaConfig> schemaMapping) {
        int numberOfSheets = wb.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            Sheet sheetAt = wb.getSheetAt(i);
            ExportSchemaConfig schemaConfig = schemaMapping.get(sheetAt.getSheetName());
            Map mapping = Optional.ofNullable(schemaConfig).map(ExportSchemaConfig::getNameMapping).orElseGet(Collections::emptyMap);
            String sheetIndexName = this.getSheetIndexName(sheetAt, i);
            Object rowTemplate = context.get(sheetIndexName);
            List dynamicRows = (List)rowTemplate;
            if (dynamicRows.isEmpty()) continue;
            Tuple2 cursorMapping = (Tuple2)dynamicRows.get(0);
            AtomicInteger nextIndex = (AtomicInteger)cursorMapping._1();
            Row dynamicRow = (Row)cursorMapping._2;
            if (!this.isTrigger(dynamicRow, record)) continue;
            Row row = sheetAt.createRow(nextIndex.getAndIncrement());
            Iterator cellIterator = dynamicRow.cellIterator();
            int cellIndex = 0;
            while (cellIterator.hasNext()) {
                Cell next = (Cell)cellIterator.next();
                Cell cell = row.createCell(cellIndex++);
                if (next.getCellType() == CellType.STRING && (next.getStringCellValue().startsWith("$") || next.getStringCellValue().startsWith("@"))) {
                    String dynamicVariable = next.getStringCellValue();
                    this.insertSingleCell(dynamicVariable, record, cell, isSkipTransformer, columnNumberFormatStyles, mapping, context);
                    continue;
                }
                this.copyFromCell(next, cell);
            }
        }
    }

    private Tuple2<String, String> parseVariable(String dynamicVariable) {
        if (dynamicVariable.startsWith("@")) {
            int varPos = dynamicVariable.indexOf(".");
            if (varPos != -1) {
                String classifier = dynamicVariable.substring(1, varPos);
                return Tuple.of((Object)classifier, (Object)dynamicVariable.substring(varPos + 1));
            }
            return Tuple.of((Object)"", (Object)dynamicVariable);
        }
        return Tuple.of((Object)"", (Object)dynamicVariable);
    }

    private void insertSingleCell(String dynamicVariable, ClassifiedRecord record, Cell cell, boolean isSkipTransformer, Map<Integer, CellStyle> columnNumberFormatStyles, Map<String, FormattedString> mapping, Map<String, Object> context) {
        try {
            Tuple2 t;
            List target;
            String fieldCode;
            String classifyStr = record.getClassifyStr();
            Tuple2<String, String> parsedVariable = this.parseVariable(dynamicVariable);
            String checked = (String)parsedVariable._1;
            if (!classifyStr.equals(checked)) {
                return;
            }
            String realDynamicVariable = (String)parsedVariable._2;
            String[] parts = realDynamicVariable.split("\\.");
            Optional<Object> fieldOp = Optional.empty();
            Optional<Object> valueOp = Optional.empty();
            if (parts.length == 1) {
                fieldCode = realDynamicVariable.substring(1);
                target = record.getRecord().stream(Arrays.asList(fieldCode)).collect(Collectors.toList());
                if (!target.isEmpty()) {
                    t = (Tuple2)target.get(0);
                    fieldOp = Optional.of((ColumnField)t._1);
                    valueOp = Optional.of(t._2);
                }
            } else if (parts.length == 2) {
                if (realDynamicVariable.startsWith("$src.") && record.getSourceRecord() != null) {
                    fieldCode = realDynamicVariable.substring("$src.".length());
                    target = record.getSourceRecord().stream(Arrays.asList(fieldCode)).collect(Collectors.toList());
                    if (!target.isEmpty()) {
                        t = (Tuple2)target.get(0);
                        fieldOp = Optional.of((ColumnField)t._1);
                        valueOp = Optional.of(t._2);
                    }
                } else {
                    fieldCode = realDynamicVariable.substring(1);
                    target = record.getRecord().stream(Arrays.asList(fieldCode)).collect(Collectors.toList());
                    if (!target.isEmpty()) {
                        t = (Tuple2)target.get(0);
                        fieldOp = Optional.of((ColumnField)t._1);
                        valueOp = Optional.of(t._2);
                    }
                }
            }
            if (fieldOp.isPresent() && valueOp.isPresent()) {
                ColumnField columnField = (ColumnField)fieldOp.get();
                Object rawValue = valueOp.get();
                String value = rawValue.toString();
                if (!isSkipTransformer) {
                    value = this.getStringValue(columnField.originEntityClass(), columnField.getOriginObject(), valueOp.get(), context, mapping);
                }
                if (columnField.getOriginObject().type().equals((Object)FieldType.DECIMAL)) {
                    this.setNumberFormatStyleAndCellValue(cell, columnNumberFormatStyles, columnField.getOriginObject().config(), new BigDecimal(rawValue.toString()));
                } else {
                    cell.setCellValue(value);
                }
            } else {
                cell.setCellValue(dynamicVariable);
            }
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
            cell.setBlank();
            cell.setCellErrorValue(FormulaError.VALUE.getCode());
        }
    }

    private void copyFromCell(Cell srcCell, Cell dstCell) {
        switch (srcCell.getCellType()) {
            case STRING: {
                dstCell.setCellValue(srcCell.getStringCellValue());
                break;
            }
            case NUMERIC: {
                dstCell.setCellValue(srcCell.getNumericCellValue());
                break;
            }
            case BLANK: {
                dstCell.setBlank();
                break;
            }
            case BOOLEAN: {
                dstCell.setCellValue(srcCell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                dstCell.setCellErrorValue(srcCell.getErrorCellValue());
                break;
            }
            case FORMULA: {
                dstCell.setCellFormula(srcCell.getCellFormula());
                break;
            }
        }
    }

    private void prepareTemplateContext(Workbook wb, Map<String, Object> context) {
        Iterator sheetIterator = wb.sheetIterator();
        int i = 0;
        while (sheetIterator.hasNext()) {
            Sheet sheet = (Sheet)sheetIterator.next();
            ArrayList<Tuple2> dynamicRow = new ArrayList<Tuple2>();
            Iterator rowIterator = sheet.rowIterator();
            while (rowIterator.hasNext()) {
                Row next = (Row)rowIterator.next();
                Iterator cellIterator = next.cellIterator();
                ArrayList<Cell> tempList = new ArrayList<Cell>();
                boolean isDynamicRow = false;
                while (cellIterator.hasNext()) {
                    String stringCellValue;
                    Cell targetCell = (Cell)cellIterator.next();
                    tempList.add(targetCell);
                    if (targetCell.getCellType() != CellType.STRING || !(stringCellValue = targetCell.getStringCellValue()).startsWith("$") && !stringCellValue.startsWith("@")) continue;
                    isDynamicRow = true;
                }
                if (!isDynamicRow) continue;
                dynamicRow.add(Tuple.of((Object)new AtomicInteger(next.getRowNum()), (Object)next));
            }
            context.put(this.getSheetIndexName(sheet, i), dynamicRow);
            ++i;
        }
    }

    private String getSheetIndexName(Sheet sheet, int i) {
        return sheet.getSheetName() + "_$" + i;
    }

    public Sink<ClassifiedRecord, InputStream> excelSink(List<Tuple2<String, IEntityClass>> entityClasses, Map<String, ExportSchemaConfig> schemaMapping, boolean isSkipTransformer, Map<String, Object> context, String template) {
        SXSSFWorkbook wb = new SXSSFWorkbook(this.excelConfig.getInMemRow().intValue());
        PipedOutputStream out = new PipedOutputStream();
        PipedInputStream in = new PipedInputStream();
        AtomicBoolean useTemplate = new AtomicBoolean(false);
        ConcurrentHashMap<String, Tuple2<Sheet, AtomicInteger>> sheetMapping = null;
        File tempTemplateFile = null;
        XSSFWorkbook templateWB = null;
        if (StringUtils.isEmpty((CharSequence)template)) {
            sheetMapping = new ConcurrentHashMap<String, Tuple2<Sheet, AtomicInteger>>(36);
            this.prepareSheet(wb, entityClasses, schemaMapping, sheetMapping);
        } else {
            try {
                tempTemplateFile = File.createTempFile("excel-template", "xls");
                JsonSpreadsheetParser parser = new JsonSpreadsheetParser(PoiSpreadsheetBuilder.create((File)tempTemplateFile));
                parser.parse(IOUtils.toInputStream((String)template, (Charset)StandardCharsets.UTF_8));
                templateWB = new XSSFWorkbook(tempTemplateFile);
                Iterator sheetIterator = templateWB.sheetIterator();
                while (sheetIterator.hasNext()) {
                    Sheet next = (Sheet)sheetIterator.next();
                    PoiCopySheet.copySheet(next, (Sheet)wb.createSheet(next.getSheetName()));
                }
                try {
                    templateWB.close();
                    tempTemplateFile.delete();
                }
                catch (Throwable throwable) {
                    this.logger.error("{}", throwable);
                }
                this.prepareTemplateContext((Workbook)wb, context);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            useTemplate.set(true);
        }
        try {
            in.connect(out);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        Map<Integer, CellStyle> columnNumberFormatStyles = this.generateColumnNumberFormatStyles((Workbook)wb);
        ConcurrentHashMap<String, Tuple2<Sheet, AtomicInteger>> finalSheetMapping = sheetMapping;
        Sink excelSink = Sink.foreach((Procedure & Serializable)tuple -> {
            if (useTemplate.get()) {
                this.renderTemplate((Workbook)wb, (ClassifiedRecord)tuple, context, isSkipTransformer, columnNumberFormatStyles, schemaMapping);
            } else {
                this.insertInDefaultWorkBook((ClassifiedRecord)tuple, (Map<String, Tuple2<Sheet, AtomicInteger>>)finalSheetMapping, schemaMapping, (Workbook)wb, context, isSkipTransformer, columnNumberFormatStyles);
            }
        }).mapMaterializedValue((Function & Serializable)x -> {
            x.thenRunAsync(() -> {
                try {
                    wb.write((OutputStream)out);
                    wb.close();
                    wb.dispose();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, this.executorService);
            return in;
        });
        return excelSink;
    }

    private Map<Integer, CellStyle> generateColumnNumberFormatStyles(Workbook wb) {
        HashMap<Integer, CellStyle> result = new HashMap<Integer, CellStyle>();
        String formatTemplate = "000000000000000000000000000000";
        for (int precision = 0; precision < 20; ++precision) {
            CellStyle cellStyle = wb.createCellStyle();
            DataFormat dataFormat = wb.createDataFormat();
            if (precision > 19) {
                precision = 19;
            }
            if (result.containsKey(precision)) continue;
            StringBuilder format = new StringBuilder();
            format.append("0");
            if (precision > 0) {
                format.append(".");
                format.append(formatTemplate.substring(0, precision));
            }
            cellStyle.setDataFormat(dataFormat.getFormat(format.toString()));
            result.put(precision, cellStyle);
        }
        return result;
    }

    private void setNumberFormatStyleAndCellValue(Cell cell, Map<Integer, CellStyle> columnNumberFormatStyles, FieldConfig fieldConfig, BigDecimal value) {
        String plainStringValue;
        int precition = fieldConfig.getPrecision();
        if (precition > 19) {
            precition = 19;
        }
        if ((plainStringValue = value.toPlainString()).length() > 15) {
            if (plainStringValue.indexOf(46) > -1) {
                plainStringValue = plainStringValue.replaceAll("(0)+$", "");
            }
            plainStringValue = new BigDecimal(plainStringValue.replaceAll("\\.", "")).toPlainString();
        }
        if (plainStringValue.length() > 15) {
            cell.setCellValue(value.toString());
            return;
        }
        CellStyle cellStyle = columnNumberFormatStyles.get(fieldConfig.getPrecision());
        cellStyle = columnNumberFormatStyles.get(precition);
        if (cellStyle == null) {
            throw new Exception("\u6570\u503c\u683c\u5f0f\u5316\u6837\u5f0f\u4e22\u5931,index: " + fieldConfig.getPrecision());
        }
        cell.setCellStyle(cellStyle);
        cell.setCellValue(value.doubleValue());
    }
}

