/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.command.ImportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityImported;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.CreateOneResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.ResultStatus;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ImportService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.PostImportAware;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.entity.ImportResult;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.enums.ImportModeEnum;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.DefaultTransactionManager;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransaction;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransactionManager;
import com.xforceplus.ultraman.oqsengine.sdk.util.CompletableFutureUtils;
import io.vavr.control.Either;
import io.vavr.control.Validation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;

public class ImportDefaultExcelServiceImpl
implements ImportService {
    private final Logger logger = LoggerFactory.getLogger(ImportService.class);
    protected EntityFacade entityFacade;
    protected ContextService contextService;
    protected ExecutorService importThreadPool;
    protected OqsTransactionManager manager;
    protected ApplicationEventPublisher publisher;
    @Autowired(required=false)
    List<PostImportAware> postImportAwareList = new ArrayList<PostImportAware>();
    private int defaultStep = 1000;

    public ImportDefaultExcelServiceImpl(EntityFacade entityFacade, ContextService contextService, ExecutorService importThreadPool, OqsTransactionManager manager, ApplicationEventPublisher publisher) {
        this.entityFacade = entityFacade;
        this.contextService = contextService;
        this.importThreadPool = importThreadPool;
        this.manager = manager;
        this.publisher = publisher;
    }

    @Override
    public ImportModeEnum getImportMode() {
        return ImportModeEnum.BASE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportResult doImport(IEntityClassGroup entityClassGroup, ImportCmd cmd) {
        int step = cmd.getStep();
        if (step <= 0) {
            step = this.defaultStep;
        }
        XSSFWorkbook xssfwb = null;
        try {
            xssfwb = new XSSFWorkbook(cmd.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IEntityClass entityClass = entityClassGroup.getEntityClass();
        int numberOfSheets = xssfwb.getNumberOfSheets();
        try {
            Map contextRelatedHeaderMap = Optional.ofNullable(this.contextService).map(ContextService::getAll).orElseGet(Collections::emptyMap);
            contextRelatedHeaderMap.put("index", new HashMap());
            XSSFSheet mainSheet = xssfwb.getSheetAt(0);
            if (mainSheet == null) {
                throw new RuntimeException("main sheet is null");
            }
            ArrayList<String> relatedCode = new ArrayList<String>();
            if (numberOfSheets > 1) {
                for (int i = 1; i < numberOfSheets; ++i) {
                    XSSFSheet sheetAt = xssfwb.getSheetAt(i);
                    this.prepareRelatedHeader(sheetAt, contextRelatedHeaderMap, entityClassGroup);
                    relatedCode.add(sheetAt.getSheetName());
                }
            }
            ArrayList<CompletableFuture<Either>> futures = new ArrayList<CompletableFuture<Either>>();
            Iterator rowIterator = mainSheet.rowIterator();
            HashMap<String, Object> rowContentMap = new HashMap<String, Object>();
            Row headerRow = null;
            boolean isFirstRow = true;
            int lastCellNum = 0;
            ArrayList<ImportCmd.Sheet.FieldMapping> headerFiledMapping = new ArrayList<ImportCmd.Sheet.FieldMapping>();
            if (CollectionUtil.isNotEmpty((Collection)cmd.getSheets())) {
                Optional<ImportCmd.Sheet> sheetHeaderOptional = cmd.getSheets().stream().filter(sheetItem -> mainSheet.getSheetName().equals(sheetItem.getSheet())).findFirst();
                headerFiledMapping = sheetHeaderOptional.isPresent() ? sheetHeaderOptional.get().getFieldMapping() : new ArrayList();
            }
            ArrayList<String> headerFiledCodeList = new ArrayList<String>();
            int currentBatchCount = 0;
            while (rowIterator.hasNext()) {
                CompletableFuture<Either> insertResult;
                Row row = (Row)rowIterator.next();
                if (isFirstRow) {
                    headerRow = row;
                    isFirstRow = false;
                    lastCellNum = headerRow.getLastCellNum();
                    for (int j = 0; j < lastCellNum; ++j) {
                        if (headerFiledMapping.size() > 0 && j < headerFiledMapping.size()) {
                            headerFiledCodeList.add(this.getBoFieldCodeFromExcelHeader(headerRow.getCell(j).getStringCellValue(), j, headerFiledMapping, entityClass.code()));
                            continue;
                        }
                        headerFiledCodeList.add(this.getBoFieldCodeFromExcelHeader(headerRow.getCell(j).getStringCellValue(), entityClass));
                    }
                    continue;
                }
                rowContentMap.clear();
                for (int i = 0; i < lastCellNum; ++i) {
                    Cell cell = row.getCell(i);
                    rowContentMap.put((String)headerFiledCodeList.get(i), cell == null ? null : this.readCellRawValue(cell));
                }
                Optional<Validation> first = this.postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, rowContentMap, contextRelatedHeaderMap)).filter(Validation::isInvalid).findFirst();
                if (!first.isPresent()) {
                    insertResult = this.entityFacade.create(entityClass, rowContentMap, contextRelatedHeaderMap).toCompletableFuture().thenApplyAsync(x -> x, (Executor)this.importThreadPool);
                    ++currentBatchCount;
                } else {
                    Validation validation = first.get();
                    insertResult = CompletableFuture.completedFuture(Either.left((Object)CreateOneResult.from((Throwable)new RuntimeException((String)validation.getError()))));
                }
                Either join = insertResult.join();
                if (currentBatchCount % step == 0) {
                    String transKey = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
                    if (transKey != null) {
                        ((DefaultTransactionManager)this.manager).commit(transKey);
                    }
                    OqsTransaction newTransaction = ((DefaultTransactionManager)this.manager).createNewTransaction(cmd.getTimeout(), "");
                    this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY, (Object)newTransaction.getId());
                    currentBatchCount = 0;
                }
                ArrayList<String> finalRelatedCodeList = relatedCode;
                if (join.isRight()) {
                    for (String related : finalRelatedCodeList) {
                        this.buildRelatedIndex(related, contextRelatedHeaderMap, rowContentMap, (Long)join.get());
                    }
                } else if (((CreateOneResult)join.getLeft()).getOriginCause() == ResultStatus.OriginStatus.HALF_SUCCESS) {
                    this.logger.warn("Half success detect {}", (Object)((CreateOneResult)join.getLeft()).getErrorMap());
                    for (String related : finalRelatedCodeList) {
                        this.buildRelatedIndex(related, contextRelatedHeaderMap, rowContentMap, ((CreateOneResult)join.getLeft()).getId());
                    }
                } else {
                    throw new RuntimeException(((CreateOneResult)join.getLeft()).getMessage());
                }
                futures.add(insertResult);
            }
            String transKey = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
            if (transKey != null && currentBatchCount > 0) {
                ((DefaultTransactionManager)this.manager).commit(transKey);
            }
            CompletableFuture sequence = CompletableFutureUtils.sequence(futures);
            XSSFWorkbook finalXssfwb = xssfwb;
            sequence.thenAccept(result -> {
                for (int i = 1; i < numberOfSheets; ++i) {
                    XSSFSheet sheetAt = finalXssfwb.getSheetAt(i);
                    String code = sheetAt.getSheetName();
                    Optional iEntityClass = entityClassGroup.relatedEntityClass(code);
                    this.insertRelated((IEntityClass)iEntityClass.get(), sheetAt, contextRelatedHeaderMap, cmd.getSheets(), cmd.getToManyRelations());
                }
            });
            if (!cmd.isAsync()) {
                sequence.join();
            }
            sequence.thenRun(() -> {
                HashMap<String, String> notifyContext = new HashMap<String, String>();
                notifyContext.put("appId", cmd.getAppId());
                this.publisher.publishEvent((Object)new EntityImported(cmd.isAsync() ? "async" : "sync", entityClass.code(), entityClass.code(), notifyContext, contextRelatedHeaderMap));
            });
        }
        finally {
            try {
                xssfwb.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private List<CompletableFuture<Either<CreateOneResult, Long>>> insertRelated(IEntityClass entityClass, XSSFSheet sheet, Map<String, Object> contextMap, List<ImportCmd.Sheet> sheets, List<ImportCmd.ToManyRelation> toManyRelations) {
        String sheetName = sheet.getSheetName();
        ArrayList<CompletableFuture<Either<CreateOneResult, Long>>> futures = new ArrayList<CompletableFuture<Either<CreateOneResult, Long>>>();
        ArrayList<ImportCmd.Sheet.FieldMapping> headerFiledMapping = new ArrayList<ImportCmd.Sheet.FieldMapping>();
        if (CollectionUtil.isNotEmpty(sheets)) {
            Optional<ImportCmd.Sheet> sheetHeaderOptional = sheets.stream().filter(sheetItem -> sheet.getSheetName().equals(sheetItem.getSheet())).findFirst();
            headerFiledMapping = sheetHeaderOptional.isPresent() ? sheetHeaderOptional.get().getFieldMapping() : new ArrayList();
        }
        ArrayList<String> headerFiledCodeList = new ArrayList<String>();
        ArrayList<Integer> relationCodeColIndexList = new ArrayList<Integer>();
        Row headerRow = null;
        int size = 0;
        Iterator rowIterator = sheet.rowIterator();
        while (rowIterator.hasNext()) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            Row row = (Row)rowIterator.next();
            if (headerRow == null) {
                headerRow = row;
                size = headerRow.getLastCellNum();
                for (int j = 0; j < size; ++j) {
                    Cell headerCell = headerRow.getCell(j);
                    if (headerCell.getCellComment() != null && ((List)contextMap.get(sheetName)).contains(headerCell.getCellComment().getString().getString())) {
                        relationCodeColIndexList.add(j);
                    }
                    if (headerFiledMapping.size() > 0 && j < headerFiledMapping.size()) {
                        headerFiledCodeList.add(this.getBoFieldCodeFromExcelHeader(headerRow.getCell(j).getStringCellValue(), j, headerFiledMapping, entityClass.code()));
                        continue;
                    }
                    headerFiledCodeList.add(this.getBoFieldCodeFromExcelHeader(headerRow.getCell(j).getStringCellValue(), entityClass));
                }
                continue;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) continue;
                Object rawValue = this.readCellRawValue(cell);
                if (relationCodeColIndexList.contains(i)) {
                    if (sb.length() > 0) {
                        sb.append("%^%");
                    }
                    sb.append(rawValue);
                }
                map.put(headerFiledCodeList.get(i), cell == null ? null : rawValue);
            }
            String s = sb.toString();
            Map<String, Long> indexMapping = this.getRelatedIndexMapping(contextMap, sheetName);
            Long related = indexMapping.get(s);
            if (related == null) {
                this.logger.warn("{} has no related value, body: {}", (Object)sheetName, map);
            } else {
                map.put(sheetName.concat(".id"), related);
            }
            Optional<Validation> first = this.postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, map, contextMap)).filter(Validation::isInvalid).findFirst();
            if (!first.isPresent()) {
                CompletionStage insertResult = this.entityFacade.create(entityClass, map, contextMap).toCompletableFuture().thenApplyAsync(x -> x, (Executor)this.importThreadPool);
                futures.add((CompletableFuture<Either<CreateOneResult, Long>>)insertResult);
                continue;
            }
            this.logger.error("{}, {}, {} is not execute", new Object[]{entityClass.code(), map, contextMap});
            futures.add(CompletableFuture.completedFuture(Either.left((Object)CreateOneResult.from((Throwable)new RuntimeException("Skip")))));
        }
        return futures;
    }

    protected Map<String, Long> getRelatedIndexMapping(Map<String, Object> context, String code) {
        Object index = context.get("index");
        if (index != null) {
            Map indexMapping = (Map)index;
            return Optional.ofNullable(indexMapping.get(code)).orElseGet(Collections::emptyMap);
        }
        return Collections.emptyMap();
    }

    protected void buildRelatedIndex(String code, Map<String, Object> contextMap, Map<String, Object> body, long id) {
        Object index = contextMap.get("index");
        Object codeMapping = contextMap.get(code);
        if (index != null && codeMapping != null) {
            Map indexMapping = (Map)index;
            List relatedCodeList = (List)codeMapping;
            HashMap<String, Long> indexCodeRelatedMapping = (HashMap<String, Long>)indexMapping.get(code);
            if (indexCodeRelatedMapping == null) {
                indexCodeRelatedMapping = new HashMap<String, Long>();
            }
            indexMapping.put(code, indexCodeRelatedMapping);
            String collect = relatedCodeList.stream().map(x -> body.get(x)).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining("%^%"));
            Long prev = indexCodeRelatedMapping.put(collect, id);
            if (prev != null) {
                throw new RuntimeException("has same related value " + relatedCodeList + ":" + collect);
            }
        }
    }

    private boolean isValid(String code, IEntityClassGroup group) {
        Optional column = group.column(code);
        return column.isPresent();
    }

    protected void prepareRelatedHeader(XSSFSheet sheet, Map<String, Object> contextRelatedHeaderMap, IEntityClassGroup entityClassGroup) {
        int firstRowNum = sheet.getFirstRowNum();
        String sheetName = sheet.getSheetName();
        if (firstRowNum >= 0) {
            XSSFRow row = sheet.getRow(firstRowNum);
            Short size = row.getLastCellNum();
            for (int i = 0; i < size; ++i) {
                XSSFCell cell = row.getCell(i);
                Comment cellComment = cell.getCellComment();
                if (cellComment == null) continue;
                Optional<String> codeOp = Optional.ofNullable(cellComment.getString()).map(RichTextString::getString);
                codeOp.filter(code -> this.isValid((String)code, entityClassGroup)).ifPresent(code -> contextRelatedHeaderMap.compute(sheetName, (k, v) -> {
                    if (v == null) {
                        v = new ArrayList();
                    }
                    ((List)v).add(code);
                    return v;
                }));
            }
        } else {
            throw new RuntimeException("do not has row");
        }
    }
}

