/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import akka.japi.function.Creator;
import akka.stream.ActorMaterializer;
import akka.stream.Materializer;
import akka.stream.javadsl.Source;
import akka.stream.javadsl.StreamConverters;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.service.DictService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSink;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ImportService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ImportTemplateService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.PostImportAware;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransactionManager;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.DictItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.NameMapping;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;

public class ImportDefaultExcelTemplateServiceImpl
implements ImportTemplateService {
    private Logger logger = LoggerFactory.getLogger(ImportService.class);
    protected EntityFacade entityFacade;
    protected ContextService contextService;
    protected ExecutorService importThreadPool;
    protected OqsTransactionManager manager;
    private ActorMaterializer mat;
    @Autowired
    public ApplicationEventPublisher publisher;
    @Autowired(required=false)
    List<PostImportAware> postImportAwareList = new ArrayList<PostImportAware>();
    private int defaultStep = 1000;
    @Autowired
    private DictService dictService;
    private final String MULTI_ENUM = "\u8bf7\u9009\u62e9\u4e00\u9879\u6216\u8005\u591a\u9879, \u4ee5,\u53f7\u9694\u5f00:\n\n%s\n\n \u5b58\u5728\u591a\u4e2a, \u8bf7\u4ee5,\u53f7\u9694\u5f00";
    private ExportSink sink;

    public ImportDefaultExcelTemplateServiceImpl(EntityFacade entityFacade, ContextService contextService, ExportSink sink, ActorMaterializer mat, ExecutorService importThreadPool, OqsTransactionManager manager) {
        this.entityFacade = entityFacade;
        this.contextService = contextService;
        this.importThreadPool = importThreadPool;
        this.sink = sink;
        this.mat = mat;
        this.manager = manager;
    }

    @Override
    public String fileType() {
        return "xlsx";
    }

    @Override
    public String fileName(IEntityClass entityClass) {
        return entityClass.name() + "-template";
    }

    @Override
    public InputStream getTemplateInputStream(IEntityClassGroup reader, boolean skipSystem) {
        IEntityClass entityClass = reader.getEntityClass();
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet mainSheet = workbook.createSheet(entityClass.name());
        XSSFRow headerRow = mainSheet.createRow(0);
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        AtomicInteger index = new AtomicInteger(0);
        cellStyle.setFillForegroundColor(IndexedColors.LIGHT_ORANGE.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        short dataFormatIndex = workbook.createDataFormat().getFormat("yyyy-m-dd h:mm:ss");
        XSSFCellStyle dateStyle = workbook.createCellStyle();
        dateStyle.setDataFormat(dataFormatIndex);
        List<IEntityField> fields = reader.getAllFields().stream().filter(x -> !skipSystem || x.config() == null || !x.config().isSystem()).collect(Collectors.toList());
        fields.forEach(field -> {
            int currentIndex = index.getAndIncrement();
            XSSFCell cell = headerRow.createCell(currentIndex);
            List duplicateCnNameField = fields.stream().filter(fieldInner -> fieldInner.cnName() != null && fieldInner.cnName().equals(field.cnName())).collect(Collectors.toList());
            if (duplicateCnNameField.size() > 1) {
                cell.setCellValue(Optional.ofNullable(field.cnName()).orElse(field.name()) + "[" + field.name() + "]");
            } else {
                cell.setCellValue(Optional.ofNullable(field.cnName()).orElse(field.name()));
            }
            this.setCellStyle(workbook, mainSheet, (IEntityField)field, currentIndex, cell);
            mainSheet.autoSizeColumn(currentIndex);
        });
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private List<IEntityField> getOrderedFieldsFromNameMapping(List<NameMapping> mappingList, List<IEntityField> fields) {
        if (mappingList == null || mappingList.isEmpty()) {
            return fields;
        }
        return mappingList.stream().map(x -> {
            Optional<IEntityField> first = fields.stream().filter(field -> field.name().equals(x.getCode())).findFirst();
            return first;
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCustomTemplate(IEntityClassGroup reader, List<NameMapping> mappingList, Map<String, Tuple3<List<NameMapping>, List<NameMapping>, String>> subMapping) {
        IEntityClass entityClass = reader.getEntityClass();
        XSSFWorkbook workbook = new XSSFWorkbook();
        Map<String, String> nameMapping = mappingList.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x.getText(), (a, b) -> a));
        this.renderSheet(workbook, entityClass.name(), this.getOrderedFieldsFromNameMapping(mappingList, reader.getAllFields()), nameMapping, null, null);
        subMapping.forEach((code, subRelMapping) -> {
            List relationMapping = (List)subRelMapping._2();
            List mapping = (List)subRelMapping._1();
            Map<String, String> subNameMapping = mapping.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x.getText(), (a, b) -> a));
            Optional relatedEntityClassOp = reader.relatedEntityClass(code);
            if (relatedEntityClassOp.isPresent()) {
                IEntityClass relatedEntityClass = (IEntityClass)relatedEntityClassOp.get();
                IEntityClassGroup relatedGroup = this.entityFacade.getReader(relatedEntityClass, this.contextService.getAll());
                this.renderSheet(workbook, (String)subRelMapping._3, this.getOrderedFieldsFromNameMapping(mapping, relatedGroup.getAllFields()), subNameMapping, relationMapping, entityClass);
            }
        });
        String fileName = this.fileName(reader.getEntityClass());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String uuid = UUID.randomUUID().toString();
        try {
            workbook.write((OutputStream)byteArrayOutputStream);
        }
        catch (IOException e) {
            this.logger.error("{}", (Throwable)e);
        }
        Source source = StreamConverters.fromInputStream((Creator & Serializable)() -> new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        Tuple2 xlsx = (Tuple2)((CompletionStage)source.runWith(this.sink.getSink("xlsx", uuid, fileName), (Materializer)this.mat)).toCompletableFuture().join();
        return this.sink.getDownloadUrl("xlsx", (String[])xlsx._2);
    }

    private void renderSheet(XSSFWorkbook workbook, String name, List<IEntityField> fields, Map<String, String> nameMapping, List<NameMapping> additionalCell, IEntityClass mainEntityClass) {
        XSSFSheet mainSheet = workbook.createSheet(name);
        XSSFRow headerRow = mainSheet.createRow(0);
        AtomicInteger index = new AtomicInteger(0);
        if (additionalCell != null && !additionalCell.isEmpty()) {
            additionalCell.forEach(x -> {
                IEntityField iEntityField = mainEntityClass.fields().stream().filter(field -> field.name().equals(x.getCode())).findFirst().get();
                int currentIndex = index.getAndIncrement();
                XSSFCell cell = headerRow.createCell(currentIndex);
                String cellName = x.getText();
                String cellCode = x.getCode();
                this.addComment((Workbook)workbook, (Sheet)mainSheet, (Cell)cell, cellCode);
                cell.setCellValue(cellName);
                this.setCellStyle(workbook, mainSheet, iEntityField, currentIndex, cell);
                mainSheet.autoSizeColumn(currentIndex);
            });
        }
        fields.stream().filter(x -> nameMapping.containsKey(x.name())).forEach(field -> {
            int currentIndex = index.getAndIncrement();
            XSSFCell cell = headerRow.createCell(currentIndex);
            String title = Optional.ofNullable(nameMapping.get(field.name())).orElse(field.cnName());
            List duplicateCnNameField = fields.stream().filter(fieldInner -> fieldInner.cnName() != null && fieldInner.cnName().equals(field.cnName())).collect(Collectors.toList());
            if (duplicateCnNameField.size() > 1) {
                cell.setCellValue(title + "[" + field.name() + "]");
            } else {
                cell.setCellValue(title);
            }
            this.setCellStyle(workbook, mainSheet, (IEntityField)field, currentIndex, cell);
            mainSheet.setColumnWidth(currentIndex, title.getBytes().length * 256);
        });
    }

    private void setCellStyle(XSSFWorkbook workbook, XSSFSheet mainSheet, IEntityField field, int currentIndex, XSSFCell cell) {
        XSSFCellStyle headCellStyle = workbook.createCellStyle();
        XSSFCellStyle columnStyle = workbook.createCellStyle();
        try {
            headCellStyle.setBorderBottom(BorderStyle.THIN);
            headCellStyle.setBorderLeft(BorderStyle.THIN);
            headCellStyle.setBorderTop(BorderStyle.THIN);
            headCellStyle.setBorderRight(BorderStyle.THIN);
            headCellStyle.setFillForegroundColor(IndexedColors.LIGHT_GREEN.getIndex());
            headCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            if (field.config().isRequired()) {
                headCellStyle.setFillForegroundColor(IndexedColors.LIGHT_ORANGE.getIndex());
                this.addComment((Workbook)workbook, (Sheet)mainSheet, (Cell)cell, "\u5fc5\u586b\u9879");
            }
            boolean isLongThan15 = false;
            if (field.type() == FieldType.DATETIME) {
                short dataFormatIndex = workbook.createDataFormat().getFormat("yyyy-m-dd h:mm:ss");
                columnStyle.setDataFormat(dataFormatIndex);
            } else if (field.type() == FieldType.ENUM) {
                String dictId = field.dictId();
                List dictItemsByCode = this.dictService.findDictItems(dictId, "");
                List<String> values = dictItemsByCode.stream().map(DictItem::getText).collect(Collectors.toList());
                this.addSelectionList((Sheet)mainSheet, (Cell)cell, values);
            } else if (field.type() == FieldType.STRINGS && StringUtils.isNotEmpty((String)field.dictId())) {
                String dictId = field.dictId();
                List dictItemsByCode = this.dictService.findDictItems(dictId, "");
                List values = dictItemsByCode.stream().map(DictItem::getText).collect(Collectors.toList());
                String comment = String.format("\u8bf7\u9009\u62e9\u4e00\u9879\u6216\u8005\u591a\u9879, \u4ee5,\u53f7\u9694\u5f00:\n\n%s\n\n \u5b58\u5728\u591a\u4e2a, \u8bf7\u4ee5,\u53f7\u9694\u5f00", values.stream().collect(Collectors.joining("\n")));
                this.addComment((Workbook)workbook, (Sheet)mainSheet, (Cell)cell, comment);
            } else if (field.type() == FieldType.BOOLEAN) {
                this.addSelectionList((Sheet)mainSheet, (Cell)cell, Arrays.asList("TRUE", "FALSE"));
            } else if (field.type() == FieldType.DECIMAL) {
                StringBuilder formatBuilder = new StringBuilder();
                formatBuilder.append("0");
                if (field.config().getPrecision() > 0) {
                    formatBuilder.append(".");
                }
                for (int i = 0; i < field.config().getPrecision(); ++i) {
                    formatBuilder.append("0");
                }
                short dataFormat = workbook.createDataFormat().getFormat(formatBuilder.toString());
                columnStyle.setDataFormat(dataFormat);
                this.addDecimalMaxValidation((Sheet)mainSheet, (Cell)cell);
            } else if (field.type() == FieldType.LONG) {
                if (field.config().getMax() <= 15L) {
                    short dataFormat = workbook.createDataFormat().getFormat("#");
                    columnStyle.setDataFormat(dataFormat);
                    this.addIntegerMaxValidation((Sheet)mainSheet, (Cell)cell);
                } else {
                    isLongThan15 = true;
                }
            }
            if (field.type() == FieldType.STRING || field.type() == FieldType.STRINGS || field.type() == FieldType.ENUM || isLongThan15) {
                short stringFormatIndex = workbook.createDataFormat().getFormat("@");
                columnStyle.setDataFormat(stringFormatIndex);
                if (field.config().getMax() > 0L && field.type() != FieldType.ENUM) {
                    this.addTextLengthValidation((Sheet)mainSheet, (Cell)cell, field.config().getMax());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("genCellStyle error", (Throwable)e);
        }
        cell.setCellStyle((CellStyle)headCellStyle);
        mainSheet.setDefaultColumnStyle(currentIndex, (CellStyle)columnStyle);
    }

    public void addComment(Workbook workbook, Sheet sheet, Cell cell, String commentText) {
        CreationHelper factory = workbook.getCreationHelper();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex() + 1);
        anchor.setCol2(cell.getColumnIndex() + 3);
        anchor.setRow1(cell.getRowIndex() + 1);
        anchor.setRow2(cell.getRowIndex() + 3 + commentText.split("\n").length);
        Drawing drawing = sheet.createDrawingPatriarch();
        Comment comment = drawing.createCellComment(anchor);
        comment.setString(factory.createRichTextString(commentText));
        cell.setCellComment(comment);
    }

    public void addSelectionList(Sheet sheet, Cell cell, List<String> enumValues) {
        DataValidationHelper dvHelper = sheet.getDataValidationHelper();
        DataValidationConstraint dvConstraint = dvHelper.createExplicitListConstraint(enumValues.toArray(new String[enumValues.size()]));
        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex() + 1, SpreadsheetVersion.EXCEL2007.getLastRowIndex(), cell.getColumnIndex(), cell.getColumnIndex());
        DataValidation validation = dvHelper.createValidation(dvConstraint, addressList);
        validation.setSuppressDropDownArrow(true);
        validation.setEmptyCellAllowed(true);
        validation.createErrorBox("\u6821\u9a8c\u51fa\u9519", "\u53ea\u80fd\u8f93\u5165\u4e0b\u62c9\u6846\u91cc\u7684\u503c");
        validation.setShowErrorBox(true);
        sheet.addValidationData(validation);
    }

    public void addIntegerMaxValidation(Sheet sheet, Cell cell) {
        DataValidationHelper dvHelper = sheet.getDataValidationHelper();
        DataValidationConstraint integerConstraint = dvHelper.createIntegerConstraint(5, String.valueOf(Long.MAX_VALUE), "");
        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex() + 1, SpreadsheetVersion.EXCEL2007.getLastRowIndex(), cell.getColumnIndex(), cell.getColumnIndex());
        DataValidation validation = dvHelper.createValidation(integerConstraint, addressList);
        validation.setEmptyCellAllowed(true);
        validation.createErrorBox("\u6821\u9a8c\u51fa\u9519", "\u53ea\u80fd\u8f93\u5165\u6574\u6570");
        validation.setShowErrorBox(true);
        sheet.addValidationData(validation);
    }

    public void addDecimalMaxValidation(Sheet sheet, Cell cell) {
        DataValidationHelper dvHelper = sheet.getDataValidationHelper();
        DataValidationConstraint integerConstraint = dvHelper.createDecimalConstraint(5, String.valueOf(Long.MAX_VALUE), "");
        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex() + 1, SpreadsheetVersion.EXCEL2007.getLastRowIndex(), cell.getColumnIndex(), cell.getColumnIndex());
        DataValidation validation = dvHelper.createValidation(integerConstraint, addressList);
        validation.setEmptyCellAllowed(true);
        validation.createErrorBox("\u6821\u9a8c\u51fa\u9519", "\u53ea\u80fd\u8f93\u5165\u6570\u5b57");
        validation.setShowErrorBox(true);
        sheet.addValidationData(validation);
    }

    public void addTextLengthValidation(Sheet sheet, Cell cell, Long maxLength) {
        DataValidationHelper dvHelper = sheet.getDataValidationHelper();
        DataValidationConstraint textLengthConstraint = dvHelper.createTextLengthConstraint(7, String.valueOf(Long.MAX_VALUE), "");
        textLengthConstraint.setFormula1(String.valueOf(maxLength));
        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex() + 1, SpreadsheetVersion.EXCEL2007.getLastRowIndex(), cell.getColumnIndex(), cell.getColumnIndex());
        DataValidation validation = dvHelper.createValidation(textLengthConstraint, addressList);
        validation.setEmptyCellAllowed(true);
        validation.createErrorBox("\u6821\u9a8c\u51fa\u9519", "\u8d85\u8fc7\u6700\u5927\u957f\u5ea6" + maxLength);
        validation.setShowErrorBox(true);
        sheet.addValidationData(validation);
    }

    @Override
    public InputStream getCustomTemplateInputStream(String uuid) {
        return this.sink.getInputStream(uuid, this.fileType());
    }
}

