/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.command.ImportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityImported;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.CreateMultiResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.CreateOneResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.ResultStatus;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ImportService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.PostImportAware;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.entity.ImportResult;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.enums.ImportModeEnum;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.DefaultTransactionManager;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransaction;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransactionManager;
import com.xforceplus.ultraman.oqsengine.sdk.util.SnowflakeLongIdGenerator;
import io.vavr.control.Either;
import io.vavr.control.Validation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;

public class ImportWizardExcelServiceImpl
implements ImportService {
    private final Logger logger = LoggerFactory.getLogger(ImportService.class);
    protected EntityFacade entityFacade;
    protected ContextService contextService;
    protected ExecutorService importThreadPool;
    protected OqsTransactionManager manager;
    protected ApplicationEventPublisher publisher;
    @Autowired(required=false)
    List<PostImportAware> postImportAwareList = new ArrayList<PostImportAware>();
    SnowflakeLongIdGenerator snowflakeLongIdGenerator;
    private int defaultStep = 1000;

    public ImportWizardExcelServiceImpl(EntityFacade entityFacade, ContextService contextService, ExecutorService importThreadPool, OqsTransactionManager manager, ApplicationEventPublisher publisher) {
        this.entityFacade = entityFacade;
        this.contextService = contextService;
        this.importThreadPool = importThreadPool;
        this.manager = manager;
        this.publisher = publisher;
        this.snowflakeLongIdGenerator = new SnowflakeLongIdGenerator(new Random(System.currentTimeMillis()).nextInt(1000));
    }

    @Override
    public ImportModeEnum getImportMode() {
        return ImportModeEnum.WIZARD;
    }

    @Override
    public ImportResult doImport(IEntityClassGroup entityClassGroup, ImportCmd cmd) {
        if (cmd.getStep() <= 0) {
            cmd.setStep(this.defaultStep);
        }
        ImportResult importResult = new ImportResult();
        importResult.setSheetImportResultList(new ArrayList<ImportResult.SheetImportResult>());
        XSSFWorkbook xssfwb = null;
        try {
            xssfwb = new XSSFWorkbook(cmd.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IEntityClass mainEntityClass = entityClassGroup.getEntityClass();
        String transKey = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        if (transKey == null) {
            OqsTransaction newTransaction = ((DefaultTransactionManager)this.manager).createNewTransaction(cmd.getTimeout(), "");
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY, (Object)newTransaction.getId());
            transKey = newTransaction.getId();
        }
        try {
            Map<String, Object> contextMap = this.getContextRelatedHeaderMap(cmd);
            contextMap.put(ContextKeys.StringKeys.TRANSACTION_KEY.name(), transKey);
            List sheetsConfigList = cmd.getSheets();
            for (int i = 0; i < sheetsConfigList.size(); ++i) {
                this.insertMain(entityClassGroup, xssfwb.getSheetAt(i), contextMap, (ImportCmd.Sheet)sheetsConfigList.get(i), cmd, importResult);
                this.insertRelated(entityClassGroup, xssfwb.getSheetAt(i), contextMap, (ImportCmd.Sheet)sheetsConfigList.get(i), cmd, importResult);
            }
            importResult.summary();
            HashMap<String, String> notifyContext = new HashMap<String, String>();
            notifyContext.put("appId", cmd.getAppId());
            notifyContext.put("importResultInfo", importResult.toHumanFormatString());
            this.logger.info(JSONUtil.toJsonStr((Object)importResult));
            this.logger.info(importResult.toHumanFormatString());
            this.publisher.publishEvent((Object)new EntityImported(cmd.isAsync() ? "async" : "sync", mainEntityClass.code(), mainEntityClass.code(), notifyContext, contextMap));
            ((DefaultTransactionManager)this.manager).commit(transKey);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            if (cmd.getUseBatch().booleanValue()) {
                ((DefaultTransactionManager)this.manager).rollBack(transKey);
            }
            throw e;
        }
        finally {
            try {
                xssfwb.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return importResult;
    }

    private void insertMain(IEntityClassGroup entityClassGroup, XSSFSheet sheet, Map<String, Object> contextMap, ImportCmd.Sheet sheetConfig, ImportCmd cmd, ImportResult importResult) {
        if (sheet == null) {
            throw new RuntimeException("sheet is null");
        }
        IEntityClass mainEntityClass = entityClassGroup.getEntityClass();
        if (!ImportWizardExcelServiceImpl.isMain(sheetConfig, cmd, mainEntityClass).booleanValue()) {
            return;
        }
        ImportResult.SheetImportResult sheetImportResult = ImportWizardExcelServiceImpl.initSheetImportResult(sheet, importResult, mainEntityClass.code());
        List headerFiledMapping = sheetConfig.getFieldMapping();
        int currentBatchCount = 0;
        Iterator rowIterator = sheet.rowIterator();
        Row headerRow = (Row)rowIterator.next();
        int lastCellNum = headerRow.getLastCellNum();
        List<String> headerFiledCodeList = this.getHeaderFiledCodeList(mainEntityClass, headerFiledMapping, headerRow, (short)lastCellNum);
        ArrayList<Map<String, Object>> batchList = new ArrayList<Map<String, Object>>();
        while (rowIterator.hasNext()) {
            HashMap<String, Object> rowContentMap = new HashMap<String, Object>();
            ++currentBatchCount;
            Row row = (Row)rowIterator.next();
            for (int j = 0; j < lastCellNum; ++j) {
                Cell cell = row.getCell(j);
                if (!mainEntityClass.code().equals(((ImportCmd.Sheet.FieldMapping)headerFiledMapping.get(j)).getBoCode())) continue;
                rowContentMap.put(headerFiledCodeList.get(j), cell == null ? null : this.readCellRawValue(cell));
            }
            Long nextId = this.snowflakeLongIdGenerator.next();
            if (CollUtil.isNotEmpty((Collection)cmd.getToManyRelations()) && !this.buildRelatedIndex(((ImportCmd.ToManyRelation)cmd.getToManyRelations().get(0)).getRelationCode(), contextMap, rowContentMap, nextId) && cmd.getSheets().size() == 1) {
                sheetImportResult.getFailedCount().incrementAndGet();
                sheetImportResult.addErrorResult(row.getRowNum() + 1, "\u4e3b\u952e\u91cd\u590d\uff0c\u8df3\u8fc7");
                continue;
            }
            rowContentMap.put("id", nextId);
            if (cmd.getUseBatch().booleanValue()) {
                batchList.add(rowContentMap);
                if (currentBatchCount % cmd.getStep() == 0 || !rowIterator.hasNext()) {
                    this.insertBatchRecord(contextMap, mainEntityClass.code(), batchList, row.getRowNum() + 1 - batchList.size(), sheetImportResult);
                    batchList.clear();
                }
            } else {
                this.insertRecord(contextMap, row.getRowNum() + 1, mainEntityClass.code(), rowContentMap, sheetImportResult);
            }
            if (currentBatchCount % cmd.getStep() != 0 || cmd.getUseBatch().booleanValue()) continue;
            String transKey = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
            if (transKey != null) {
                ((DefaultTransactionManager)this.manager).commit(transKey);
            }
            OqsTransaction newTransaction = ((DefaultTransactionManager)this.manager).createNewTransaction(cmd.getTimeout(), "");
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY, (Object)newTransaction.getId());
            currentBatchCount = 0;
        }
        String transKey = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        if (transKey != null && currentBatchCount > 0 && !cmd.getUseBatch().booleanValue()) {
            ((DefaultTransactionManager)this.manager).commit(transKey);
        }
    }

    @Nullable
    private static Boolean isMain(ImportCmd.Sheet sheetConfig, ImportCmd cmd, IEntityClass mainEntityClass) {
        Set relationBoCodeSet = sheetConfig.getFieldMapping().stream().filter(fieldMapping -> fieldMapping.getBoCode() != null && !fieldMapping.getBoCode().equals(mainEntityClass.code())).map(fieldMapping -> fieldMapping.getBoCode()).collect(Collectors.toSet());
        Boolean isMultiBoHeader = relationBoCodeSet.size() > 0;
        Boolean isMultiSheet = cmd.getSheets().size() > 1;
        if (isMultiBoHeader.booleanValue() && !isMultiSheet.booleanValue()) {
            return true;
        }
        if (!isMultiBoHeader.booleanValue()) {
            return true;
        }
        return false;
    }

    private void insertRelated(IEntityClassGroup iEntityClassGroup, XSSFSheet sheet, Map<String, Object> contextMap, ImportCmd.Sheet sheetsConfig, ImportCmd cmd, ImportResult importResult) {
        IEntityClass mainEntityClass = iEntityClassGroup.getEntityClass();
        List headerFiledMapping = sheetsConfig.getFieldMapping();
        Set<String> relationBoCodeSet = headerFiledMapping.stream().filter(fieldMapping -> fieldMapping.getBoCode() != null && !fieldMapping.getBoCode().equals(mainEntityClass.code())).map(fieldMapping -> fieldMapping.getBoCode()).collect(Collectors.toSet());
        if (relationBoCodeSet.size() == 0) {
            return;
        }
        ImportResult.SheetImportResult sheetImportResult = ImportWizardExcelServiceImpl.initSheetImportResult(sheet, importResult, "");
        Iterator rowIterator = sheet.rowIterator();
        Row headerRow = (Row)rowIterator.next();
        short size = headerRow.getLastCellNum();
        List<Integer> relationCodeColIndexList = ImportWizardExcelServiceImpl.getRelationCodeColIndexList(cmd.getToManyRelations(), mainEntityClass, headerFiledMapping, size);
        int currentBatchCount = 0;
        HashMap<String, List<Map<String, Object>>> boMap = new HashMap<String, List<Map<String, Object>>>();
        HashMap batchListMap = new HashMap();
        relationBoCodeSet.forEach(boCode -> {
            List cfr_ignored_0 = boMap.put((String)boCode, new ArrayList());
        });
        relationBoCodeSet.forEach(boCode -> {
            List cfr_ignored_0 = batchListMap.put(boCode, new ArrayList());
        });
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            ++currentBatchCount;
            Long relatedId = this.getRelatedIdAndSetContent(contextMap, cmd.getToManyRelations(), headerFiledMapping, size, relationCodeColIndexList, row, boMap);
            int index = row.getRowNum() - 1;
            if (relatedId == null) {
                this.logger.error("{} has no related value,body: {}", (Object)((ImportCmd.ToManyRelation)cmd.getToManyRelations().get(0)).getRelationCode(), boMap);
            } else {
                boMap.forEach((k, v) -> {
                    String relationCode = cmd.getToManyRelations().stream().filter(toManyRelation -> toManyRelation.getBoCode().equals(k)).findFirst().get().getRelationCode();
                    ((Map)v.get(index)).put(relationCode + ".id", relatedId);
                });
            }
            int finalCurrentBatchCount = currentBatchCount;
            boMap.forEach((k, v) -> {
                if (cmd.getUseBatch().booleanValue()) {
                    ((List)batchListMap.get(k)).add(v.get(index));
                    if (finalCurrentBatchCount % cmd.getStep() == 0 || !rowIterator.hasNext()) {
                        this.insertBatchRecord(contextMap, (String)k, (List)batchListMap.get(k), row.getRowNum() + 1 - ((List)batchListMap.get(k)).size(), sheetImportResult);
                        ((List)batchListMap.get(k)).clear();
                    }
                } else {
                    this.insertRecord(contextMap, row.getRowNum() + 1, (String)k, (Map)v.get(index), sheetImportResult);
                }
            });
            if (currentBatchCount % cmd.getStep() != 0 || cmd.getUseBatch().booleanValue()) continue;
            String transKey = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
            if (transKey != null) {
                ((DefaultTransactionManager)this.manager).commit(transKey);
            }
            OqsTransaction newTransaction = ((DefaultTransactionManager)this.manager).createNewTransaction(cmd.getTimeout(), "");
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY, (Object)newTransaction.getId());
            currentBatchCount = 0;
        }
        String transKey = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        if (transKey != null && currentBatchCount > 0 && !cmd.getUseBatch().booleanValue()) {
            ((DefaultTransactionManager)this.manager).commit(transKey);
        }
    }

    @NotNull
    private static ImportResult.SheetImportResult initSheetImportResult(XSSFSheet sheet, ImportResult importResult, String boCode) {
        ImportResult.SheetImportResult sheetImportResult = new ImportResult.SheetImportResult();
        sheetImportResult.setSheetName(sheet.getSheetName());
        sheetImportResult.setTotalCount(sheet.getLastRowNum());
        sheetImportResult.setBoCode(boCode);
        importResult.getSheetImportResultList().add(sheetImportResult);
        return sheetImportResult;
    }

    private void insertRecord(Map<String, Object> contextMap, int rowIndex, String boCode, Map<String, Object> contentMap, ImportResult.SheetImportResult sheetImportResult) {
        IEntityClass iEntityClass = (IEntityClass)this.entityFacade.loadByCode(boCode, "").get();
        Optional<Validation> first = this.postImportAwareList.stream().map(x -> x.doPostFilter(iEntityClass, contentMap, contextMap)).filter(Validation::isInvalid).findFirst();
        if (!first.isPresent()) {
            Either join = (Either)((CompletableFuture)this.entityFacade.create(iEntityClass, contentMap, contextMap).toCompletableFuture().thenApplyAsync(x -> x, (Executor)this.importThreadPool)).join();
            sheetImportResult.setBoCode(boCode);
            if (join.isLeft()) {
                sheetImportResult.getFailedCount().incrementAndGet();
                sheetImportResult.addErrorResult(rowIndex, ((CreateOneResult)join.getLeft()).getMessage());
            } else {
                sheetImportResult.getSuccessCount().incrementAndGet();
            }
        } else {
            this.logger.error("{}, {}, {} is not execute", new Object[]{boCode, contentMap, contextMap});
            sheetImportResult.getFailedCount().incrementAndGet();
            sheetImportResult.addErrorResult(rowIndex, (String)first.get().getError());
        }
    }

    private void insertBatchRecord(Map<String, Object> contextMap, String boCode, List<Map<String, Object>> contentMapList, Integer currentIndex, ImportResult.SheetImportResult sheetImportResult) {
        IEntityClass iEntityClass = (IEntityClass)this.entityFacade.loadByCode(boCode, "").get();
        for (int i = 0; i < contentMapList.size(); ++i) {
            Map<String, Object> contentMap = contentMapList.get(i);
            Optional<Validation> first = this.postImportAwareList.stream().map(x -> x.doPostFilter(iEntityClass, contentMap, contextMap)).filter(Validation::isInvalid).findFirst();
            if (!first.isPresent()) continue;
            this.logger.error("{}, {}, {} is not execute", new Object[]{boCode, contentMap, contextMap});
            sheetImportResult.getFailedCount().incrementAndGet();
            sheetImportResult.addErrorResult(currentIndex + i + 1, (String)first.get().getError());
            contentMapList.remove(i);
        }
        ArrayList<Map<String, Object>> validateContentMapList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < contentMapList.size(); ++i) {
            try {
                Map<String, Object> contentMap = contentMapList.get(i);
                this.entityFacade.validate(iEntityClass, contentMap);
                validateContentMapList.add(contentMap);
                continue;
            }
            catch (Exception e) {
                sheetImportResult.getFailedCount().incrementAndGet();
                sheetImportResult.addErrorResult(currentIndex + i + 1, e.getMessage());
            }
        }
        Either join = (Either)this.entityFacade.createMulti(iEntityClass, validateContentMapList, contextMap).toCompletableFuture().join();
        sheetImportResult.setBoCode(boCode);
        if (join.isLeft()) {
            CreateMultiResult left = (CreateMultiResult)join.getLeft();
            if (left.getOriginCause() != ResultStatus.OriginStatus.HALF_SUCCESS) {
                throw new RuntimeException(((CreateMultiResult)join.getLeft()).getEx().getClass().getName() + ":" + ((CreateMultiResult)join.getLeft()).getMessage());
            }
            Integer insertedRowCount = left.getInsertedRows() == null ? 0 : left.getInsertedRows();
            sheetImportResult.getFailedCount().addAndGet(contentMapList.size() - insertedRowCount);
            sheetImportResult.addErrorResult(currentIndex + insertedRowCount, left.getMessage());
        } else {
            sheetImportResult.getSuccessCount().addAndGet(validateContentMapList.size());
        }
    }

    private Long getRelatedIdAndSetContent(Map<String, Object> contextMap, List<ImportCmd.ToManyRelation> toManyRelations, List<ImportCmd.Sheet.FieldMapping> headerFiledMapping, short size, List<Integer> relationCodeColIndexList, Row row, Map<String, List<Map<String, Object>>> boMap) {
        StringBuilder sb = new StringBuilder();
        boMap.values().forEach(x -> x.add(new HashMap()));
        for (int j = 0; j < size; ++j) {
            String boCode;
            Cell cell = row.getCell(j);
            if (cell == null) continue;
            if (relationCodeColIndexList.contains(j)) {
                if (sb.length() > 0) {
                    sb.append("%^%");
                }
                Object rawValue = this.readCellRawValue(cell);
                sb.append(rawValue);
            }
            if ((boCode = headerFiledMapping.get(j).getBoCode()) == null || !boMap.containsKey(boCode)) continue;
            boMap.get(boCode).get(row.getRowNum() - 1).put(headerFiledMapping.get(j).getCode(), this.readCellRawValue(cell));
        }
        String s = sb.toString();
        Map<String, Long> indexMapping = this.getRelatedIndexMapping(contextMap, toManyRelations.get(0).getRelationCode());
        Long related = indexMapping.get(s);
        return related;
    }

    @NotNull
    private List<String> getHeaderFiledCodeList(IEntityClass entityClass, List<ImportCmd.Sheet.FieldMapping> headerFiledMapping, Row headerRow, short lastCellNum) {
        ArrayList<String> headerFiledCodeList = new ArrayList<String>();
        for (int j = 0; j < lastCellNum; ++j) {
            headerFiledCodeList.add(this.getBoFieldCodeFromExcelHeader(headerRow.getCell(j).getStringCellValue(), j, headerFiledMapping, entityClass.code(), true));
        }
        if (headerFiledCodeList.size() != headerFiledMapping.size()) {
            throw new RuntimeException(String.format("excel header is not match with import config. config: %s, excel: %s", headerFiledMapping.size(), headerFiledCodeList.size()));
        }
        return headerFiledCodeList;
    }

    @NotNull
    private Map<String, Object> getContextRelatedHeaderMap(ImportCmd cmd) {
        ConcurrentHashMap<String, Object> contextRelatedHeaderMap = new ConcurrentHashMap<String, Object>();
        contextRelatedHeaderMap.put("index", new HashMap());
        cmd.getToManyRelations().forEach(toManyRelation -> contextRelatedHeaderMap.put(toManyRelation.getRelationCode(), toManyRelation.getRelationFields()));
        return contextRelatedHeaderMap;
    }

    @NotNull
    private static List<Integer> getRelationCodeColIndexList(List<ImportCmd.ToManyRelation> toManyRelations, IEntityClass mainEntityClass, List<ImportCmd.Sheet.FieldMapping> headerFiledMapping, short size) {
        ArrayList<Integer> relationCodeColIndexList = new ArrayList<Integer>();
        for (int j = 0; j < size; ++j) {
            ImportCmd.Sheet.FieldMapping fieldMapping = headerFiledMapping.get(j);
            if (!mainEntityClass.code().equals(fieldMapping.getBoCode()) || !toManyRelations.get(0).getRelationFields().contains(fieldMapping.getCode())) continue;
            relationCodeColIndexList.add(j);
        }
        return relationCodeColIndexList;
    }

    protected Map<String, Long> getRelatedIndexMapping(Map<String, Object> context, String code) {
        Object index = context.get("index");
        if (index != null) {
            Map indexMapping = (Map)index;
            return Optional.ofNullable(indexMapping.get(code)).orElseGet(Collections::emptyMap);
        }
        return Collections.emptyMap();
    }

    protected boolean buildRelatedIndex(String code, Map<String, Object> contextMap, Map<String, Object> body, long id) {
        Object index = contextMap.get("index");
        Object codeMapping = contextMap.get(code);
        if (index == null || codeMapping == null) {
            return false;
        }
        Map indexMapping = (Map)index;
        List relatedCodeList = (List)codeMapping;
        HashMap<String, Long> indexCodeRelatedMapping = (HashMap<String, Long>)indexMapping.get(code);
        if (indexCodeRelatedMapping == null) {
            indexCodeRelatedMapping = new HashMap<String, Long>();
        }
        indexMapping.put(code, indexCodeRelatedMapping);
        String collect = relatedCodeList.stream().map(x -> body.get(x)).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining("%^%"));
        Long prev = indexCodeRelatedMapping.putIfAbsent(collect, id);
        return prev == null;
    }

    private boolean isValid(String code, IEntityClassGroup group) {
        Optional column = group.column(code);
        return column.isPresent();
    }
}

