/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityImported;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.CreateMultiResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.CreateOneResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.ResultStatus;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpCondition;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpValue;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ImportService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.impl.ImportDefaultExcelServiceImpl;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.DefaultTransactionManager;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransaction;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransactionManager;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import io.vavr.control.Either;
import io.vavr.control.Validation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class ImprovedImportDefaultExcelServiceImpl
extends ImportDefaultExcelServiceImpl {
    private Logger logger = LoggerFactory.getLogger(ImportService.class);
    private int defaultStep = 1000;

    public ImprovedImportDefaultExcelServiceImpl(EntityFacade entityFacade, ContextService contextService, ExecutorService importThreadPool, OqsTransactionManager manager, ApplicationEventPublisher publisher) {
        super(entityFacade, contextService, importThreadPool, manager, publisher);
    }

    private RecordTaskQueue createQueue(IEntityClass entityClass, int step, Map<String, Object> context) {
        return new RecordTaskQueue(entityClass, step, context);
    }

    private void insertMain(IEntityClass entityClass, XSSFSheet sheet, List<String> relatedCode, boolean useBatch, int step, Map<String, Object> contextMap) {
        Iterator rowIterator = sheet.rowIterator();
        Row headerRow = null;
        boolean isFirstRow = true;
        int size = 0;
        RecordTaskQueue queue = null;
        while (rowIterator.hasNext()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Row row = (Row)rowIterator.next();
            if (isFirstRow) {
                headerRow = row;
                isFirstRow = false;
                size = headerRow.getLastCellNum();
                continue;
            }
            map.clear();
            for (int i = 0; i < size; ++i) {
                Cell cell = row.getCell(i);
                map.put(this.getBoFieldCodeFromExcelHeader(headerRow.getCell(i).getStringCellValue(), entityClass), cell == null ? null : this.readCellRawValue(cell));
            }
            if (useBatch) {
                Optional<Validation> first;
                if (queue == null) {
                    queue = this.createQueue(entityClass, step, contextMap);
                }
                if ((first = this.postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, map, contextMap)).filter(Validation::isInvalid).findFirst()).isPresent()) continue;
                queue.offer(map);
                continue;
            }
            Optional<Validation> first = this.postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, map, contextMap)).filter(Validation::isInvalid).findFirst();
            if (!first.isPresent()) {
                CompletionStage insertResult = this.entityFacade.create(entityClass, map, contextMap).toCompletableFuture().thenApplyAsync(x -> x, (Executor)this.importThreadPool);
                Either join = (Either)((CompletableFuture)insertResult).join();
                List<String> finalRelatedCodeList = relatedCode;
                if (join.isRight()) {
                    for (String related : finalRelatedCodeList) {
                        this.buildRelatedIndex(related, contextMap, map, (Long)join.get());
                    }
                    continue;
                }
                if (((CreateOneResult)join.getLeft()).getOriginCause() == ResultStatus.OriginStatus.HALF_SUCCESS) {
                    this.logger.warn("Half success detect {}", (Object)((CreateOneResult)join.getLeft()).getErrorMap());
                    for (String related : finalRelatedCodeList) {
                        this.buildRelatedIndex(related, contextMap, map, ((CreateOneResult)join.getLeft()).getId());
                    }
                    continue;
                }
                throw new RuntimeException(((CreateOneResult)join.getLeft()).getMessage());
            }
            Validation validation = first.get();
            CompletableFuture.completedFuture(Either.left((Object)CreateOneResult.from((Throwable)new RuntimeException((String)validation.getError()))));
        }
        if (queue != null) {
            queue.flush();
        }
    }

    protected void putIndexMapping(Map<String, Object> context, String relatedCode, String code, Long value) {
        Object index = context.get("index");
        if (index != null) {
            Map indexMapping = (Map)index;
            HashMap<String, Long> schemaMapping = (HashMap<String, Long>)indexMapping.get(relatedCode);
            if (schemaMapping == null) {
                schemaMapping = new HashMap<String, Long>();
                indexMapping.put(relatedCode, schemaMapping);
            }
            schemaMapping.put(code, value);
        }
    }

    private void insertRelated(IEntityClass mainClass, IEntityClass entityClass, String relatedCode, XSSFSheet sheet, Map<String, Object> contextMap, boolean useBatch, int step) {
        Row headerRow = null;
        boolean isFirstRow = true;
        int size = 0;
        Iterator rowIterator = sheet.rowIterator();
        String sheetName = sheet.getSheetName();
        RecordTaskQueue queue = this.createQueue(entityClass, step, contextMap);
        queue.onFlush((list, ctx) -> {
            List unresolvedKeys;
            Object unresolved = ctx.get("unresolved");
            Object unresolvedKey = ctx.get("unresolved-key");
            if (unresolved != null && unresolvedKey != null && !(unresolvedKeys = (List)unresolved).isEmpty()) {
                Map<String, Long> mapping = this.getMainIdMappingWithKeys(mainClass, sheetName, unresolvedKeys, contextMap);
                list.forEach(body -> {
                    Object o = body.get(unresolvedKey.toString());
                    body.put(relatedCode.concat(".id"), mapping.get(o.toString()));
                });
                unresolvedKeys.clear();
            }
        });
        while (rowIterator.hasNext()) {
            Optional<Validation> first;
            HashMap<String, Object> map = new HashMap<String, Object>();
            Row row = (Row)rowIterator.next();
            if (isFirstRow) {
                headerRow = row;
                isFirstRow = false;
                size = headerRow.getLastCellNum();
                continue;
            }
            map.clear();
            StringBuilder sb = new StringBuilder();
            HashMap<String, Object> keyValueMapping = new HashMap<String, Object>();
            for (int i = 0; i < size; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) continue;
                Object rawValue = this.readCellRawValue(cell);
                Cell headerCell = headerRow.getCell(i);
                if (headerCell.getCellComment() != null) {
                    keyValueMapping.put(headerCell.getCellComment().getString().getString(), rawValue);
                    if (sb.length() > 0) {
                        sb.append("%^%");
                    }
                    sb.append(rawValue);
                }
                map.put(this.getBoFieldCodeFromExcelHeader(headerCell.getStringCellValue(), entityClass), cell == null ? null : this.readCellRawValue(cell));
            }
            String s = sb.toString();
            Map<String, Long> indexMapping = this.getRelatedIndexMapping(contextMap, sheetName);
            Long related = indexMapping.get(s);
            if (related == null) {
                ArrayList resolved;
                this.logger.warn("{} has no related value, body: {}", (Object)sheetName, map);
                Object o = contextMap.get("unresolved-key");
                if (o == null) {
                    String key = String.join((CharSequence)"%^%", keyValueMapping.keySet());
                    contextMap.put("unresolved-key", key);
                }
                if ((resolved = contextMap.get("unresolved")) == null) {
                    resolved = new ArrayList();
                    contextMap.put("unresolved", resolved);
                }
                ((List)resolved).add(keyValueMapping);
            } else if (related != -1L) {
                map.put(sheetName.concat(".id"), related);
            }
            if (!useBatch) {
                first = this.postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, map, contextMap)).filter(Validation::isInvalid).findFirst();
                if (!first.isPresent()) {
                    ((CompletableFuture)this.entityFacade.create(entityClass, map, contextMap).toCompletableFuture().thenApplyAsync(x -> x, (Executor)this.importThreadPool)).join();
                    continue;
                }
                this.logger.error("{}, {}, {} is not execute", new Object[]{entityClass.code(), map, contextMap});
                continue;
            }
            first = this.postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, map, contextMap)).filter(Validation::isInvalid).findFirst();
            if (!first.isPresent()) {
                queue.offer(map);
                continue;
            }
            this.logger.error("{}, {}, {} is not execute", new Object[]{entityClass.code(), map, contextMap});
        }
        if (queue != null) {
            queue.flush();
        }
    }

    private Map<String, Long> getMainIdMappingWithKeys(IEntityClass mainClass, String relatedCode, List<Map<String, Object>> unresolvedKeys, Map<String, Object> contextMap) {
        boolean singleQuery = unresolvedKeys.stream().allMatch(x -> x.size() == 1);
        HashMap<String, Long> retMapping = new HashMap<String, Long>();
        if (singleQuery) {
            String singleKey = (String)unresolvedKeys.get(0).keySet().stream().findFirst().get();
            Map<String, Collection> collect = unresolvedKeys.stream().collect(Collectors.groupingBy(x -> {
                Set keys = x.keySet();
                String s = (String)keys.stream().findFirst().get();
                return s;
            }, Collectors.reducing(new ArrayList(), x -> x.values(), (l, a) -> {
                l.addAll(a);
                return l;
            })));
            List conditions = collect.entrySet().stream().map(entry -> ExpCondition.call((ExpOperator)ExpOperator.IN, (ExpNode)ExpField.field((String)((String)entry.getKey())), (List)ExpValue.from(((Collection)entry.getValue()).stream().distinct().collect(Collectors.toList())))).collect(Collectors.toList());
            ExpQuery query = new ExpQuery().filters(conditions).range(Integer.valueOf(1), Integer.valueOf(1000));
            Either result = (Either)this.entityFacade.query(mainClass, (ExpRel)query, contextMap).toCompletableFuture().join();
            if (result.isRight() && !((DataCollection)result.get()).getRows().isEmpty()) {
                DataCollection records = (DataCollection)result.get();
                List rows = records.getRows();
                rows.forEach(record -> {
                    Long id = record.getId();
                    record.get(singleKey).ifPresent(m -> {
                        this.putIndexMapping(contextMap, relatedCode, m.toString(), id);
                        retMapping.put(m.toString(), id);
                    });
                });
            } else {
                collect.values().stream().flatMap(x -> x.stream()).forEach(s -> this.putIndexMapping(contextMap, relatedCode, s.toString(), -1L));
            }
        } else {
            throw new RuntimeException("currently Not supported multi");
        }
        return retMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeStep(IEntityClassGroup entityClassGroup, boolean useBatch, int timeout, int step, InputStream inputStream, boolean isAsync, List<String> orderedCode, String appId) throws IOException {
        if (step <= 0) {
            step = this.defaultStep;
        }
        XSSFWorkbook xssfwb = new XSSFWorkbook(inputStream);
        IEntityClass entityClass = entityClassGroup.getEntityClass();
        int numberOfSheets = xssfwb.getNumberOfSheets();
        try {
            Map contextMap = Optional.ofNullable(this.contextService).map(ContextService::getAll).orElseGet(Collections::emptyMap);
            contextMap.put("index", new HashMap());
            if (numberOfSheets > 1) {
                XSSFSheet mainSheet = xssfwb.getSheetAt(0);
                if (mainSheet != null) {
                    XSSFSheet sheetAt;
                    int i;
                    List<String> relatedCode = new ArrayList<String>();
                    for (i = 1; i < numberOfSheets; ++i) {
                        sheetAt = xssfwb.getSheetAt(i);
                        this.prepareRelatedHeader(sheetAt, contextMap, entityClassGroup);
                        if (orderedCode.isEmpty()) {
                            relatedCode.add(sheetAt.getSheetName());
                            continue;
                        }
                        relatedCode = orderedCode;
                    }
                    this.insertMain(entityClass, mainSheet, relatedCode, useBatch, step, contextMap);
                    for (i = 1; i < numberOfSheets; ++i) {
                        sheetAt = xssfwb.getSheetAt(i);
                        String code = orderedCode.isEmpty() ? sheetAt.getSheetName() : orderedCode.get(i - 1);
                        Optional iEntityClass = entityClassGroup.relatedEntityClass(code);
                        int finalStep = step;
                        iEntityClass.ifPresent(relatedEntityClass -> this.insertRelated(entityClass, (IEntityClass)relatedEntityClass, code, sheetAt, contextMap, useBatch, finalStep));
                    }
                    HashMap<String, String> notifyContext = new HashMap<String, String>();
                    notifyContext.put("appId", appId);
                    this.publisher.publishEvent((Object)new EntityImported(isAsync ? "async" : "sync", entityClass.code(), entityClass.code(), notifyContext, contextMap));
                }
            } else {
                XSSFSheet sheetAt = xssfwb.getSheetAt(0);
                HashMap<String, Object> map = new HashMap<String, Object>();
                Row headerRow = null;
                boolean isFirstRow = true;
                Short size = 0;
                int count = 0;
                if (sheetAt != null) {
                    Iterator rowIterator = sheetAt.rowIterator();
                    while (rowIterator.hasNext()) {
                        Optional<Validation> first;
                        Row row = (Row)rowIterator.next();
                        if (isFirstRow) {
                            headerRow = row;
                            isFirstRow = false;
                            size = headerRow.getLastCellNum();
                            continue;
                        }
                        map.clear();
                        for (int i = 0; i < size; ++i) {
                            Cell cell = row.getCell(i);
                            map.put(this.getBoFieldCodeFromExcelHeader(headerRow.getCell(i).getStringCellValue(), entityClass), cell == null ? null : this.readCellRawValue(cell));
                        }
                        if (count % step == 0) {
                            String transKey = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
                            if (transKey != null) {
                                ((DefaultTransactionManager)this.manager).commit(transKey);
                            }
                            OqsTransaction newTransaction = ((DefaultTransactionManager)this.manager).createNewTransaction(timeout, "");
                            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY, (Object)newTransaction.getId());
                            count = 0;
                        }
                        if (!(first = this.postImportAwareList.stream().map(x -> x.doPostFilter(entityClass, map, contextMap)).filter(Validation::isInvalid).findFirst()).isPresent()) {
                            ((CompletableFuture)this.entityFacade.create(entityClass, map, contextMap).toCompletableFuture().thenApplyAsync(x -> x, (Executor)this.importThreadPool)).join();
                            ++count;
                            continue;
                        }
                        this.logger.error("{}, {}, {} is not execute", new Object[]{entityClass.code(), map, contextMap});
                    }
                    String transKey = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
                    if (transKey != null) {
                        ((DefaultTransactionManager)this.manager).commit(transKey);
                    }
                    HashMap<String, String> notifyContext = new HashMap<String, String>();
                    notifyContext.put("appId", appId);
                    this.publisher.publishEvent((Object)new EntityImported(isAsync ? "async" : "sync", entityClass.code(), entityClass.code(), notifyContext, contextMap));
                }
            }
        }
        finally {
            xssfwb.close();
        }
    }

    class RecordTaskQueue {
        private IEntityClass entityClass;
        private int step;
        private Map<String, Object> context;
        private Queue<Map<String, Object>> queue = new LinkedList<Map<String, Object>>();
        private BiConsumer<List<Map<String, Object>>, Map<String, Object>> consumer;

        public RecordTaskQueue(IEntityClass entityClass, int step, Map<String, Object> context) {
            this.entityClass = entityClass;
            this.step = step;
            this.context = context;
        }

        public void flush() {
            if (!this.queue.isEmpty()) {
                CreateMultiResult left;
                CompletionStage multi;
                Either join;
                if (this.consumer != null) {
                    this.consumer.accept(this.queue.stream().collect(Collectors.toList()), this.context);
                }
                if ((join = (Either)(multi = ImprovedImportDefaultExcelServiceImpl.this.entityFacade.createMulti(this.entityClass, this.queue.stream(), this.context)).toCompletableFuture().join()).isLeft() && (left = (CreateMultiResult)join.getLeft()).getOriginCause() != ResultStatus.OriginStatus.HALF_SUCCESS) {
                    throw new RuntimeException(((CreateMultiResult)join.getLeft()).getMessage());
                }
                this.queue.clear();
            }
        }

        public void onFlush(BiConsumer<List<Map<String, Object>>, Map<String, Object>> consumer) {
            this.consumer = consumer;
        }

        public void offer(Map<String, Object> elem) {
            this.queue.offer(elem);
            if (this.queue.size() % this.step == 0) {
                this.flush();
            }
        }
    }
}

