/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import akka.japi.function.Function;
import akka.stream.IOResult;
import akka.stream.javadsl.FileIO;
import akka.stream.javadsl.Sink;
import akka.util.ByteString;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSink;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileExportSink
implements ExportSink {
    private String contextPath = "download/file/%s?type=%s";
    private String contextPathWithFileName = "download/file/%s?filename=%s&type=%s";
    private String root = "/";
    private Logger logger = LoggerFactory.getLogger(LocalFileExportSink.class);

    public LocalFileExportSink(String root) {
        this.root = root;
    }

    @Override
    public Sink<ByteString, CompletionStage<Tuple2<IOResult, String[]>>> getSink(String type, String ... token) {
        if (token.length > 0) {
            Path file = Paths.get(this.root, new String[0]).resolve(token[0] + "." + type);
            Sink sink = FileIO.toPath((Path)file).mapMaterializedValue((Function & Serializable)x -> x.thenApply(io -> Tuple.of((Object)io, (Object)token)));
            return sink;
        }
        this.logger.error("Error Input Token {}", (Object[])token);
        return null;
    }

    @Override
    public String getDownloadUrl(String type, String ... token) {
        if (token.length > 1) {
            return String.format(this.contextPathWithFileName, token[0], token[1], type);
        }
        if (token.length > 0) {
            return String.format(this.contextPath, token[0], type);
        }
        this.logger.error("Error Input Token {}", (Object[])token);
        return "download/file";
    }

    @Override
    public InputStream getInputStream(String ... token) {
        try {
            if (token.length > 1) {
                return Files.newInputStream(Paths.get(this.root, new String[0]).resolve(token[0] + "." + token[1]), new OpenOption[0]);
            }
            return Files.newInputStream(Paths.get(this.root, new String[0]).resolve(token[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            this.logger.error("{}", (Throwable)e);
            return null;
        }
    }
}

