/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl.excel;

import com.xforceplus.ultraman.oqsengine.sdk.service.export.impl.excel.CellRangeAddressWrapper;
import java.util.Set;
import java.util.TreeSet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class PoiCopySheet {
    private Set<CellRangeAddressWrapper> mergedRegions_ = new TreeSet<CellRangeAddressWrapper>();
    private Sheet srcSheet_;
    private Sheet dstSheet_;
    private Workbook srcWorkbook_;
    private Workbook dstWorkbook_;
    private CellStyle[] srcToDstStyle_;

    private PoiCopySheet(Sheet srcSheet, Sheet dstSheet) {
        this.srcSheet_ = srcSheet;
        this.dstSheet_ = dstSheet;
        this.srcWorkbook_ = srcSheet.getWorkbook();
        this.dstWorkbook_ = dstSheet.getWorkbook();
    }

    public static void copySheet(Sheet srcSheet, Sheet dstSheet) {
        PoiCopySheet poiCopySheet = new PoiCopySheet(srcSheet, dstSheet);
        poiCopySheet.copySheetInst();
    }

    private CellStyle getDstStyleFromSrcStyle(CellStyle srcStyle) {
        return this.srcToDstStyle_[srcStyle.getIndex()];
    }

    private void copySheetInst() {
        int i;
        this.mapCellStyles();
        this.copySheetSettings();
        int maxColumnNum = 0;
        if (this.srcSheet_.getFirstRowNum() < 0) {
            return;
        }
        for (i = this.srcSheet_.getFirstRowNum(); i <= this.srcSheet_.getLastRowNum(); ++i) {
            Row srcRow = this.srcSheet_.getRow(i);
            Row destRow = this.dstSheet_.createRow(i);
            if (srcRow == null) continue;
            this.copyRow(srcRow, destRow);
            if (srcRow.getLastCellNum() <= maxColumnNum) continue;
            maxColumnNum = srcRow.getLastCellNum();
        }
        for (i = 0; i <= maxColumnNum; ++i) {
            this.dstSheet_.setColumnWidth(i, this.srcSheet_.getColumnWidth(i));
            CellStyle srcColStyle = this.srcSheet_.getColumnStyle(i);
            if (srcColStyle == null) continue;
            this.dstSheet_.setDefaultColumnStyle(i, this.getDstStyleFromSrcStyle(srcColStyle));
        }
    }

    private void mapCellStyles() {
        int totalSrcCellStyles = this.srcWorkbook_.getNumCellStyles();
        this.srcToDstStyle_ = new CellStyle[totalSrcCellStyles];
        for (int srcStyleIdx = 0; srcStyleIdx < totalSrcCellStyles; ++srcStyleIdx) {
            CellStyle srcCellStyle = this.srcWorkbook_.getCellStyleAt(srcStyleIdx);
            this.srcToDstStyle_[srcStyleIdx] = this.getCellStyle(srcCellStyle);
        }
    }

    private void copyRow(Row srcRow, Row dstRow) {
        int j;
        if (srcRow.isFormatted()) {
            CellStyle srcRowStyle = srcRow.getRowStyle();
            CellStyle dstRowStyle = this.getDstStyleFromSrcStyle(srcRowStyle);
            dstRow.setRowStyle(dstRowStyle);
        }
        short dh = this.srcSheet_.getDefaultRowHeight();
        if (srcRow.getHeight() != dh) {
            dstRow.setHeight(srcRow.getHeight());
        }
        if ((j = srcRow.getFirstCellNum()) < 0) {
            j = 0;
        }
        while (j <= srcRow.getLastCellNum()) {
            Cell srcCell = srcRow.getCell(j);
            Cell dstCell = dstRow.getCell(j);
            if (srcCell != null) {
                CellRangeAddress dstMergedRegion;
                CellRangeAddressWrapper wrapper;
                if (dstCell == null) {
                    dstCell = dstRow.createCell(j);
                }
                this.copyCell(srcCell, dstCell);
                CellRangeAddress mergedRegion = PoiCopySheet.getMergedRegion(this.srcSheet_, srcRow.getRowNum(), (short)srcCell.getColumnIndex());
                if (mergedRegion != null && this.isdstMergedRegion(wrapper = new CellRangeAddressWrapper(dstMergedRegion = new CellRangeAddress(mergedRegion.getFirstRow(), mergedRegion.getLastRow(), mergedRegion.getFirstColumn(), mergedRegion.getLastColumn())))) {
                    this.mergedRegions_.add(wrapper);
                    this.dstSheet_.addMergedRegion(wrapper.range);
                }
            }
            ++j;
        }
    }

    private static CellRangeAddress getMergedRegion(Sheet sheet, int rowNum, short cellNum) {
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress merged = sheet.getMergedRegion(i);
            if (!merged.isInRange(rowNum, (int)cellNum)) continue;
            return merged;
        }
        return null;
    }

    private boolean isdstMergedRegion(CellRangeAddressWrapper dstMergedRegion) {
        return !this.mergedRegions_.contains(dstMergedRegion);
    }

    public void copyCell(Cell srcCell, Cell dstCell) {
        if (this.srcWorkbook_ == this.dstWorkbook_) {
            dstCell.setCellStyle(srcCell.getCellStyle());
        } else {
            CellStyle dstCellStyle = this.getDstStyleFromSrcStyle(srcCell.getCellStyle());
            dstCell.setCellStyle(dstCellStyle);
        }
        switch (srcCell.getCellType()) {
            case STRING: {
                dstCell.setCellValue(srcCell.getStringCellValue());
                break;
            }
            case NUMERIC: {
                dstCell.setCellValue(srcCell.getNumericCellValue());
                break;
            }
            case BLANK: {
                dstCell.setBlank();
                break;
            }
            case BOOLEAN: {
                dstCell.setCellValue(srcCell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                dstCell.setCellErrorValue(srcCell.getErrorCellValue());
                break;
            }
            case FORMULA: {
                dstCell.setCellFormula(srcCell.getCellFormula());
                break;
            }
        }
    }

    private CellStyle getSameCellStyle(CellStyle srcCellStyle) {
        DataFormat dstDataFormat = this.dstWorkbook_.createDataFormat();
        String srcDataFormatString = srcCellStyle.getDataFormatString();
        short expectedSrcDataFormat = dstDataFormat.getFormat(srcDataFormatString);
        int totalSrcCellStyles = this.dstWorkbook_.getNumCellStyles();
        for (int dstStyleIdx = 0; dstStyleIdx < totalSrcCellStyles; ++dstStyleIdx) {
            CellStyle currentCellStyle = this.dstWorkbook_.getCellStyleAt(dstStyleIdx);
            if (!PoiCopySheet.cellStylesEquals(currentCellStyle, this.dstWorkbook_, srcCellStyle, this.srcWorkbook_, expectedSrcDataFormat)) continue;
            return currentCellStyle;
        }
        return null;
    }

    private static boolean cellStylesEquals(CellStyle leftStyle, Workbook leftWorkbook, CellStyle rightStyle, Workbook rightWorkbook, short rightDataFormat) {
        String rightDataFormatString;
        if (leftStyle.getAlignment() != rightStyle.getAlignment()) {
            return false;
        }
        if (leftStyle.getHidden() != rightStyle.getHidden()) {
            return false;
        }
        if (leftStyle.getLocked() != rightStyle.getLocked()) {
            return false;
        }
        if (leftStyle.getWrapText() != rightStyle.getWrapText()) {
            return false;
        }
        if (leftStyle.getBorderBottom() != rightStyle.getBorderBottom()) {
            return false;
        }
        if (leftStyle.getBorderLeft() != rightStyle.getBorderLeft()) {
            return false;
        }
        if (leftStyle.getBorderRight() != rightStyle.getBorderRight()) {
            return false;
        }
        if (leftStyle.getBorderTop() != rightStyle.getBorderTop()) {
            return false;
        }
        if (leftStyle.getBottomBorderColor() != rightStyle.getBottomBorderColor()) {
            return false;
        }
        if (leftStyle.getFillBackgroundColor() != rightStyle.getFillBackgroundColor()) {
            return false;
        }
        if (leftStyle.getFillForegroundColor() != rightStyle.getFillForegroundColor()) {
            return false;
        }
        if (leftStyle.getFillPattern() != rightStyle.getFillPattern()) {
            return false;
        }
        if (leftStyle.getIndention() != rightStyle.getIndention()) {
            return false;
        }
        if (leftStyle.getLeftBorderColor() != rightStyle.getLeftBorderColor()) {
            return false;
        }
        if (leftStyle.getRightBorderColor() != rightStyle.getRightBorderColor()) {
            return false;
        }
        if (leftStyle.getRotation() != rightStyle.getRotation()) {
            return false;
        }
        if (leftStyle.getTopBorderColor() != rightStyle.getTopBorderColor()) {
            return false;
        }
        if (leftStyle.getVerticalAlignment() != rightStyle.getVerticalAlignment()) {
            return false;
        }
        Font leftFont = leftWorkbook.getFontAt(leftStyle.getFontIndexAsInt());
        Font rightFont = rightWorkbook.getFontAt(rightStyle.getFontIndexAsInt());
        if (leftFont.getBold() != rightFont.getBold()) {
            return false;
        }
        if (leftFont.getColor() != rightFont.getColor()) {
            return false;
        }
        if (leftFont.getFontHeight() != rightFont.getFontHeight()) {
            return false;
        }
        if (!leftFont.getFontName().equals(rightFont.getFontName())) {
            return false;
        }
        if (leftFont.getItalic() != rightFont.getItalic()) {
            return false;
        }
        if (leftFont.getStrikeout() != rightFont.getStrikeout()) {
            return false;
        }
        if (leftFont.getTypeOffset() != rightFont.getTypeOffset()) {
            return false;
        }
        if (leftFont.getUnderline() != rightFont.getUnderline()) {
            return false;
        }
        if (leftFont.getCharSet() != rightFont.getCharSet()) {
            return false;
        }
        String leftDataFormatString = leftStyle.getDataFormatString();
        return leftDataFormatString.equals(rightDataFormatString = rightStyle.getDataFormatString()) || rightDataFormat == leftStyle.getDataFormat();
    }

    private CellStyle getCellStyle(CellStyle srcCellStyle) {
        CellStyle dstCellStyle = this.getSameCellStyle(srcCellStyle);
        if (dstCellStyle == null) {
            dstCellStyle = this.cloneCellStyle(srcCellStyle);
        }
        return dstCellStyle;
    }

    private CellStyle cloneCellStyle(CellStyle srcCellStyle) {
        Font srcFont = this.srcWorkbook_.getFontAt(srcCellStyle.getFontIndexAsInt());
        Font dstFont = this.dstWorkbook_.findFont(srcFont.getBold(), srcFont.getColor(), srcFont.getFontHeight(), srcFont.getFontName(), srcFont.getItalic(), srcFont.getStrikeout(), srcFont.getTypeOffset(), srcFont.getUnderline());
        if (dstFont == null) {
            dstFont = this.dstWorkbook_.createFont();
            dstFont.setBold(srcFont.getBold());
            dstFont.setColor(srcFont.getColor());
            dstFont.setFontHeight(srcFont.getFontHeight());
            dstFont.setFontName(srcFont.getFontName());
            dstFont.setItalic(srcFont.getItalic());
            dstFont.setStrikeout(srcFont.getStrikeout());
            dstFont.setTypeOffset(srcFont.getTypeOffset());
            dstFont.setUnderline(srcFont.getUnderline());
            dstFont.setCharSet(srcFont.getCharSet());
        }
        CellStyle dstCellStyle = this.dstWorkbook_.createCellStyle();
        dstCellStyle.setFont(dstFont);
        DataFormat dstDataFormat = this.dstWorkbook_.createDataFormat();
        String srcDataFormatString = srcCellStyle.getDataFormatString();
        short dstFormat = dstDataFormat.getFormat(srcDataFormatString);
        dstCellStyle.setDataFormat(dstFormat);
        dstCellStyle.setAlignment(srcCellStyle.getAlignment());
        dstCellStyle.setHidden(srcCellStyle.getHidden());
        dstCellStyle.setLocked(srcCellStyle.getLocked());
        dstCellStyle.setWrapText(srcCellStyle.getWrapText());
        dstCellStyle.setBorderBottom(srcCellStyle.getBorderBottom());
        dstCellStyle.setBorderLeft(srcCellStyle.getBorderLeft());
        dstCellStyle.setBorderRight(srcCellStyle.getBorderRight());
        dstCellStyle.setBorderTop(srcCellStyle.getBorderTop());
        dstCellStyle.setBottomBorderColor(srcCellStyle.getBottomBorderColor());
        dstCellStyle.setFillBackgroundColor(srcCellStyle.getFillBackgroundColor());
        dstCellStyle.setFillForegroundColor(srcCellStyle.getFillForegroundColor());
        dstCellStyle.setFillPattern(srcCellStyle.getFillPattern());
        dstCellStyle.setIndention(srcCellStyle.getIndention());
        dstCellStyle.setLeftBorderColor(srcCellStyle.getLeftBorderColor());
        dstCellStyle.setRightBorderColor(srcCellStyle.getRightBorderColor());
        dstCellStyle.setRotation(srcCellStyle.getRotation());
        dstCellStyle.setTopBorderColor(srcCellStyle.getTopBorderColor());
        dstCellStyle.setVerticalAlignment(srcCellStyle.getVerticalAlignment());
        return dstCellStyle;
    }

    private void copySheetSettings() {
        this.dstSheet_.setAutobreaks(this.srcSheet_.getAutobreaks());
        this.dstSheet_.setDefaultColumnWidth(this.srcSheet_.getDefaultColumnWidth());
        this.dstSheet_.setDefaultRowHeight(this.srcSheet_.getDefaultRowHeight());
        this.dstSheet_.setDefaultRowHeightInPoints(this.srcSheet_.getDefaultRowHeightInPoints());
        this.dstSheet_.setDisplayGuts(this.srcSheet_.getDisplayGuts());
        this.dstSheet_.setFitToPage(this.srcSheet_.getFitToPage());
        this.dstSheet_.setForceFormulaRecalculation(this.srcSheet_.getForceFormulaRecalculation());
        PrintSetup srcSheet_PrintSetup = this.srcSheet_.getPrintSetup();
        PrintSetup dstSheet_PrintSetup = this.dstSheet_.getPrintSetup();
        dstSheet_PrintSetup.setPaperSize(srcSheet_PrintSetup.getPaperSize());
        dstSheet_PrintSetup.setScale(srcSheet_PrintSetup.getScale());
        dstSheet_PrintSetup.setPageStart(srcSheet_PrintSetup.getPageStart());
        dstSheet_PrintSetup.setFitWidth(srcSheet_PrintSetup.getFitWidth());
        dstSheet_PrintSetup.setFitHeight(srcSheet_PrintSetup.getFitHeight());
        dstSheet_PrintSetup.setLeftToRight(srcSheet_PrintSetup.getLeftToRight());
        dstSheet_PrintSetup.setLandscape(srcSheet_PrintSetup.getLandscape());
        dstSheet_PrintSetup.setValidSettings(srcSheet_PrintSetup.getValidSettings());
        dstSheet_PrintSetup.setNoColor(srcSheet_PrintSetup.getNoColor());
        dstSheet_PrintSetup.setDraft(srcSheet_PrintSetup.getDraft());
        dstSheet_PrintSetup.setNotes(srcSheet_PrintSetup.getNotes());
        dstSheet_PrintSetup.setNoOrientation(srcSheet_PrintSetup.getNoOrientation());
        dstSheet_PrintSetup.setUsePage(srcSheet_PrintSetup.getUsePage());
        dstSheet_PrintSetup.setHResolution(srcSheet_PrintSetup.getHResolution());
        dstSheet_PrintSetup.setVResolution(srcSheet_PrintSetup.getVResolution());
        dstSheet_PrintSetup.setHeaderMargin(srcSheet_PrintSetup.getHeaderMargin());
        dstSheet_PrintSetup.setFooterMargin(srcSheet_PrintSetup.getFooterMargin());
        dstSheet_PrintSetup.setCopies(srcSheet_PrintSetup.getCopies());
        Header srcSheet_Header = this.srcSheet_.getHeader();
        Header dstSheet_Header = this.dstSheet_.getHeader();
        dstSheet_Header.setCenter(srcSheet_Header.getCenter());
        dstSheet_Header.setLeft(srcSheet_Header.getLeft());
        dstSheet_Header.setRight(srcSheet_Header.getRight());
        Footer srcSheet_Footer = this.srcSheet_.getFooter();
        Footer dstSheet_Footer = this.dstSheet_.getFooter();
        dstSheet_Footer.setCenter(srcSheet_Footer.getCenter());
        dstSheet_Footer.setLeft(srcSheet_Footer.getLeft());
        dstSheet_Footer.setRight(srcSheet_Footer.getRight());
        this.dstSheet_.setHorizontallyCenter(this.srcSheet_.getHorizontallyCenter());
        this.dstSheet_.setMargin((short)0, this.srcSheet_.getMargin((short)0));
        this.dstSheet_.setMargin((short)1, this.srcSheet_.getMargin((short)1));
        this.dstSheet_.setMargin((short)2, this.srcSheet_.getMargin((short)2));
        this.dstSheet_.setMargin((short)3, this.srcSheet_.getMargin((short)3));
        this.dstSheet_.setPrintGridlines(this.srcSheet_.isPrintGridlines());
        this.dstSheet_.setRowSumsBelow(this.srcSheet_.getRowSumsBelow());
        this.dstSheet_.setRowSumsRight(this.srcSheet_.getRowSumsRight());
        this.dstSheet_.setVerticallyCenter(this.srcSheet_.getVerticallyCenter());
        this.dstSheet_.setDisplayFormulas(this.srcSheet_.isDisplayFormulas());
        this.dstSheet_.setDisplayGridlines(this.srcSheet_.isDisplayGridlines());
        this.dstSheet_.setDisplayRowColHeadings(this.srcSheet_.isDisplayRowColHeadings());
        this.dstSheet_.setDisplayZeros(this.srcSheet_.isDisplayZeros());
        this.dstSheet_.setPrintGridlines(this.srcSheet_.isPrintGridlines());
        this.dstSheet_.setRightToLeft(this.srcSheet_.isRightToLeft());
        this.dstSheet_.setZoom(100);
    }
}

