package com.xforceplus.ultraman.oqsengine.sdk.service.export;

import com.xforceplus.tech.base.core.dispatcher.messaging.QueryMessage;
import com.xforceplus.ultraman.oqsengine.sdk.command.ConditionExportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.GetImportTemplateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.ImportCmd;
import io.vavr.Tuple2;
import io.vavr.control.Either;

import java.io.InputStream;
import java.util.concurrent.CompletableFuture;

/**
 * bulk service for export
 */
public interface BulkService {

    CompletableFuture<Either<String, String>> importTemplateCustom(GetImportTemplateCmd cmd);

    CompletableFuture<Either<String, String>> conditionExport(QueryMessage<ConditionExportCmd, ?> cmd);

    Either<String, Tuple2<String, InputStream>> importTemplate(GetImportTemplateCmd cmd);

    Either<String, String> batchImport(ImportCmd cmd);

}
