package com.xforceplus.ultraman.oqsengine.sdk.service.export;

import akka.NotUsed;
import akka.stream.javadsl.Source;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import io.vavr.Tuple2;

import java.util.List;
import java.util.Map;

/**
 * service to export
 */
public interface ExportSource extends Comparable<ExportSource>{

    /**
     *
     * @param entityClass
     * @param multiSchema
     * @param context
     * @return
     */
    boolean isAccept(IEntityClass entityClass, boolean multiSchema, Map<String, Object> context);

    int getOrder();

    /**
     * Classifier record is optional default is not used
     * a export Source
     * @return
     */
    default Source<ClassifiedRecord, NotUsed> source(String classifier, IEntityClass entityClass, ExpRel request, Map<String, ExpRel> subQuery, Map<String, Object> context, ClassifiedRecord classifiedRecord) {
        return source(classifier, entityClass, request, subQuery, context);
    }


    Source<ClassifiedRecord, NotUsed> source(String classifier, IEntityClass entityClass, ExpRel request, Map<String, ExpRel> subQuery, Map<String, Object> context);


    @Override
    default int compareTo(ExportSource o){
        return Integer.compare(this.getOrder(), o.getOrder());
    }
}
