package com.xforceplus.ultraman.oqsengine.sdk.service.export;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.sdk.command.ImportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.entity.ImportResult;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.enums.ImportModeEnum;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

public interface ImportService {

    ImportModeEnum getImportMode();

    ImportResult doImport(IEntityClassGroup entityClassGroup, ImportCmd importCmd);

    default String getBoFieldCodeFromExcelHeader(String excelHeader, int colIndex, List<ImportCmd.Sheet.FieldMapping> fieldMappings, String boCode) {
        return getBoFieldCodeFromExcelHeader(excelHeader, colIndex, fieldMappings, boCode, false);
    }

    default String getBoFieldCodeFromExcelHeader(String excelHeader, int colIndex, List<ImportCmd.Sheet.FieldMapping> fieldMappings, String boCode, Boolean isOnlyMatchMapping) {
        int start = excelHeader.indexOf("[");
        int end = excelHeader.indexOf("]");
        String name = null;

        if (start >= 0 && end >= 0) {
            // 解析到code则直接返回
            return excelHeader.substring(start + 1, end);
            // name = excelHeader.substring(0, start);
        } else {
            name = excelHeader;
        }

        ImportCmd.Sheet.FieldMapping targetFiledMapping = null;
        // 按顺序匹配
        if (fieldMappings.get(colIndex).getHeader().equals(name)) {
            targetFiledMapping = fieldMappings.get(colIndex);
        }
        if (!isOnlyMatchMapping && targetFiledMapping == null) {
            String finalName = name;
            // 顺序匹配不到,且不是向导模式，则根据中文匹配,如果顺序调整过,中文还有重名,则会导致重名列的无法导入
            Optional<ImportCmd.Sheet.FieldMapping> first = fieldMappings.stream().filter(fieldMapping -> fieldMapping.getHeader().equals(finalName)).findFirst();
            if (first.isPresent()) {
                targetFiledMapping = first.get();
            }
        }
        if (targetFiledMapping != null) {
            if (boCode.equals(targetFiledMapping.getBoCode())) {
                return targetFiledMapping.getCode();
            } else {
                return targetFiledMapping.getBoCode() + "." + targetFiledMapping.getCode();
            }
        }
        return null;
    }

    default String getBoFieldCodeFromExcelHeader(String headerPart, IEntityClass entityClass) {
        int start = headerPart.indexOf("[");
        int end = headerPart.indexOf("]");

        if (start < 0 || end < 0) {
            Optional<IEntityField> first = entityClass.fields().stream().filter(filed ->
                    filed.cnName() != null && filed.cnName().equals(headerPart.trim())
            ).findFirst();
            if (first.isPresent()) {
                return first.get().name();
            }
            return headerPart;
        } else {
            return headerPart.substring(start + 1, end);
        }
    }

    default Object readCellRawValue(Cell cell) {
        Object rawValue = null;
        if (cell.getCellType() == CellType.FORMULA) {
            switch (cell.getCachedFormulaResultType()) {
                case BOOLEAN:
                    rawValue = cell.getBooleanCellValue();
                    break;
                case NUMERIC:
                    rawValue = BigDecimal.valueOf(cell.getNumericCellValue());
                    break;
                case STRING:
                    rawValue = cell.getStringCellValue();
                    break;
                default:
            }
        } else if (cell.getCellType() == CellType.BOOLEAN) {
            rawValue = cell.getBooleanCellValue();
        } else if (cell.getCellType() == CellType.NUMERIC) {

            if (DateUtil.isCellDateFormatted(cell)) {
                //check if this is date
                rawValue = cell.getLocalDateTimeCellValue().atZone(DateTimeValue.zoneId.systemDefault()).toInstant().toEpochMilli();

            } else {
                rawValue = BigDecimal.valueOf(cell.getNumericCellValue());
            }
        } else if (cell.getCellType() == CellType.STRING) {
            rawValue = cell.getStringCellValue();
        } else {
            rawValue = null;
        }

        return rawValue;
    }

}
