package com.xforceplus.ultraman.oqsengine.sdk.service.export;

import com.xforceplus.ultraman.oqsengine.sdk.service.export.enums.ImportModeEnum;
import org.springframework.beans.factory.InitializingBean;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ImportServiceFactory implements InitializingBean {
    private final Map<ImportModeEnum, ImportService> importServiceMap;

    public ImportServiceFactory(List<ImportService> importServiceList) {
        this.importServiceMap = importServiceList.stream().collect(Collectors.toMap(ImportService::getImportMode, Function.identity()));
    }

    public ImportService getImportService(String importModeEnumCode) {
        return importServiceMap.get(ImportModeEnum.getByCode(importModeEnumCode));
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (importServiceMap.isEmpty()) {
            throw new RuntimeException("ImportServiceFactory初始化失败");
        }
    }
}
