package com.xforceplus.ultraman.oqsengine.sdk.service.export.enums;

import javax.annotation.Nullable;

public enum ImportModeEnum {
    BASE("base", "基础导入模版模式"),
    WIZARD("wizard", "导入向导SAP模板模式"),
    ;
    private String code;
    private String desc;

    ImportModeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Nullable
    public static ImportModeEnum getByCode(String code) {
        for (ImportModeEnum importModeEnum : ImportModeEnum.values()) {
            if (importModeEnum.getCode().equals(code)) {
                return importModeEnum;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
