package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.ProfileFetcher;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.ResultStatus;
import com.xforceplus.ultraman.oqsengine.sdk.service.DictService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportCustomFieldToString;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.FormattedString;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.DictItem;
import io.vavr.control.Either;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Default Export to String
 */
public class DefaultExportCustomFieldToString implements ExportCustomFieldToString {

    private DictService dictService;

    private EntityFacade entityFacade;

    private ProfileFetcher profileFetcher;

    private Logger logger = LoggerFactory.getLogger(DefaultExportCustomFieldToString.class);


    public DefaultExportCustomFieldToString(DictService dictService, EntityFacade entityFacade, ProfileFetcher fetcher) {
        this.dictService = dictService;
        this.entityFacade = entityFacade;
        this.profileFetcher = fetcher;
    }

    @Override
    public boolean isSupport(IEntityClass entityClass, IEntityField field) {
        return true;
    }

    @Override
    public boolean isDefault() {
        return true;
    }


    @Deprecated
    @Override
    public Optional<String> getString(IEntityClass entityClass, IEntityField entityField, String safeSourceValue, Map<String, Object> context) {
        return this.getString(entityClass, entityField, safeSourceValue, context, null);
    }

    @Override
    public Optional<String> getString(IEntityClass entityClass, IEntityField entityField, String safeSourceValue, Map<String, Object> context, FormattedString formattedString) {

        String retStr = null;

        FieldType type = entityField.type();

        /**
         * dict cache
         */
        Map<String, List<DictItem>> mapping = (Map<String, List<DictItem>>) context.getOrDefault("dictCache", new HashMap<>());
        context.putIfAbsent("dictCache", mapping);

        /**
         * related entity
         */
        Map<String, Map<String, String>> searchTable = (Map<String, Map<String, String>>) context.getOrDefault("search", new HashMap<>());
        context.putIfAbsent("search", searchTable);

        switch (type) {
            case ENUM: {
                String dictId = entityField.dictId();
                List<DictItem> items = mapping.get(dictId);
                if (items == null) {
                    List<DictItem> dictItems = dictService.findDictItems(dictId, null, context);
                    mapping.put(dictId, dictItems);
                    items = dictItems;
                }

                retStr = items.stream()
                        .filter(x -> x.getValue().equals(safeSourceValue))
                        .map(DictItem::getText)
                        .findAny().orElse(safeSourceValue);
                break;
            }
            case DATETIME: {
                retStr = entityField.type().toTypedValue(entityField, safeSourceValue).map(x -> {
                    return ((DateTimeValue) x);
                }).map(x -> x.getValue().format(DateTimeFormatter.ofPattern(Optional.ofNullable(formattedString).map(format -> format.getFormat()).orElse("yyyy-MM-dd HH:mm:ss")))).orElse("");
                break;
            }
            case STRINGS: {

                if (safeSourceValue.trim().isEmpty()) {
                    retStr = "";
                    break;
                }

                String[] ids = safeSourceValue.split(",");
                Long fieldId = entityField.id();

                Optional<Long> relatedId = entityClass.relations().stream()
                        .filter(x -> x.getEntityField() != null)
                        .filter(x -> x.getEntityField().id() == fieldId)
                        .map(Relation::getEntityClassId).findAny();

                if (relatedId.isPresent()) {
                    //it's multi relation
                    Optional<IEntityClass> relatedEntityOp = entityFacade.load(relatedId.get().toString(), profileFetcher.getProfile(context));
                    if (relatedEntityOp.isPresent()) {
                        IEntityClass relatedEntity = relatedEntityOp.get();

                        Map<String, String> cachedList = searchTable.get(relatedId.get().toString());
                        if (cachedList == null) {
                            //search
                            Map<String, String> cached = new HashMap<>();
                            searchTable.put(relatedId.get().toString(), cached);
                            cachedList = cached;
                        }

                        //TODO how to find all
                        Map<String, String> finalCachedList = cachedList;

                        //try to find something to display
                        Optional<IEntityField> displayField = relatedEntity.fields().stream()
                                .filter(x -> Optional.ofNullable(x.config())
                                        .filter(field -> "1".equals(field.getDisplayType())).isPresent()).findFirst();

                        retStr = Stream.of(ids).map(x -> {
                            String name = finalCachedList.get(x);
                            String innerRetStr = x;
                            if (name == null) {
                                //only when displayField is present will find one for id
                                if (displayField.isPresent()) {
                                    try {
                                        //search
                                        Either<String, Record> one = entityFacade
                                                .findOneById(relatedEntity, Long.parseLong(x), context)
                                                .toCompletableFuture().join().mapLeft(ResultStatus::getMessage);
                                        if (one.isRight()) {
                                            String key = displayField.get().name();
                                            Optional<Object> relatedDisplayName = one.get().get(key);
                                            //TODO the type of the field not determined
                                            innerRetStr = relatedDisplayName.map(Object::toString).orElse(x);
                                        }
                                    } catch (Exception ex) {
                                        logger.error("{}", ex);
                                    }
                                }
                                finalCachedList.put(x, innerRetStr);
                            } else {
                                innerRetStr = name;
                            }

                            return innerRetStr;
                        }).collect(Collectors.joining(","));
                    } else {
                        retStr = safeSourceValue.trim();
                    }
                } else if (!StringUtils.isEmpty(entityField.dictId())) {
                    //it's mutli enum
                    String dictId = entityField.dictId();
                    List<DictItem> items = mapping.get(dictId);
                    if (items == null) {
                        List<DictItem> dictItems = dictService.findDictItems(dictId, null, context);
                        mapping.put(dictId, dictItems);
                        items = dictItems;
                    }

                    List<DictItem> finalItems = items;
                    retStr = Stream.of(ids).map(id -> {
                        return Optional.ofNullable(finalItems).orElseGet(Collections::emptyList)
                                .stream()
                                .filter(x -> x.getValue().equals(id))
                                .map(DictItem::getText)
                                .findAny().orElse(id);
                    }).collect(Collectors.joining(","));

                    break;
                } else {
                    retStr = safeSourceValue.trim();
                }

                break;
            }
            default:
                retStr = entityField.type().toTypedValue(entityField, safeSourceValue)
                        .map(IValue::getValue)
                        .map(Object::toString).orElse("");

        }

        return Optional.ofNullable(retStr);
    }
}