package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import com.xforceplus.ultraman.oqsengine.sdk.command.ConditionExportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.DownloadFilenameGenerator;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;

/**
 * default filename Generator
 */
public class DefaultFilenameGenerator implements DownloadFilenameGenerator {

    @Override
    public String getFileName(ConditionExportCmd message, Map<String, Object> context) {
        String fileName = Optional.ofNullable(context.get("name")).map(Object::toString)
                .map(String::trim)
                .orElseGet(() -> Optional.ofNullable(context.get("code"))
                        .map(Object::toString)
                        //warning supplier should not trim to method call when the object is null will cause NullPoint exception
                        .orElseGet(() -> message.getBoId()))
                .trim() + "-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("YYYYMMddHHmmSS"));
        return fileName;
    }
}
