package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportCustomFieldToString;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportStringTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.FormattedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * string to transformer
 */
public class ExportStringTransformerImpl implements ExportStringTransformer {

    private List<ExportCustomFieldToString> customTransformers;

    private ExportCustomFieldToString exportCustomFieldToString;

    private Logger logger = LoggerFactory.getLogger(ExportStringTransformer.class);

    public ExportStringTransformerImpl(
              List<ExportCustomFieldToString> customTransformers
            , ExportCustomFieldToString defaultExportCustomFieldToString) {
        this.customTransformers = customTransformers;
        this.exportCustomFieldToString = defaultExportCustomFieldToString;
    }

    @Override
    public String toString(IEntityClass entityClass, IEntityField entityField, Object value, Map<String, Object> context, FormattedString formattedString) {

        String safeSourceValue = Optional.ofNullable(value).map(Object::toString).orElse("");

        String retStr = customTransformers.stream()
                .filter(x -> !x.isDefault() && x.isSupport(entityClass, entityField))
                .findFirst()
                .orElseGet(() -> {
                    logger.debug("transform {}:{} with default", entityClass.code(), entityField.name());
                    return exportCustomFieldToString;
                })
                .safeGetString(entityClass, entityField, safeSourceValue, context, formattedString)
                .orElse("");

        return retStr;
    }
}
