package com.xforceplus.docs.gettingstarted.firstapplication.code.business;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.EmptyValue;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityId;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityInstance;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityKey;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.service.BusinessFacade;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.*;
import com.xforceplus.ultraman.oqsengine.sdk.util.RequestBuilder;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionOp;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import org.junit.Test;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

import static com.xforceplus.ultraman.oqsengine.sdk.util.PreDef.t;

public class Example {

    private BusinessFacade businessFacade;

    @Test
    public void example(){
        //# tag::load[]
        //根据元数据ID加载元数据对象结构
        IEntityClass companyById = businessFacade.load(123344334L);

        //根据元数据ID加载元数据对象结构
        IEntityClass companyByCode = businessFacade.load("company");
        //# end::load[]

        //# tag::create[]
        //基础的创建
        Map<String, Object> body = new HashMap<>();
        body.put("name", "xforce");
        Long retId = businessFacade.create(companyByCode, body);

        //当传入了id字段时 返回的主键会以传入值为准
        Map<String, Object> sameIdBody = new HashMap<>();
        body.put("id", 1232321212L);
        body.put("name", "xforce");
        Long sameId = businessFacade.create(companyByCode, sameIdBody);

        //当创建发生例外时, 可以通过 `CreateOneResult` 对象进行判断和处理
        businessFacade.create(companyByCode, body, createOneResult -> {
            return createOneResult.getId();
        });

        //# end::create[]
        //# tag::update[]
        //数据的更新
        Map<String, Object> updateBody = new HashMap<>();
        updateBody.put("name", "xforceplus2");
        businessFacade.updateById(EntityId.of(companyByCode, retId), updateBody);

        //属性的移除
        Map<String, Object> removeNameBody = new HashMap<>();
        updateBody.put("name", EmptyValue.emptyValue);
        businessFacade.updateById(EntityId.of(companyByCode, retId), removeNameBody);

        //先进行查询后再更新
        businessFacade.updateByKey(EntityKey.of(companyByCode, t("name", "xforceplus")), updateBody);

        //当更新发生例外时, 可以通过 `UpdateOneResult` 对象进行判断和处理
        businessFacade.updateById(EntityId.of(companyByCode, retId), body, updateOneResult -> {
            return 1;
        });
        //# end::update[]

        //# tag::delete[]
        //根据id删除
        businessFacade.deleteOne(EntityId.of(companyByCode, retId));

        //当更新发生例外时, 可以通过 `DeleteOneResult` 对象进行判断和处理
        businessFacade.deleteOne(EntityId.of(companyByCode, retId), deleteOneResult -> 0);

        //查询后再逐一删除
        businessFacade.deleteByCondition(companyByCode, ExpFactory.EMPTY);

        //根据key-value查询后再删除
        businessFacade.deleteByKey(EntityKey.of(companyByCode, t("name", "xforceplus")));

        //# end::delete[]

        //# tag::query[]
        //单Id查询
        Optional<EntityInstance> one = businessFacade.findOne(EntityId.of(companyByCode, retId));

        //条件查询单条， 如果命中多条则只返回第一个，但是会有相应的警告日志
        businessFacade.findOneByKey(EntityKey.of(companyByCode, t("name", "xforceplus")));

        //条件查询
        //多种ExpRel的构建方式
        ExpRel expRel;
        //通过ConditionQueryResult 注意默认的校验需要手动传入pageNo和pageCode
        expRel = ExpFactory.createFrom(new RequestBuilder()
                .field("name", ConditionOp.eq, "xforceplus")
                .pageNo(1)
                .pageSize(10)
                .build());

        //通过map构建
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put("name", "xforceplus");
        expRel = ExpFactory.createFrom(queryMap);

        //通过tuple构建
        expRel = ExpFactory.createFrom(t("name", "xforceplus"));

        //手动构建
        expRel = new ExpQuery()
                .filters(ExpCondition.call(ExpOperator.EQUALS
                        , ExpField.field("name")
                        , ExpValue.from("xforceplus")))
                .range(1, 10);

        businessFacade.findByCondition(companyByCode, expRel);

        //关联关系查询
        ExpRel subRel;
        subRel = ExpFactory.createFrom(new RequestBuilder()
                .subField("department", "name", ConditionOp.eq, "xxxx")
                .pageNo(1)
                .pageSize(10)
                .build());

        subRel = new ExpQuery().filters(ExpCondition.call(ExpOperator.EQUALS, ExpField.field("department.name"), ExpValue.from("xxx")))
                .range(1, 10);


        //关联返回查询
        ExpRel subRet;
        subRet = ExpFactory.createFrom(new RequestBuilder()
                .subItem("department", "name")
                .pageNo(1)
                .pageSize(10)
                .build());

        subRet = new ExpQuery().project(Arrays.asList(ExpField.field("department.name")))
                .range(1, 10);

        //# end::query[]
    }

}
