/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.external.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.oqsengine.external.AuthHandler;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaitedaAuthHandler
implements AuthHandler {
    private Logger logger = LoggerFactory.getLogger(BaitedaAuthHandler.class);
    @Autowired
    private ObjectMapper mapper;

    @Override
    public String getCode() {
        return "baiteda";
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void mutation(SimpleHttpRequest httpRequest) {
        if (httpRequest.getBody() != null) {
            Map originMapping;
            String bodyText = httpRequest.getBodyText();
            try {
                originMapping = (Map)this.mapper.readValue(bodyText, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Cannot convert request mapping");
            }
            Object app_id = originMapping.get("app_id");
            Object appSecret = originMapping.get("app_secret");
            Object tenant_id = originMapping.get("tenant_id");
            LocalDateTime now = LocalDateTime.now();
            String timestampStr = now.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            String bizParams = null;
            try {
                bizParams = this.mapper.writeValueAsString((Object)originMapping);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            HashMap<String, String> lastRequestMap = new HashMap<String, String>();
            lastRequestMap.put("app_id", Optional.ofNullable(app_id).map(Object::toString).orElse(""));
            lastRequestMap.put("timestamp", timestampStr);
            lastRequestMap.put("biz_params", bizParams);
            try {
                lastRequestMap.put("sign", BaitedaAuthHandler.generateSign(Optional.ofNullable(appSecret).map(Objects::toString).orElse(""), timestampStr, bizParams));
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            lastRequestMap.put("tenant_id", (String)tenant_id);
            try {
                String lastJsonValue = this.mapper.writeValueAsString(lastRequestMap);
                httpRequest.setBody(lastJsonValue, httpRequest.getBody().getContentType());
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
    }

    private static String generateSign(String appSecret, String timestamp, String bizParams) throws NoSuchAlgorithmException {
        StringBuilder sb = new StringBuilder();
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            String str = appSecret + timestamp + bizParams;
            md5.update(str.getBytes());
            byte[] hash = md5.digest();
            for (int i = 0; i < hash.length; ++i) {
                if ((0xFF & hash[i]) < 16) {
                    sb.append("0" + Integer.toHexString(0xFF & hash[i]));
                    continue;
                }
                sb.append(Integer.toHexString(0xFF & hash[i]));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return sb.toString();
    }
}

