/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.external.facade;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.facade.ExternalFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.ProfileFetcher;
import com.xforceplus.ultraman.oqsengine.sdk.facade.QueryProvider;
import com.xforceplus.ultraman.oqsengine.sdk.facade.option.QueryOption;
import com.xforceplus.ultraman.oqsengine.sdk.facade.remote.RemoteExecutionResponse;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpCondition;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpContext;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRange;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpValue;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassEngine;
import com.xforceplus.ultraman.oqsengine.sdk.utils.RelTreeHelper;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class ExternalQueryProvider
implements QueryProvider {
    private final ContextService contextService;
    private final ExternalFacade externalFacade;
    private final IEntityClassEngine engine;
    private final ProfileFetcher fetcher;

    public ExternalQueryProvider(ExternalFacade externalFacade, IEntityClassEngine engine, ProfileFetcher fetcher, ContextService contextService) {
        this.contextService = contextService;
        this.externalFacade = externalFacade;
        this.engine = engine;
        this.fetcher = fetcher;
    }

    public boolean accept(IEntityClass entityClass) {
        return entityClass.getType() == 1;
    }

    public CompletableFuture<List<Object>> batchQuery(IEntityClass entityClass, List<String> ids) {
        ExpQuery batchSearch = new ExpQuery().filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.IN, (ExpNode)ExpField.ID, (List)ExpValue.from(ids))).range(Integer.valueOf(1), Integer.valueOf(ids.size()));
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("rel", batchSearch);
        mapping.put("search.pageNo", Optional.ofNullable(batchSearch.getRange()).map(ExpRange::getIndex).orElse(0));
        mapping.put("search.pageSize", Optional.ofNullable(batchSearch.getRange()).map(ExpRange::getSize).orElse(0));
        mapping.put("_classId", entityClass.id());
        HashMap<String, List<String>> dummyMapping = new HashMap<String, List<String>>();
        if (ids.size() == 1) {
            dummyMapping.put("id", ids);
        } else {
            dummyMapping.put("id$$in", ids);
        }
        mapping.put("_rel_flatten", dummyMapping);
        RemoteExecutionResponse queryResult = this.externalFacade.remoteExecute(entityClass, "query", mapping, Optional.ofNullable(this.contextService).map(ContextService::getAll).orElseGet(Collections::emptyMap));
        if (queryResult.getCode() == 1) {
            if (queryResult.getResult() != null) {
                Tuple2 retList = queryResult.getResult() instanceof Tuple2 ? (Tuple2)queryResult.getResult() : Tuple.of((Object)1, Arrays.asList((Map)queryResult.getResult()));
                return CompletableFuture.completedFuture(retList._2());
            }
            throw new RuntimeException("query result is null");
        }
        throw new RuntimeException(queryResult.getMessage());
    }

    public Object query(IEntityClass entityClass, ExpRel expRel, QueryOption ... queryOptions) {
        Map contextMapping = Optional.ofNullable(this.contextService).map(ContextService::getAll).orElseGet(Collections::emptyMap);
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("rel", expRel);
        mapping.put("_classId", entityClass.id());
        ExpContext context = new ExpContext();
        String profile = this.fetcher.getProfile(contextMapping);
        context.setSchema(this.engine.describe(entityClass, profile));
        mapping.put("_rel_flatten", RelTreeHelper.flatTree((ExpRel)expRel, (ExpContext)context, (String)profile));
        RemoteExecutionResponse queryResult = this.externalFacade.remoteExecute(entityClass, "query", mapping, contextMapping);
        if (queryResult.getCode() == 1) {
            if (queryResult.getResult() != null) {
                Tuple2 retList = queryResult.getResult() instanceof Tuple2 ? (Tuple2)queryResult.getResult() : Tuple.of((Object)1, Arrays.asList((Map)queryResult.getResult()));
                if (!this.hasOption(queryOptions, QueryOption.UNBOX)) {
                    HashMap<String, Object> retLastMap = new HashMap<String, Object>();
                    retLastMap.put("row", retList._2());
                    retLastMap.put("totalCount", retList._1());
                    return retLastMap;
                }
                return retList._2();
            }
            throw new RuntimeException("query result is null");
        }
        throw new RuntimeException(queryResult.getMessage());
    }
}

