/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.external.facade;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.facade.ExternalFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.MutationProvider;
import com.xforceplus.ultraman.oqsengine.sdk.facade.remote.RemoteExecutionResponse;
import io.vavr.Tuple2;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalMutationProvider
implements MutationProvider {
    private final ExternalFacade externalFacade;
    private Logger logger = LoggerFactory.getLogger(ExternalMutationProvider.class);

    public ExternalMutationProvider(ExternalFacade externalFacade) {
        this.externalFacade = externalFacade;
    }

    public boolean accept(IEntityClass entityClass) {
        return entityClass.getType() == 1;
    }

    private Map<String, Object> getResult(RemoteExecutionResponse response) {
        Object result = response.getResult();
        Map resultMapping = new HashMap();
        if (result != null) {
            if (result instanceof Tuple2) {
                Tuple2 tuple = (Tuple2)result;
                List maps = (List)tuple._2();
                if (!maps.isEmpty()) {
                    resultMapping = (Map)maps.get(0);
                }
            } else {
                resultMapping = (Map)result;
            }
            return resultMapping;
        }
        return Collections.emptyMap();
    }

    public String create(IEntityClass entityClass, Map<String, Object> body, Map<String, Object> context) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.putAll(body);
        bodyMap.put("_classId", entityClass.id());
        RemoteExecutionResponse createResult = this.externalFacade.remoteExecute(entityClass, "create", bodyMap, context);
        if (createResult.getCode() == 1) {
            Map<String, Object> result = this.getResult(createResult);
            Object id = result.get("_id");
            if (id != null) {
                return id.toString();
            }
            this.logger.warn("no property named _id found");
            return "-1";
        }
        throw new RuntimeException(createResult.getMessage());
    }

    public String batchCreate(IEntityClass entityClass, List<Map<String, Object>> inputBodies, Map<String, Object> context) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("_bodies", inputBodies);
        bodyMap.put("_classId", entityClass.id());
        RemoteExecutionResponse createResult = this.externalFacade.remoteExecute(entityClass, "batchCreate", bodyMap, context);
        if (createResult.getCode() == 1) {
            Map<String, Object> result = this.getResult(createResult);
            Object rows = result.get("_rows");
            if (rows != null) {
                return rows.toString();
            }
            this.logger.warn("no property named _row found");
            return "0";
        }
        throw new RuntimeException(createResult.getMessage());
    }

    public String update(IEntityClass entityClass, long id, Map<String, Object> body, Map<String, Object> context) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.putAll(body);
        bodyMap.put("_objId", id);
        bodyMap.put("_classId", entityClass.id());
        RemoteExecutionResponse createResult = this.externalFacade.remoteExecute(entityClass, "update", bodyMap, context);
        if (createResult.getCode() == 1) {
            return "1";
        }
        throw new RuntimeException(createResult.getMessage());
    }

    public String batchUpdate(IEntityClass entityClass, List<Map<String, Object>> inputBodies, Map<String, Object> context) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("_bodies", inputBodies);
        bodyMap.put("_classId", entityClass.id());
        RemoteExecutionResponse createResult = this.externalFacade.remoteExecute(entityClass, "batchUpdate", bodyMap, context);
        if (createResult.getCode() == 1) {
            Map<String, Object> result = this.getResult(createResult);
            Object rows = result.get("_rows");
            if (rows != null) {
                return rows.toString();
            }
            this.logger.warn("no property named _row found");
            return "0";
        }
        throw new RuntimeException(createResult.getMessage());
    }

    public String delete(IEntityClass entityClass, long id, Map<String, Object> context) {
        HashMap<String, Long> deleteMap = new HashMap<String, Long>();
        deleteMap.put("_objId", id);
        deleteMap.put("_classId", entityClass.id());
        RemoteExecutionResponse queryOne = this.externalFacade.remoteExecute(entityClass, "delete", deleteMap, context);
        if (queryOne.getCode() == 1) {
            return "1";
        }
        throw new RuntimeException(queryOne.getMessage());
    }

    public String batchDelete(IEntityClass entityClass, List<Long> ids, Map<String, Object> context) {
        HashMap<String, List<Long>> body = new HashMap<String, List<Long>>();
        body.put("_objIds", ids);
        body.put("_classId", (List<Long>)entityClass);
        RemoteExecutionResponse deleteMultiResult = this.externalFacade.remoteExecute(entityClass, "batchDelete", body, context);
        if (deleteMultiResult.getCode() == 1) {
            Map<String, Object> result = this.getResult(deleteMultiResult);
            Object rows = result.get("_rows");
            if (rows != null) {
                return rows.toString();
            }
            this.logger.warn("no property named _row found");
            return "0";
        }
        throw new RuntimeException(deleteMultiResult.getMessage());
    }

    public String custom(IEntityClass entityClass, String actionName, Map<String, Object> argument, Map<String, Object> context) {
        RemoteExecutionResponse queryOne = this.externalFacade.remoteExecute(entityClass, actionName, argument, context);
        if (queryOne.getCode() == 1) {
            return queryOne.getResult().toString();
        }
        throw new RuntimeException(queryOne.getMessage());
    }
}

