/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.external;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.ultraman.oqsengine.external.AuthHandler;
import com.xforceplus.ultraman.oqsengine.external.domain.ExternalServiceConfig;
import com.xforceplus.ultraman.oqsengine.external.domain.HttpServiceConfig;
import com.xforceplus.ultraman.oqsengine.external.utils.SHA256Utils;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.facade.ExternalFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.remote.RemoteExecutionResponse;
import com.xforceplus.ultraman.oqsengine.sdk.metric.ParamLog;
import com.xforceplus.ultraman.oqsengine.sdk.metric.SpanLog;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.ApiDetails;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.ApiRule;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import com.xplat.ultraman.api.management.convertor.executor.ConvertWrapper;
import com.xplat.ultraman.api.management.convertor.pojo.ExpressionRule;
import com.xplat.ultraman.api.management.convertor.pojo.Rule;
import com.xplat.ultraman.api.management.convertor.pojo.enums.RuleType;
import com.xplat.ultraman.api.management.pojo.auth.AuthTemplateType;
import com.xplat.ultraman.api.management.pojo.enums.Method;
import com.xplat.ultraman.api.management.restclient.agent.executor.AgentExecutor;
import com.xplat.ultraman.api.management.restclient.dto.AgentClient;
import com.xplat.ultraman.api.management.restclient.dto.AuthTemplate;
import com.xplat.ultraman.api.management.restclient.rest.ParameterTypeReference;
import io.sentry.Sentry;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.util.UriTemplate;

public class ExternalServiceImpl
implements ExternalFacade {
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private List<AuthHandler> authHandlers;
    @Autowired
    private ConvertWrapper convertWrapper;
    @Autowired
    private AgentExecutor agentExecutor;
    @Value(value="${ultraman.api.server.env:inte}")
    private String env = "inte";
    private Logger logger = LoggerFactory.getLogger(ExternalFacade.class);
    private static String NO_RELATED_CONFIG = "\u6ca1\u6709\u76f8\u5e94\u914d\u7f6e";
    private static String NOT_SUPPORTED = "\u4e0d\u652f\u6301\u7684\u914d\u7f6e";
    private LoadingCache<Tuple2<Long, String>, ApiDetails> l2Cache;
    private final CloseableHttpAsyncClient client;

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public List<AuthHandler> getAuthHandlers() {
        return this.authHandlers;
    }

    public void setAuthHandlers(List<AuthHandler> authHandlers) {
        this.authHandlers = authHandlers;
    }

    public AgentExecutor getAgentExecutor() {
        return this.agentExecutor;
    }

    public void setAgentExecutor(AgentExecutor agentExecutor) {
        this.agentExecutor = agentExecutor;
    }

    public ConvertWrapper getConvertWrapper() {
        return this.convertWrapper;
    }

    public void setConvertWrapper(ConvertWrapper convertWrapper) {
        this.convertWrapper = convertWrapper;
    }

    public ExternalServiceImpl(MetadataRepository metadataRepository) {
        this.metadataRepository = metadataRepository;
        this.l2Cache = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(Duration.ofSeconds(30L)).build(key -> {
            String actionCode = (String)key._2;
            Long id = (Long)key._1;
            return metadataRepository.loadApiByCodeAndEntityClass(actionCode, id.longValue());
        });
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoTimeout(Timeout.ofSeconds((long)5L)).build();
        this.client = HttpAsyncClients.custom().setIOReactorConfig(ioReactorConfig).build();
        this.client.start();
    }

    public void shutDown() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ExternalServiceConfig loadConfig(IEntityClass entityClass, String actionCode) {
        ApiDetails apiDetails = (ApiDetails)this.l2Cache.get((Object)Tuple.of((Object)entityClass.id(), (Object)actionCode));
        if (apiDetails == null) {
            return null;
        }
        return this.toHttpServiceConfig(apiDetails);
    }

    private HttpServiceConfig toHttpServiceConfig(ApiDetails apiDetails) {
        HttpServiceConfig httpServiceConfig = new HttpServiceConfig();
        httpServiceConfig.setUrl(apiDetails.getExternalUrl());
        httpServiceConfig.setAuthType(apiDetails.getAuthCode());
        httpServiceConfig.setMethod(apiDetails.getMethod());
        httpServiceConfig.setFixedHeader(apiDetails.getFixedHeaders());
        ArrayList<Rule> headerRule = new ArrayList<Rule>();
        ArrayList<Rule> pathRule = new ArrayList<Rule>();
        ArrayList<Rule> paramsRule = new ArrayList<Rule>();
        ArrayList<Rule> bodyRule = new ArrayList<Rule>();
        ArrayList<Rule> responseRule = new ArrayList<Rule>();
        apiDetails.getRules().forEach(rule -> {
            ExpressionRule expRule = this.toRule((ApiRule)rule);
            String type = rule.getType();
            if (type.equals("1")) {
                headerRule.add((Rule)expRule);
            } else if (type.equals("3")) {
                pathRule.add((Rule)expRule);
            } else if (type.equals("2")) {
                paramsRule.add((Rule)expRule);
            } else if (type.equals("4")) {
                bodyRule.add((Rule)expRule);
            } else if (type.equals("5")) {
                responseRule.add((Rule)expRule);
            }
        });
        httpServiceConfig.setHeaderRules(headerRule);
        httpServiceConfig.setParamsRules(paramsRule);
        httpServiceConfig.setPathRules(pathRule);
        httpServiceConfig.setBodyRules(bodyRule);
        httpServiceConfig.setResponseBodyRules(responseRule);
        return httpServiceConfig;
    }

    private ExpressionRule toRule(ApiRule rule) {
        String expression = rule.getExpression();
        ExpressionRule expressionRule = new ExpressionRule(expression, SHA256Utils.getSHA256(expression), null, null, false, RuleType.AVIATOR_RULE);
        return expressionRule;
    }

    private Map<String, Object> prettyContext(Map<String, Object> originContext) {
        Arrays.stream(ContextKeys.StringKeys.values()).forEach(x -> {
            if (originContext.containsKey(x.name())) {
                switch (x) {
                    case USERNAME: {
                        originContext.put("username", originContext.get(x.name()));
                        break;
                    }
                    case USER_DISPLAYNAME: {
                        originContext.put("displayName", originContext.get(x.name()));
                        break;
                    }
                    case OPERATION_NAME: {
                        originContext.put("operationName", originContext.get(x.name()));
                        break;
                    }
                    case TRANSACTION_KEY: {
                        originContext.put("transaction", originContext.get(x.name()));
                        break;
                    }
                    case TENANTID_KEY: {
                        originContext.put("tenantId", originContext.get(x.name()));
                        break;
                    }
                    case TENANTCODE_KEY: {
                        originContext.put("tenantCode", originContext.get(x.name()));
                        break;
                    }
                    case APPCODE: {
                        originContext.put("appCode", originContext.get(x.name()));
                        break;
                    }
                    case INVOKER_INFO: {
                        originContext.put("invokerInfo", originContext.get(x.name()));
                        break;
                    }
                }
            }
        });
        return originContext;
    }

    @SpanLog
    public RemoteExecutionResponse remoteExecute(IEntityClass entityClass, @ParamLog(value="actionCode") String actionCode, @ParamLog(value="variables") Map<String, Object> vars, @ParamLog(value="context") Map<String, Object> context) {
        ExternalServiceConfig externalServiceConfig = this.loadConfig(entityClass, actionCode);
        RemoteExecutionResponse response = null;
        response = externalServiceConfig != null ? (externalServiceConfig instanceof HttpServiceConfig ? this.doHttpExecution((HttpServiceConfig)externalServiceConfig, vars, this.prettyContext(context)) : new RemoteExecutionResponse(-1, NOT_SUPPORTED, null)) : new RemoteExecutionResponse(-1, NO_RELATED_CONFIG, null);
        return response;
    }

    private URI renderPath(String urlTemplate, Map<String, Object> variables) {
        UriTemplate template = new UriTemplate(urlTemplate);
        List variableNames = template.getVariableNames();
        Object[] objects = variableNames.stream().map(x -> variables.get(x)).toArray(Object[]::new);
        return template.expand(objects);
    }

    private RemoteExecutionResponse doHttpExecution(HttpServiceConfig httpServiceConfig, Map<String, Object> inputValue, Map<String, Object> context) {
        Either result;
        block16: {
            String method = httpServiceConfig.getMethod();
            String urlTemplate = httpServiceConfig.getUrl();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.putAll(inputValue);
            variables.putAll(context);
            List<Rule> headerRules = httpServiceConfig.getHeaderRules();
            Map headerMap = this.convertWrapper.wrapped(headerRules, variables);
            List<Rule> pathRules = httpServiceConfig.getPathRules();
            Map pathMap = this.convertWrapper.wrapped(pathRules, variables);
            List<Rule> paramsRules = httpServiceConfig.getParamsRules();
            Map paramsMap = this.convertWrapper.wrapped(paramsRules, variables);
            HashMap<String, Object> combinedPathMap = new HashMap<String, Object>();
            combinedPathMap.putAll(context);
            combinedPathMap.putAll(pathMap);
            URI url = this.renderPath(urlTemplate, combinedPathMap);
            AuthTemplate template = new AuthTemplate(this.env, httpServiceConfig.getAuthType(), AuthTemplateType.API_KEY_AUTH);
            AgentClient.AgentClientBuilder builder = new AgentClient.AgentClientBuilder(template, url.toString());
            List<Map<String, Object>> fixedHeaders = httpServiceConfig.getFixedHeader();
            HashMap<String, Object> headerParams = new HashMap<String, Object>();
            context.forEach((k, v) -> {
                headerParams.put("${" + k.toLowerCase() + "}", v);
                headerParams.put("${" + k + "}", v);
            });
            for (Map<String, Object> fixedHeader : fixedHeaders) {
                Object defaultValue = fixedHeader.get("defaultValue");
                Object key = fixedHeader.get("key");
                if (key == null || defaultValue == null) continue;
                headerParams.put("${" + key.toString() + "}", defaultValue);
            }
            builder.headerVariables(headerParams);
            if ("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) {
                List<Rule> bodyRules = httpServiceConfig.getBodyRules();
                Map body = this.convertWrapper.wrapped(bodyRules, variables);
                this.logger.info("[External]:{}", (Object)body);
                Sentry.captureMessage((String)"[External-debug]");
                if ("POST".equalsIgnoreCase(method)) {
                    builder.method(Method.POST).body((Object)body).parameters(paramsMap).headers(headerMap);
                } else if ("PUT".equalsIgnoreCase(method)) {
                    builder.method(Method.PUT).body((Object)body).parameters(paramsMap).headers(headerMap);
                }
            } else if ("GET".equalsIgnoreCase(method)) {
                builder.method(Method.GET).parameters(paramsMap).headers(headerMap);
            } else if ("DELETE".equalsIgnoreCase(method)) {
                builder.method(Method.DELETE).parameters(paramsMap).headers(headerMap);
            } else {
                throw new RuntimeException(method + " current is not support");
            }
            ParameterTypeReference<Object> reference = new ParameterTypeReference<Object>(){};
            builder.parameterTypeReference((ParameterTypeReference)reference);
            try {
                Object value = this.agentExecutor.execute(builder.builder());
                this.logger.info("Exter");
                if (value instanceof Map) {
                    result = Either.right((Object)((Map)value));
                    break block16;
                }
                if (value instanceof Collection) {
                    HashMap resultMap = new HashMap();
                    resultMap.put("retList", resultMap);
                    result = Either.right(resultMap);
                    break block16;
                }
                throw new RuntimeException("Only accept 'Map' Or 'Collection' Remote result");
            }
            catch (Exception ex) {
                this.logger.error("{}", (Throwable)ex);
                Sentry.captureException((Throwable)ex);
                result = Either.left((Object)ex);
            }
        }
        try {
            return this.toResponseFromString((Either<Exception, Map<String, Object>>)result, httpServiceConfig);
        }
        catch (Exception e) {
            this.logger.error("{}", (Throwable)e);
            Sentry.captureException((Throwable)e);
            return new RemoteExecutionResponse(-1, Optional.ofNullable(e.getMessage()).orElse("message is missing"), null);
        }
    }

    private RemoteExecutionResponse toResponse(Either<Exception, SimpleHttpResponse> responseEither, HttpServiceConfig httpServiceConfig) {
        if (responseEither.isRight()) {
            SimpleHttpResponse simpleHttpResponse = (SimpleHttpResponse)responseEither.get();
            if (simpleHttpResponse.getContentType() != ContentType.APPLICATION_JSON) {
                this.logger.warn("Cannot support contentType {}", (Object)simpleHttpResponse.getContentType());
            }
            byte[] bodyBytes = simpleHttpResponse.getBody().getBodyBytes();
            if (simpleHttpResponse.getCode() == 200) {
                Map retObj;
                Map map = new HashMap();
                try {
                    JsonNode jsonNode = this.objectMapper.readTree(bodyBytes);
                    if (jsonNode.isArray()) {
                        throw new RuntimeException("Array is not support");
                    }
                    map = (Map)this.objectMapper.convertValue((Object)jsonNode, Map.class);
                }
                catch (IOException e) {
                    this.logger.error("{}", (Throwable)e);
                    return new RemoteExecutionResponse(-1, e.getMessage(), null);
                }
                Map wrapped = this.convertWrapper.wrapped(httpServiceConfig.getResponseBodyRules(), map);
                if (wrapped.containsKey("_result")) {
                    Object totalCountInRet;
                    List mapResult = (List)wrapped.get("_result");
                    Integer totalCount = mapResult.size();
                    if (wrapped.containsKey("_totalCount") && (totalCountInRet = wrapped.get("_totalCount")) != null) {
                        totalCount = Integer.parseInt(totalCountInRet.toString());
                    }
                    retObj = Tuple.of((Object)totalCount, (Object)mapResult);
                } else {
                    retObj = wrapped;
                }
                return new RemoteExecutionResponse(1, simpleHttpResponse.getBodyText(), (Object)retObj);
            }
            return new RemoteExecutionResponse(-1, simpleHttpResponse.getBodyText(), null);
        }
        return new RemoteExecutionResponse(-1, responseEither.getLeft() != null ? ((Exception)responseEither.getLeft()).getMessage() : "\u672a\u77e5\u9519\u8bef", null);
    }

    private RemoteExecutionResponse toResponseFromString(Either<Exception, Map<String, Object>> mapEither, HttpServiceConfig httpServiceConfig) {
        if (mapEither.isRight()) {
            Map retObj;
            Map wrapped = this.convertWrapper.wrapped(httpServiceConfig.getResponseBodyRules(), (Map)mapEither.get());
            if (wrapped.containsKey("_code") && !"1".equals(wrapped.get("_code"))) {
                Object msg = wrapped.get("_msg");
                return new RemoteExecutionResponse(-1, Optional.ofNullable(msg).map(Object::toString).orElse(""), null);
            }
            if (wrapped.containsKey("_result")) {
                Object totalCountInRet;
                List mapResult = (List)wrapped.get("_result");
                Integer totalCount = mapResult.size();
                if (wrapped.containsKey("_totalCount") && (totalCountInRet = wrapped.get("_totalCount")) != null) {
                    totalCount = new BigDecimal(totalCountInRet.toString()).intValue();
                }
                retObj = Tuple.of((Object)totalCount, (Object)mapResult);
            } else {
                retObj = wrapped;
            }
            return new RemoteExecutionResponse(1, "ok", (Object)retObj);
        }
        return new RemoteExecutionResponse(-1, ((Exception)mapEither.getLeft()).getMessage(), null);
    }
}

