/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.init;

import akka.japi.function.Creator;
import akka.stream.ActorMaterializer;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.javadsl.AsPublisher;
import akka.stream.javadsl.Sink;
import com.xforceplus.ultraman.config.ConfigurationEngine;
import com.xforceplus.ultraman.config.json.JsonConfigNode;
import com.xforceplus.ultraman.metadata.grpc.Base;
import com.xforceplus.ultraman.metadata.grpc.DictCheckServiceClient;
import com.xforceplus.ultraman.metadata.grpc.DictUpResult;
import com.xforceplus.ultraman.oqsengine.sdk.config.AppIdResolver;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthConfig;
import com.xforceplus.ultraman.oqsengine.sdk.init.OfflineSupport;
import com.xforceplus.xplat.galaxy.grpc.client.LongConnect;
import io.reactivex.Observable;
import io.vavr.Tuple2;
import java.io.Serializable;
import java.util.List;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;

@Order
public class DictInitService
extends OfflineSupport<DictUpResult>
implements InitializingBean {
    @Autowired
    private DictCheckServiceClient client;
    @Autowired
    private ActorMaterializer mat;
    private AuthConfig authConfig;
    private Logger logger = LoggerFactory.getLogger(DictInitService.class);
    @Autowired
    private ConfigurationEngine<DictUpResult, JsonConfigNode> dictConfigEngine;

    public DictInitService(AuthConfig authConfig, boolean isOffline) {
        super(isOffline);
        this.authConfig = authConfig;
    }

    public void afterPropertiesSet() throws Exception {
        Observable dictUpSource = this.getSource();
        this.dictConfigEngine.registerSource(dictUpSource);
    }

    @Override
    public Observable<DictUpResult> getOnlineSource() {
        String appIds = this.authConfig.getAppId();
        List<Tuple2<String, String>> appAndEnvTuple = AppIdResolver.getAppAndEnvTuple(appIds, this.authConfig.getEnv());
        return appAndEnvTuple.stream().map(x -> {
            Base.Authorization request = Base.Authorization.newBuilder().setAppId((String)x._1()).setTenantId(this.authConfig.getTenant()).setEnv((String)x._2()).build();
            Publisher dictPublisher = (Publisher)LongConnect.safeSource((int)2, (int)20, (Creator & Serializable)() -> this.client.checkStreaming(request)).log("DictService").runWith((Graph)Sink.asPublisher((AsPublisher)AsPublisher.WITH_FANOUT), (Materializer)this.mat);
            return Observable.fromPublisher((Publisher)dictPublisher);
        }).reduce(Observable::mergeWith).orElseGet(() -> {
            this.logger.warn("Empty Dict Source");
            return Observable.empty();
        });
    }
}

