/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.init;

import com.xforceplus.ultraman.config.ConfigurationEngine;
import com.xforceplus.ultraman.config.json.JsonConfigNode;
import com.xforceplus.ultraman.config.sdk.ConfigClientBuilder;
import com.xforceplus.ultraman.config.sdk.TypedObject;
import com.xforceplus.ultraman.config.sdk.utils.ZipUtils;
import com.xforceplus.ultraman.metadata.grpc.Api;
import com.xforceplus.ultraman.metadata.grpc.BoUp;
import com.xforceplus.ultraman.metadata.grpc.Field;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.metadata.grpc.Relation;
import io.reactivex.Observable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.yaml.snakeyaml.Yaml;

@Order
public class ModuleInitFromK8s
implements InitializingBean {
    @Value(value="${xplat.oqsengine.sdk.meta.namespace:ultraman-pre}")
    private String namespace;
    @Value(value="${xplat.oqsengine.sdk.meta.version:v1alpha1}")
    private String version;
    @Value(value="${xplat.oqsengine.sdk.meta.labelSelector:#{null}}")
    private String labelSelector = null;
    @Autowired
    private ConfigurationEngine<ModuleUpResult, JsonConfigNode> moduleConfigEngine;

    public void afterPropertiesSet() throws Exception {
        Observable observable = ConfigClientBuilder.newBuilder().group("config.xforcecloud.com").version(this.version).name("businessobjs").labelSelector(this.labelSelector).namespace(this.namespace).build().getObservable();
        Observable result = observable.filter(x -> "ADDED".equals(x.getType())).map(x -> this.toModuleUpResult((TypedObject)x));
        this.moduleConfigEngine.registerSource(result);
    }

    private ModuleUpResult toModuleUpResult(TypedObject object) {
        Map mapped = object.getMapped();
        Map metadata = (Map)mapped.get("metadata");
        Object version = ((Map)metadata.get("annotations")).get("version");
        Map spec = (Map)mapped.get("spec");
        List bos = (List)spec.get("bos");
        Yaml yaml = new Yaml();
        List boList = bos.stream().map(bo -> {
            String gzip = bo.get("gzip").toString();
            try {
                String unzip = ZipUtils.unzip((String)gzip);
                Map load = (Map)yaml.load(unzip);
                Set keys = load.keySet();
                List apiList = Collections.emptyList();
                List fieldList = Collections.emptyList();
                List relations = Collections.emptyList();
                String id = "";
                String name = "";
                String code = "";
                String parentId = "";
                if (!keys.isEmpty()) {
                    Map boBody = (Map)load.get(keys.iterator().next());
                    List apis = (List)boBody.get("api");
                    apiList = apis.stream().map(this::toApi).collect(Collectors.toList());
                    List fields = (List)boBody.get("fields");
                    fieldList = fields.stream().map(this::toField).filter(Objects::nonNull).collect(Collectors.toList());
                    List rels = (List)boBody.get("relations");
                    relations = rels.stream().map(this::toRelation).collect(Collectors.toList());
                    id = String.valueOf(boBody.get("id"));
                    name = String.valueOf(boBody.get("name"));
                    parentId = String.valueOf(boBody.get("parentBoId"));
                }
                BoUp build = BoUp.newBuilder().addAllApis(apiList).addAllFields(fieldList).addAllRelations(relations).setId(id).setName(name).setCode(code).setParentBoId(parentId).build();
                return build;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList());
        ModuleUpResult module = ModuleUpResult.newBuilder().setId(1L).setVersion(version.toString()).addAllBoUps(boList).build();
        return module;
    }

    private Api toApi(Map<String, Object> apis) {
        return Api.newBuilder().setCode(String.valueOf(apis.get("code"))).setMethod(String.valueOf(apis.get("method"))).setUrl(String.valueOf(apis.get("url"))).build();
    }

    private Relation toRelation(Map<String, Object> rel) {
        return Relation.newBuilder().setRelName(String.valueOf(rel.get("relationCode"))).setBoId(String.valueOf(rel.get("boId"))).setJoinBoId(String.valueOf(rel.get("joinBoId"))).setRelationType(String.valueOf(rel.get("relationType"))).build();
    }

    private Field toField(Map<String, Object> field) {
        return field.entrySet().stream().map(entry -> {
            Map mapping = (Map)entry.getValue();
            String id = String.valueOf(mapping.get("id"));
            String code = String.valueOf(mapping.get("code"));
            String name = String.valueOf(mapping.get("name"));
            String fieldType = String.valueOf(mapping.get("fieldType"));
            String dictId = Optional.ofNullable(mapping.get("dictId")).map(Object::toString).orElse(null);
            String enumCode = Optional.ofNullable(mapping.get("enumCode")).map(Object::toString).orElse(null);
            String defaultValue = Optional.ofNullable(mapping.get("defaultValue")).map(Object::toString).orElse(null);
            List attrs = (List)mapping.get("attrs");
            String searchType = "false";
            String editType = "1";
            String required = "false";
            String maxLength = "-1";
            int precision = 0;
            if (!attrs.isEmpty()) {
                Map attrMap = (Map)attrs.get(0);
                searchType = Optional.ofNullable(attrMap.get("searchType")).map(Object::toString).orElse("false");
                editType = Optional.ofNullable(attrMap.get("editType")).map(Object::toString).orElse("1");
                required = "0".equals(attrMap.get("canNil")) ? "true" : "false";
                maxLength = Optional.ofNullable(attrMap.get("maxSize")).map(Object::toString).orElse("-1");
                precision = Optional.ofNullable(attrMap.get("decimalPoint")).map(Object::toString).map(Integer::parseInt).orElse(0);
            }
            Field.Builder builder = Field.newBuilder();
            builder = builder.setId(id).setCode(code).setName(name).setFieldType(fieldType).setSearchable(searchType).setEditable(editType).setRequired(required).setMaxLength(maxLength).setPrecision(precision);
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{dictId})) {
                builder = builder.setDictId(dictId);
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{enumCode})) {
                builder = builder.setEnumCode(enumCode);
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{defaultValue})) {
                builder = builder.setDefaultValue(defaultValue);
            }
            return builder.buildPartial();
        }).findFirst().orElse(null);
    }
}

