/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.init;

import com.alibaba.fastjson.JSON;
import com.xforceplus.ultraman.config.ConfigurationEngine;
import com.xforceplus.ultraman.config.json.JsonConfigNode;
import com.xforceplus.ultraman.oqsengine.pojo.auth.Authorization;
import com.xforceplus.ultraman.oqsengine.pojo.dto.UltForm;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.sdk.config.AppIdResolver;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthConfig;
import com.xforceplus.ultraman.oqsengine.sdk.config.ExternalServiceConfig;
import com.xforceplus.ultraman.oqsengine.sdk.init.OfflineSupport;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
import io.reactivex.Observable;
import io.vavr.Tuple2;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Order(value=2)
public class UltFormInitService
extends OfflineSupport<UltForm>
implements InitializingBean {
    final Logger logger = LoggerFactory.getLogger(UltFormInitService.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ConfigurationEngine<UltForm, JsonConfigNode> formConfigEngine;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    private AuthConfig config;

    public UltFormInitService(AuthConfig config, boolean isOffline) {
        super(isOffline);
        this.config = config;
    }

    public void afterPropertiesSet() throws Exception {
        Observable formSource = this.getSource();
        this.formConfigEngine.registerSource(formSource);
    }

    @Override
    public Observable<UltForm> getOnlineSource() {
        String appIds = this.config.getAppId();
        List<Tuple2<String, String>> appAndEnvTuple = AppIdResolver.getAppAndEnvTuple(appIds, this.config.getEnv());
        return appAndEnvTuple.stream().map(x -> {
            this.logger.info("begin init forms config");
            String accessUri = null;
            try {
                accessUri = ExternalServiceConfig.PfcpAccessUri();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String url = String.format("%s/forms/init", accessUri);
            Authorization auth = new Authorization();
            if (FieldType.LONG.canParseFrom((String)x._1()).booleanValue()) {
                auth.setAppId(Long.valueOf(Long.parseLong((String)x._1())));
            } else {
                auth.setAppCode((String)x._1());
            }
            auth.setBranch(Optional.ofNullable(this.config.getBranch()).orElse(""));
            auth.setEnv((String)x._2());
            Response result = new Response();
            try {
                HttpHeaders headers = new HttpHeaders();
                MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
                headers.setContentType(type);
                headers.add("Accept", MediaType.APPLICATION_JSON.toString());
                HttpEntity authorizeEntity = new HttpEntity((Object)auth, (MultiValueMap)headers);
                result = (Response)this.restTemplate.postForObject(url, (Object)authorizeEntity, Response.class, new Object[0]);
                if (result.getResult() != null) {
                    List ultForms = (List)result.getResult();
                    List collect = ultForms.stream().map(form -> (UltForm)JSON.parseObject((String)JSON.toJSONString((Object)form), UltForm.class)).collect(Collectors.toList());
                    return Observable.fromIterable(collect);
                }
            }
            catch (Exception e) {
                this.logger.info("init forms config failed {}", (Throwable)e);
            }
            return null;
        }).filter(Objects::nonNull).reduce(Observable::merge).orElseGet(() -> {
            this.logger.warn("Empty Form Source");
            return Observable.empty();
        });
    }
}

