/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.listener;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import com.xforceplus.ultraman.config.ConfigNode;
import com.xforceplus.ultraman.metadata.grpc.Base;
import com.xforceplus.ultraman.metadata.grpc.DictUpResult;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.oqsengine.pojo.dto.UltForm;
import com.xforceplus.ultraman.oqsengine.pojo.dto.UltPage;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthConfig;
import com.xforceplus.ultraman.oqsengine.sdk.event.MetadataModuleGotEvent;
import com.xforceplus.ultraman.oqsengine.sdk.event.config.ConfigChangeEvent;
import com.xforceplus.ultraman.oqsengine.sdk.store.DictMapLocalStore;
import com.xforceplus.ultraman.oqsengine.sdk.store.FormBoMapLocalStore;
import com.xforceplus.ultraman.oqsengine.sdk.store.PageBoMapLocalStore;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class ConfigListener {
    @Autowired
    private PageBoMapLocalStore pageBoMapLocalStore;
    @Autowired
    private DictMapLocalStore dictMapLocalStore;
    @Autowired
    private FormBoMapLocalStore formBoMapLocalStore;
    @Autowired
    private MetadataRepository repository;
    private AuthConfig authconfig;
    @Autowired
    private ObjectMapper mapper;
    private Logger logger = LoggerFactory.getLogger(ConfigListener.class);

    public ConfigListener(AuthConfig authconfig) {
        this.authconfig = authconfig;
    }

    @EventListener(condition="#event.type.equals('PAGE')")
    public void pageChangeListener(ConfigChangeEvent event) {
        this.logger.info("UPDATE PAGE");
        ConfigNode confignode = event.getChangeList().getCurrent();
        JsonNode jsonNode = (JsonNode)confignode.getOrigin();
        try {
            UltPage ultPage = (UltPage)this.mapper.treeToValue((TreeNode)jsonNode, UltPage.class);
            this.pageBoMapLocalStore.save(ultPage);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    @EventListener(condition="#event.type.equals('BO')")
    public MetadataModuleGotEvent boChangeListener(ConfigChangeEvent event) {
        this.logger.info("UPDATE BO");
        ConfigNode confignode = event.getChangeList().getCurrent();
        JsonNode jsonNode = (JsonNode)confignode.getOrigin();
        ModuleUpResult.Builder moduleBuilder = ModuleUpResult.newBuilder();
        try {
            JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)moduleBuilder);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        ModuleUpResult moduleUpResult = moduleBuilder.build();
        return new MetadataModuleGotEvent(Base.Authorization.newBuilder().setAppId(moduleUpResult.getAppIds(0)).setTenantId(this.authconfig.getTenant()).build(), Collections.singletonList(moduleUpResult));
    }

    @EventListener(condition="#event.type.equals('DICT')")
    public void dictChangeListener(ConfigChangeEvent event) {
        this.logger.info("UPDATE DICT");
        ConfigNode confignode = event.getChangeList().getCurrent();
        JsonNode jsonNode = (JsonNode)confignode.getOrigin();
        DictUpResult.Builder dictBuilder = DictUpResult.newBuilder();
        try {
            JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)dictBuilder);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        DictUpResult result = dictBuilder.build();
        this.dictMapLocalStore.save(result, result.getAuthorization(0).getAppId());
        if (this.logger.isInfoEnabled()) {
            result.getDictsList().forEach(dict -> this.logger.info("Dict {}:{}:{} saved", new Object[]{dict.getCode(), dict.getPublishDictId(), dict.getId()}));
        }
    }

    @EventListener(condition="#event.type.equals('FORM')")
    public void formChangeListener(ConfigChangeEvent event) {
        this.logger.info("UPDATE FORM");
        ConfigNode confignode = event.getChangeList().getCurrent();
        JsonNode jsonNode = (JsonNode)confignode.getOrigin();
        try {
            UltForm ultForm = (UltForm)this.mapper.treeToValue((TreeNode)jsonNode, UltForm.class);
            this.formBoMapLocalStore.save(ultForm);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }
}

