/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.listener;

import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.oqsengine.sdk.OperationResult;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthConfig;
import com.xforceplus.ultraman.oqsengine.sdk.event.MetadataModuleGotEvent;
import com.xforceplus.ultraman.oqsengine.sdk.event.MetadataModulePrepareResultEvent;
import com.xforceplus.ultraman.oqsengine.sdk.event.MetadataModulePreparedErrorEvent;
import com.xforceplus.ultraman.oqsengine.sdk.event.MetadataModulePreparedEvent;
import com.xforceplus.ultraman.oqsengine.sdk.service.core.EntityGrpcExecutor;
import com.xforceplus.ultraman.oqsengine.sdk.service.core.ExecutionConfig;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.listener.GlobalInited;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.CurrentUpdateService;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.concurrent.CompletableToListenableFutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;

public class ModuleEventListener {
    @Autowired
    private MetadataRepository store;
    @Autowired
    private EntityGrpcExecutor entityService;
    Logger logger = LoggerFactory.getLogger(ModuleEventListener.class);
    @Autowired
    public ApplicationEventPublisher publisher;
    @Autowired
    public CurrentUpdateService currentUpdateService;
    @Autowired
    public GlobalInited globalInited;
    private ExecutionConfig executionConfig;
    private AuthConfig authConfig;

    public ModuleEventListener(ExecutionConfig config, AuthConfig authConfig) {
        this.executionConfig = config;
        this.authConfig = authConfig;
    }

    private List<MetadataModulePrepareResultEvent> skipPrepare(MetadataModuleGotEvent event) {
        List response = event.getResponse();
        return response.stream().map(x -> new MetadataModulePreparedEvent(x, event.getRequest().getTenantId(), event.getRequest().getAppId())).collect(Collectors.toList());
    }

    @EventListener(value={MetadataModuleGotEvent.class})
    public ListenableFuture<List<MetadataModulePrepareResultEvent>> saveMetadata(MetadataModuleGotEvent event) {
        String appId = event.getRequest().getAppId();
        String env = this.authConfig.getEnv();
        this.doPrepareTask(appId, env);
        return new CompletableToListenableFutureAdapter(CompletableFuture.completedFuture(this.skipPrepare(event)));
    }

    private void doPrepareTask(String appId, String env) {
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleAtFixedRate(() -> {
            try {
                OperationResult join = (OperationResult)this.entityService.prepare(appId, env).toCompletableFuture().join();
                this.logger.info("prepare for {}:{} result {}", new Object[]{appId, env, join.getMessage()});
            }
            catch (Exception ex) {
                this.logger.error("prepare for {}:{}  result {}", new Object[]{appId, env, ex});
            }
        }, 1L, 60L, TimeUnit.SECONDS);
    }

    @EventListener(value={MetadataModulePreparedEvent.class})
    public void cleanUpdateAndSave(MetadataModulePreparedEvent preparedEvent) {
        MetadataModulePreparedEvent preparedEventType = preparedEvent;
        ModuleUpResult module = preparedEventType.getModuleUpResult();
        this.store.save(module, preparedEventType.getTenantId(), preparedEventType.getAppId());
        this.globalInited.moduleSaved();
    }

    @Async
    @EventListener(value={MetadataModulePreparedErrorEvent.class})
    public void recordFailed(MetadataModulePreparedErrorEvent errorEvent) {
        MetadataModulePreparedErrorEvent errorEventType = errorEvent;
        this.currentUpdateService.recordResults(errorEventType.getModuleUpResult(), errorEventType.getErrorResult());
    }
}

