/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.rebuild;

import akka.NotUsed;
import akka.stream.javadsl.Source;
import com.xforceplus.ultraman.oqsengine.pojo.converter.IEntityClassHelper;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.CdcErrorCond;
import com.xforceplus.ultraman.oqsengine.sdk.CdcErrorTaskInfo;
import com.xforceplus.ultraman.oqsengine.sdk.CdcRecover;
import com.xforceplus.ultraman.oqsengine.sdk.CdcRecoverSubmit;
import com.xforceplus.ultraman.oqsengine.sdk.CommitIdUp;
import com.xforceplus.ultraman.oqsengine.sdk.EntityRebuildService;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.OperationResult;
import com.xforceplus.ultraman.oqsengine.sdk.QueryPage;
import com.xforceplus.ultraman.oqsengine.sdk.RebuildRequest;
import com.xforceplus.ultraman.oqsengine.sdk.RebuildTaskInfo;
import com.xforceplus.ultraman.oqsengine.sdk.ShowTask;
import com.xforceplus.ultraman.oqsengine.sdk.rebuild.dto.CdcErrorCondDTO;
import com.xforceplus.ultraman.oqsengine.sdk.rebuild.dto.CdcErrorTaskInfoDTO;
import com.xforceplus.ultraman.oqsengine.sdk.rebuild.dto.CdcRecoverDTO;
import com.xforceplus.ultraman.oqsengine.sdk.rebuild.dto.CdcRecoverSubmitDTO;
import com.xforceplus.ultraman.oqsengine.sdk.rebuild.dto.CommitIdMaxMinDTO;
import com.xforceplus.ultraman.oqsengine.sdk.rebuild.dto.CommitIdUpDTO;
import com.xforceplus.ultraman.oqsengine.sdk.service.EntityService;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.RebuildRequestDTO;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.TaskInfoDTO;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping
public class EntityRebuildController {
    @Autowired
    private EntityRebuildService rebuildService;
    @Autowired
    private EntityService entityService;
    private static TaskInfoDTO MISSING = new TaskInfoDTO("-1", "\u5bf9\u8c61\u4e0d\u5b58\u5728");

    @GetMapping(value={"/rebuild/{taskId}/taskinfo"}, produces={"application/stream+json"})
    public ResponseEntity<Source<TaskInfoDTO, NotUsed>> getTaskStream(@PathVariable Long taskId) {
        return ResponseEntity.ok((Object)this.rebuildService.showProgress(ShowTask.newBuilder().setId(taskId.longValue()).build()).map(this::toTaskInfoDTO));
    }

    @GetMapping(value={"/rebuild/list/active"}, produces={"application/stream+json"})
    public ResponseEntity<Source<TaskInfoDTO, NotUsed>> listActiveTask(ConditionQueryRequest queryRequest) {
        return ResponseEntity.ok((Object)this.rebuildService.listActiveTasks(QueryPage.newBuilder().setNumber(queryRequest.getPageNo().intValue()).setSize(queryRequest.getPageSize().intValue()).build()).map(this::toTaskInfoDTO));
    }

    @GetMapping(value={"/rebuild/entity/id/{id}/active"})
    public ResponseEntity<CompletionStage<TaskInfoDTO>> showCurrentTaskbyId(@PathVariable String id) {
        return ResponseEntity.ok(this.entityService.load(id).map(this::getActiveTask).orElse(CompletableFuture.completedFuture(MISSING)));
    }

    @GetMapping(value={"/rebuild/entity/code/{code}/active"})
    public ResponseEntity<CompletionStage<TaskInfoDTO>> showCurrentTaskByCode(@PathVariable String code) {
        return ResponseEntity.ok(this.entityService.loadByCode(code).map(this::getActiveTask).orElse(CompletableFuture.completedFuture(MISSING)));
    }

    private CompletionStage<TaskInfoDTO> getActiveTask(IEntityClass entityClass) {
        return this.rebuildService.getActiveTask(IEntityClassHelper.toEntityUp((IEntityClass)entityClass)).thenApply(this::toTaskInfoDTO);
    }

    @GetMapping(value={"/rebuild/list/all"}, produces={"application/stream+json"})
    public ResponseEntity<Source<TaskInfoDTO, NotUsed>> listAllTask(ConditionQueryRequest queryRequest) {
        return ResponseEntity.ok((Object)this.rebuildService.listAllTasks(QueryPage.newBuilder().setNumber(queryRequest.getPageNo().intValue()).setSize(queryRequest.getPageSize().intValue()).build()).map(this::toTaskInfoDTO));
    }

    @PostMapping(value={"/rebuild/{taskId}/cancel"})
    public ResponseEntity<CompletionStage<TaskInfoDTO>> cancel(@PathVariable String taskId) {
        return ResponseEntity.ok(this.rebuildService.cancelTask(ShowTask.newBuilder().setId(Long.parseLong(taskId)).build()).thenApply(this::toTaskInfoDTO));
    }

    @PostMapping(value={"/rebuild/"})
    public ResponseEntity<CompletionStage<TaskInfoDTO>> requestTask(@RequestBody RebuildRequestDTO rebuildRequest) {
        String code = rebuildRequest.getCode();
        String id = rebuildRequest.getId();
        String startDate = rebuildRequest.getStartDate();
        String endDate = rebuildRequest.getEndDate();
        Optional entityClass = Optional.empty();
        if (StringUtils.isEmpty((CharSequence)id)) {
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{code})) {
                entityClass = this.entityService.loadByCode(code);
            }
        } else {
            entityClass = this.entityService.load(id);
        }
        return ResponseEntity.ok(entityClass.map(x -> {
            EntityUp entityUp = IEntityClassHelper.toEntityUp((IEntityClass)x);
            return this.rebuildService.rebuildIndex(RebuildRequest.newBuilder().setEntity(entityUp).setStart(startDate).setEnd(endDate).build()).thenApply(this::toTaskInfoDTO);
        }).orElse(CompletableFuture.completedFuture(MISSING)));
    }

    @PostMapping(value={"/cdc/send-error-recover"})
    public ResponseEntity<CompletionStage<Response>> cdcSendErrorRecover(@RequestBody CdcRecoverSubmitDTO dto) {
        CompletionStage result = this.rebuildService.cdcSendErrorRecover(CdcRecoverSubmit.newBuilder().setSeqNo(dto.getSeqNo().longValue()).setRecoverObjectString(dto.getRecoverObjectString()).build());
        return ResponseEntity.ok((Object)result.toCompletableFuture().thenApply(this::toResponse));
    }

    @PostMapping(value={"/cdc/cdc-recover-ok"})
    public ResponseEntity<CompletionStage<Response>> cdcRecoverOk(@RequestBody CdcRecoverDTO cdcRecoverDTO) {
        return ResponseEntity.ok(this.rebuildService.cdcRecoverOk(CdcRecover.newBuilder().setSeqNo(cdcRecoverDTO.getSeqNo().longValue()).build()).thenApply(this::toResponse));
    }

    @PostMapping(value={"/cdc/query-cdc-error"}, produces={"application/stream+json"})
    public ResponseEntity<Source<CdcErrorTaskInfoDTO, NotUsed>> queryCdcError(@RequestBody CdcErrorCondDTO cond) {
        return ResponseEntity.ok((Object)this.rebuildService.queryCdcError(this.buildCdcCond(cond)).map(this::toCdcErrorTaskInfoDTO));
    }

    @PostMapping(value={"/cdc/range-of-commits"})
    public ResponseEntity<CompletionStage<CommitIdMaxMinDTO>> rangeOfCommits(@RequestBody CommitIdUpDTO upDTO) {
        return ResponseEntity.ok(this.rebuildService.rangeOfCommits(CommitIdUp.newBuilder().setCommitId(upDTO.getCommitId().longValue()).build()).thenApply(x -> {
            CommitIdMaxMinDTO dto = new CommitIdMaxMinDTO();
            dto.setMax(x.getMax());
            dto.setMin(x.getMin());
            return dto;
        }));
    }

    @PostMapping(value={"/cdc/clean-less-than"})
    public ResponseEntity<CompletionStage<Response>> cleanLessThan(@RequestBody CommitIdUpDTO upDTO) {
        return ResponseEntity.ok(this.rebuildService.cleanLessThan(CommitIdUp.newBuilder().setCommitId(upDTO.getCommitId().longValue()).build()).thenApply(this::toResponse));
    }

    private CdcErrorTaskInfoDTO toCdcErrorTaskInfoDTO(CdcErrorTaskInfo info) {
        CdcErrorTaskInfoDTO dto = new CdcErrorTaskInfoDTO();
        dto.setBatchId(info.getBatchId());
        dto.setCommitId(info.getCommitId());
        dto.setEntity(info.getEntity());
        dto.setErrorType(info.getErrorType());
        dto.setExecuteTime(info.getExecuteTime());
        dto.setFixedTime(info.getFixedTime());
        dto.setMessage(info.getMessage());
        dto.setOp(info.getOp());
        dto.setSeqNo(info.getSeqNo());
        dto.setOperationObject(info.getOperationObject());
        dto.setVersion(info.getVersion());
        dto.setStatus(info.getStatus());
        return dto;
    }

    private CdcErrorCond buildCdcCond(CdcErrorCondDTO cond) {
        CdcErrorCond.Builder cdcErrorQueryCondition = CdcErrorCond.newBuilder();
        if (cond.getSeqNo() > 0L) {
            cdcErrorQueryCondition.setSeqNo(cond.getSeqNo().longValue());
        }
        if (cond.getBatchId() > 0L) {
            cdcErrorQueryCondition.setBatchId(cond.getBatchId().longValue());
        }
        if (cond.getId() > 0L) {
            cdcErrorQueryCondition.setId(cond.getId().longValue());
        }
        if (cond.getEntity() > 0L) {
            cdcErrorQueryCondition.setEntity(cond.getEntity().longValue());
        }
        if (cond.getType() > 0) {
            cdcErrorQueryCondition.setType(cond.getType().intValue());
        }
        if (cond.getStatus() > 0) {
            cdcErrorQueryCondition.setStatus(cond.getStatus().intValue());
            cdcErrorQueryCondition.setEqualStatus(cond.isEqualStatus());
        }
        if (cond.getRangeLEExecuteTime() > 0L) {
            cdcErrorQueryCondition.setRangeLEExecuteTime(cond.getRangeLEExecuteTime().longValue());
        }
        if (cond.getRangeGeExecuteTime() > 0L) {
            cdcErrorQueryCondition.setRangeGeExecuteTime(cond.getRangeGeExecuteTime().longValue());
        }
        if (cond.getRangeLEFixedTime() > 0L) {
            cdcErrorQueryCondition.setRangeLEFixedTime(cond.getRangeLEFixedTime().longValue());
        }
        if (cond.getRangeGeFixedTime() > 0L) {
            cdcErrorQueryCondition.setRangeGeFixedTime(cond.getRangeGeFixedTime().longValue());
        }
        return cdcErrorQueryCondition.build();
    }

    private Response toResponse(OperationResult result) {
        Response response = new Response();
        String message = result.getMessage();
        if (result.getCode() == OperationResult.Code.OK) {
            response.setCode("1");
        } else {
            response.setCode("1");
        }
        response.setMessage(message);
        return response;
    }

    private TaskInfoDTO toTaskInfoDTO(RebuildTaskInfo rebuildTaskInfo) {
        TaskInfoDTO dto = new TaskInfoDTO();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{rebuildTaskInfo.getErrCode()}) && Integer.parseInt(rebuildTaskInfo.getErrCode()) < 0) {
            dto.setErrCode(rebuildTaskInfo.getErrCode());
            dto.setMessage(rebuildTaskInfo.getMessage());
            return dto;
        }
        dto.setBatchSize(Integer.valueOf(rebuildTaskInfo.getBatchSize()));
        dto.setCancel(Boolean.valueOf(rebuildTaskInfo.getIsCancel()));
        dto.setDone(Boolean.valueOf(rebuildTaskInfo.getIsDone()));
        dto.setEnds(Long.toString(rebuildTaskInfo.getEnds()));
        dto.setStarts(Long.toString(rebuildTaskInfo.getStarts()));
        dto.setTid(Long.toString(rebuildTaskInfo.getTid()));
        dto.setPercentage(Integer.valueOf(rebuildTaskInfo.getPercentage()));
        dto.setFinishSize(Integer.valueOf(rebuildTaskInfo.getFinishSize()));
        dto.setEntityId(Long.toString(rebuildTaskInfo.getEntityId()));
        dto.setStatus(rebuildTaskInfo.getStatus());
        return dto;
    }
}

