/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.oqsengine.sdk.reexploit.spring;

import com.xforceplus.oqsengine.sdk.reexploit.spring.EntityRepository;
import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsEntityInformationSupport;
import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsMappingContext;
import com.xforceplus.oqsengine.sdk.reexploit.spring.SimpleEntityRepository;
import com.xforceplus.oqsengine.sdk.reexploit.spring.query.OqsQueryMethod;
import com.xforceplus.oqsengine.sdk.reexploit.spring.query.SimpleQuery;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.lang.Nullable;

public class EntityRepositoryFactory
extends RepositoryFactorySupport {
    private final EntityFacade entityFacade;
    private final OqsMappingContext context;

    public EntityRepositoryFactory(EntityFacade entityFacade, OqsMappingContext context) {
        this.entityFacade = entityFacade;
        this.context = context;
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return OqsEntityInformationSupport.getEntityInformation(domainClass);
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        return SimpleEntityRepository.class;
    }

    protected EntityRepository getTargetRepository(RepositoryInformation information) {
        EntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
        Object repository = this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, information, this.context, this.entityFacade});
        return (EntityRepository)repository;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new OqsQueryLookupStrategy());
    }

    private class OqsQueryLookupStrategy
    implements QueryLookupStrategy {
        private OqsQueryLookupStrategy() {
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            OqsQueryMethod queryMethod = new OqsQueryMethod(method, metadata, factory);
            return new SimpleQuery(queryMethod, EntityRepositoryFactory.this.entityFacade, metadata, EntityRepositoryFactory.this.context);
        }
    }
}

