/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.oqsengine.sdk.reexploit.spring.query;

import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.pojo.utils.ConvertHelper;
import com.xforceplus.ultraman.oqsengine.pojo.utils.PropertyHelper;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpCondition;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpSort;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpValue;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.OqsAbstractQueryCreator;
import org.springframework.data.repository.query.parser.OqsPart;
import org.springframework.data.repository.query.parser.OqsPartTree;

public class OqsQueryCreator
extends OqsAbstractQueryCreator<ExpQuery, ExpCondition> {
    IEntityClassReader reader;

    public OqsQueryCreator(OqsPartTree tree, ParameterAccessor parameters, IEntityClassReader reader) {
        super(tree, parameters);
        this.reader = reader;
    }

    public OqsQueryCreator(OqsPartTree tree) {
        super(tree);
    }

    @Override
    protected ExpCondition create(OqsPart part, Iterator<Object> iterator) {
        return this.from(part, iterator);
    }

    @Override
    protected ExpCondition and(OqsPart part, ExpCondition base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, iterator);
        }
        return ExpCondition.call((ExpOperator)ExpOperator.AND, (ExpNode[])new ExpNode[]{this.create(part, iterator), base});
    }

    @Override
    protected ExpCondition or(ExpCondition base, ExpCondition criteria) {
        return ExpCondition.call((ExpOperator)ExpOperator.OR, (ExpNode[])new ExpNode[]{base, criteria});
    }

    @Override
    protected ExpQuery complete(ExpCondition criteria, Sort sort, Pageable pageable) {
        ExpQuery expQuery = new ExpQuery();
        if (criteria != null) {
            expQuery.filters((ExpNode)criteria);
        }
        if (sort != null && sort.isSorted()) {
            expQuery.sort(this.toSort(sort));
        }
        if (pageable != null && !pageable.isUnpaged()) {
            expQuery.range(Integer.valueOf(pageable.getPageNumber()), Integer.valueOf(pageable.getPageSize()));
        }
        return expQuery;
    }

    private ExpSort toSort(Sort sort) {
        if (!sort.isUnsorted()) {
            Iterator iterator = sort.iterator();
            ExpSort expSort = ExpSort.init();
            while (iterator.hasNext()) {
                Sort.Order order = (Sort.Order)iterator.next();
                expSort.withSort(order.getProperty(), order.isAscending() ? "asc" : "desc");
            }
            return expSort;
        }
        return ExpSort.init();
    }

    private ExpCondition from(OqsPart part, Iterator<?> parameters) {
        OqsPart.Type type = part.getType();
        String key = part.getProperty().toDotPath();
        Optional columnName = PropertyHelper.getColumnName((IEntityClassReader)this.reader, (String)key);
        String codeName = (String)columnName.orElseThrow(() -> new RuntimeException("no such field"));
        switch (type) {
            case SIMPLE_PROPERTY: {
                return ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName), ExpValue.fromSingle(parameters.next())});
            }
            case BETWEEN: {
                return ExpCondition.call((ExpOperator)ExpOperator.GREATER_EQ_AND_LESS_EQ, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName), ExpValue.fromSingle(parameters.next()), ExpValue.fromSingle(parameters.next())});
            }
            case LESS_THAN: {
                return ExpCondition.call((ExpOperator)ExpOperator.LESS_THAN, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName), ExpValue.fromSingle(parameters.next())});
            }
            case LESS_THAN_EQUAL: {
                return ExpCondition.call((ExpOperator)ExpOperator.LESS_EQUALS, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName), ExpValue.fromSingle(parameters.next())});
            }
            case GREATER_THAN: {
                return ExpCondition.call((ExpOperator)ExpOperator.GREATER_THAN, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName), ExpValue.fromSingle(parameters.next())});
            }
            case GREATER_THAN_EQUAL: {
                return ExpCondition.call((ExpOperator)ExpOperator.GREATER_EQUALS, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName), ExpValue.fromSingle(parameters.next())});
            }
            case AFTER: {
                return ExpCondition.call((ExpOperator)ExpOperator.GREATER_THAN, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName), ExpValue.fromSingle(parameters.next())});
            }
            case BEFORE: {
                return ExpCondition.call((ExpOperator)ExpOperator.LESS_THAN, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName), ExpValue.fromSingle(parameters.next())});
            }
            case LIKE: {
                return ExpCondition.call((ExpOperator)ExpOperator.LIKE, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName), ExpValue.fromSingle(parameters.next())});
            }
            case STARTING_WITH: {
                return ExpCondition.call((ExpOperator)ExpOperator.LIKE, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName), ExpValue.literal((String)(ConvertHelper.convert(parameters.next()) + "%"))});
            }
            case ENDING_WITH: {
                return ExpCondition.call((ExpOperator)ExpOperator.LIKE, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName), ExpValue.literal((String)("%" + ConvertHelper.convert(parameters.next())))});
            }
            case IS_NOT_EMPTY: {
                return ExpCondition.call((ExpOperator)ExpOperator.IS_NOT_NULL, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName)});
            }
            case IS_EMPTY: {
                return ExpCondition.call((ExpOperator)ExpOperator.IS_NULL, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName)});
            }
            case CONTAINING: {
                return ExpCondition.call((ExpOperator)ExpOperator.LIKE, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName), ExpValue.literal((String)("%" + ConvertHelper.convert(parameters.next()) + "%"))});
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return ExpCondition.call((ExpOperator)ExpOperator.NOT_EQUALS, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName), ExpValue.fromSingle(parameters.next())});
            }
            case IN: 
            case NOT_IN: {
                Object next = parameters.next();
                List values = ExpValue.from(next);
                LinkedList<ExpField> nodes = new LinkedList<ExpField>();
                nodes.add(ExpField.field((String)codeName));
                nodes.addAll(values);
                return ExpCondition.call((ExpOperator)(type == OqsPart.Type.IN ? ExpOperator.IN : ExpOperator.NOT_IN), nodes);
            }
            case TRUE: {
                return ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName), ExpValue.fromSingle((Object)true)});
            }
            case FALSE: {
                return ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode[])new ExpNode[]{ExpField.field((String)codeName), ExpValue.fromSingle((Object)false)});
            }
        }
        throw new RuntimeException("not support");
    }
}

