/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.oqsengine.sdk.reexploit.spring;

import com.xforceplus.oqsengine.sdk.reexploit.spring.EntityRepository;
import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsEntityInformation;
import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsMappingContext;
import com.xforceplus.oqsengine.sdk.reexploit.spring.annotation.OqsEntity;
import com.xforceplus.oqsengine.sdk.reexploit.spring.model.BaseEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.CreateOneResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.DeleteOneResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.QueryOneResult;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.ResultStatus;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpCondition;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpContext;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpFactory;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpSort;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpValue;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.ProfileFetcher;
import com.xforceplus.ultraman.oqsengine.sdk.util.CompletableFutureUtils;
import com.xforceplus.ultraman.oqsengine.sdk.utils.PropertyHelperEx;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import io.vavr.control.Either;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@Repository
public class SimpleEntityRepository<T>
implements EntityRepository<T> {
    private OqsEntityInformation entityInformation;
    private RepositoryInformation repositoryInformation;
    private ContextService contextService;
    private EntityFacade entityFacade;
    private OqsMappingContext context;
    private ProfileFetcher profileFetcher;
    private String code;
    private Logger logger = LoggerFactory.getLogger(SimpleEntityRepository.class);
    private static final String ENTITY_NOT_FOUND = "OqsEntity Not Found";

    public SimpleEntityRepository(OqsEntityInformation<T, Long> entityInformation, RepositoryInformation repositoryInformation, OqsMappingContext context, EntityFacade entityFacade, ProfileFetcher profileFetcher) {
        Assert.notNull(entityInformation, (String)"OqsEntityInformation must not be null.");
        this.entityInformation = entityInformation;
        this.repositoryInformation = repositoryInformation;
        this.entityFacade = entityFacade;
        this.contextService = context.getContextService();
        this.context = context;
        this.profileFetcher = profileFetcher;
        OqsEntity annotation = entityInformation.getJavaType().getAnnotation(OqsEntity.class);
        if (annotation != null) {
            this.code = annotation.value();
        }
    }

    private <T> T get(CompletionStage<T> future) {
        return future.toCompletableFuture().join();
    }

    private void setRecord(Class javaType, Object o, Record record) {
        Field[] allFields = FieldUtils.getAllFields((Class)javaType);
        Optional<Field> record2 = Arrays.stream(allFields).filter(field -> field.getName().equalsIgnoreCase("record")).findFirst();
        record2.ifPresent(recordField -> {
            try {
                recordField.setAccessible(true);
                recordField.set(o, record);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void appendSort(ExpSort expSort, Sort sort) {
        sort.stream().forEach(x -> expSort.withSort(x.getProperty(), x.isAscending() ? "asc" : "desc"));
    }

    private void appendPage(ExpQuery expQuery, Pageable pageable) {
        expQuery.range(Integer.valueOf(pageable.getPageNumber()), Integer.valueOf(pageable.getPageSize()));
    }

    private Iterable<T> findIterable(ExpRel expQuery, Sort sort) {
        Class javaType = this.entityInformation.getJavaType();
        PersistentEntity persistentEntity = this.context.getPersistentEntity(javaType);
        IEntityClass iEntityClass = persistentEntity.getSchema();
        IEntityClassGroup reader = this.entityFacade.getReader(iEntityClass, this.contextService.getAll());
        ExpSort expSort = ExpSort.init();
        if (sort != null && sort.isSorted()) {
            this.appendSort(expSort, sort);
        }
        ExpRel expRel = ExpFactory.withSort((ExpRel)expQuery, (ExpSort)expSort);
        Iterable recordsIterator = this.entityFacade.queryIterate(iEntityClass, expRel, record -> {
            try {
                Object o = javaType.newInstance();
                this.setRecord(javaType, o, (Record)record);
                return o;
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return null;
            }
        }, this.context.getExecutionConfig().getLegacy().booleanValue(), this.getContext());
        return recordsIterator;
    }

    private Page<T> findAllInner(ExpQuery expQuery, Pageable pageable, Sort sort) {
        Class javaType = this.entityInformation.getJavaType();
        PersistentEntity persistentEntity = this.context.getPersistentEntity(javaType);
        IEntityClass iEntityClass = persistentEntity.getSchema();
        IEntityClassGroup reader = this.entityFacade.getReader(iEntityClass, this.contextService.getAll());
        ExpContext expContext = new ExpContext().withContext(Optional.ofNullable(this.contextService).map(ContextService::getAll).orElse(Collections.emptyMap())).setSchema(reader);
        if (pageable != null && pageable.isPaged()) {
            expQuery.range(Integer.valueOf(pageable.getPageNumber()), Integer.valueOf(pageable.getPageSize()));
        }
        ExpSort expSort = ExpSort.init();
        if (sort != null && sort.isSorted()) {
            this.appendSort(expSort, sort);
        }
        expQuery.sort(expSort);
        Either query = (Either)this.get(this.entityFacade.query(expContext, (ExpRel)expQuery));
        AtomicLong total = new AtomicLong(0L);
        List list = (List)query.map(x -> {
            total.set(x.getRowNum().intValue());
            return x.getRows().stream().map(record -> {
                try {
                    Object o = javaType.newInstance();
                    this.setRecord(javaType, o, (Record)record);
                    return o;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                    return null;
                }
            }).collect(Collectors.toList());
        }).getOrElse(Collections.emptyList());
        return new PageImpl(list, pageable, total.get());
    }

    public Page<T> findAll(Pageable pageable) {
        return this.findAllInner(new ExpQuery(), pageable, Sort.unsorted());
    }

    public Iterable<T> findAll(Sort sort) {
        return this.findIterable((ExpRel)new ExpQuery(), sort);
    }

    public Page<T> findAll() {
        return this.findAllInner(new ExpQuery(), Pageable.unpaged(), Sort.unsorted());
    }

    Map<String, Object> getContext() {
        Map context = Optional.ofNullable(this.contextService).map(ContextService::getAll).orElseGet(Collections::emptyMap);
        return context;
    }

    public <S extends T> S save(S entity) {
        Class<?> aClass = entity.getClass();
        PersistentEntity persistentEntity = this.context.getPersistentEntity((Class)aClass);
        if (persistentEntity != null) {
            IEntityClass schema = persistentEntity.getSchema();
            Map<String, Object> contextMap = this.getContext();
            if (entity instanceof BaseEntity) {
                Either idEither;
                BaseEntity typedEntity = (BaseEntity)entity;
                Map<String, Object> body = ((BaseEntity)entity).getMap();
                if (body != null) {
                    if (((BaseEntity)entity).getId() != null) {
                        CompletionStage replaceResult = this.entityFacade.replaceById(schema, typedEntity.getId(), body, contextMap);
                        idEither = ((Either)this.get(replaceResult)).map(x -> {
                            if (x < 0) {
                                this.logger.warn("update affected row is 0 when update {} : {}", entity.getClass(), (Object)typedEntity.getId());
                            }
                            return typedEntity.getId();
                        });
                    } else {
                        CompletionStage stage = this.entityFacade.create(schema, body, contextMap);
                        idEither = (Either)this.get(stage);
                    }
                } else {
                    throw new RuntimeException("body should not be null");
                }
                return (S)idEither.mapLeft(x -> x.getMessage()).flatMap(x -> ((Either)this.get(this.entityFacade.findOneById(schema, x, contextMap))).mapLeft(ResultStatus::getMessage)).map(x -> this.toEntity(aClass, (Record)x)).getOrElseThrow(s -> new RuntimeException((String)s));
            }
            throw new RuntimeException("Current not support non-entity");
        }
        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    private CompletionStage<Either<CreateOneResult, Long>> create(Class aClass, Object entity, IEntityClass entityClass, Map<String, Object> context) {
        try {
            Method getMap = aClass.getMethod("getMap", new Class[0]);
            Map invoke = (Map)getMap.invoke(entity, new Object[0]);
            CompletionStage stage = this.entityFacade.create(entityClass, invoke, context);
            return stage;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.error("{}", (Throwable)e);
            CompletableFuture<Either<CreateOneResult, Long>> future = new CompletableFuture<Either<CreateOneResult, Long>>();
            future.completeExceptionally(e);
            return future;
        }
    }

    private Object toEntity(Class aClass, Record record) {
        try {
            Object o = aClass.newInstance();
            this.setRecord(aClass, o, record);
            return o;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Object entity;
        Class<?> aClass;
        PersistentEntity persistentEntity;
        LinkedList linkedList = new LinkedList();
        entities.forEach(linkedList::add);
        if (linkedList.size() > 0 && (persistentEntity = this.context.getPersistentEntity((Class)(aClass = (entity = linkedList.get(0)).getClass()))) != null) {
            IEntityClass schema = persistentEntity.getSchema();
            Map context = Optional.ofNullable(this.contextService).map(ContextService::getAll).orElseGet(Collections::emptyMap);
            List seq = linkedList.stream().map(x -> this.create(aClass, x, schema, context).toCompletableFuture()).collect(Collectors.toList());
            List idsFuture = (List)CompletableFutureUtils.sequence(seq).join();
            Optional<Either> error = idsFuture.stream().filter(x -> x.isLeft() && !((CreateOneResult)x.getLeft()).getOriginCause().isMute()).findAny();
            if (error.isPresent()) {
                error.get().getOrElseThrow(x -> new RuntimeException(x.getMessage()));
            } else {
                List records = idsFuture.stream().map(x -> {
                    Long id = (Long)x.get();
                    return this.entityFacade.findOneById(schema, id, context).toCompletableFuture();
                }).collect(Collectors.toList());
                List sequence = (List)this.get(CompletableFutureUtils.sequence(records));
                Optional<Either> queryError = sequence.stream().filter(x -> x.isLeft() && !((QueryOneResult)x.getLeft()).getOriginCause().isMute()).findAny();
                if (queryError.isPresent()) {
                    queryError.get().getOrElseThrow(x -> new RuntimeException(x.getMessage()));
                } else {
                    return sequence.stream().map(x -> {
                        Record record = (Record)x.get();
                        return this.toEntity(aClass, record);
                    }).collect(Collectors.toList());
                }
            }
        }
        return Collections.emptyList();
    }

    public Optional<T> findById(Long id) {
        Class javaType = this.entityInformation.getJavaType();
        PersistentEntity persistentEntity = this.context.getPersistentEntity(javaType);
        if (persistentEntity != null) {
            CompletionStage either = this.entityFacade.findOneById(persistentEntity.getSchema(), id, Optional.ofNullable(this.contextService).map(ContextService::getAll).orElse(Collections.emptyMap()));
            return ((Either)this.get(either)).toJavaOptional().map(record -> this.toEntity(javaType, (Record)record));
        }
        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    public boolean existsById(Long aLong) {
        Class javaType = this.entityInformation.getJavaType();
        PersistentEntity persistentEntity = this.context.getPersistentEntity(javaType);
        if (persistentEntity != null) {
            ExpQuery idCondition = new ExpQuery().filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode[])new ExpNode[]{ExpField.field((String)"id"), ExpValue.fromSingle((Object)aLong)})).sort(ExpSort.init());
            return this.get(this.entityFacade.count(persistentEntity.getSchema(), (ExpRel)idCondition, Optional.ofNullable(this.contextService).map(ContextService::getAll).orElse(Collections.emptyMap())).thenApply(x -> x > 0));
        }
        throw new RuntimeException("Error");
    }

    public Iterable<T> findAllById(Iterable<Long> longs) {
        Class javaType = this.entityInformation.getJavaType();
        PersistentEntity persistentEntity = this.context.getPersistentEntity(javaType);
        if (persistentEntity != null) {
            LinkedList ids = new LinkedList();
            longs.forEach(ids::add);
            ExpQuery idCondition = new ExpQuery().filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.IN, (ExpNode)ExpField.field((String)"id"), ids.stream().flatMap(x -> ExpValue.from((Object)x).stream()).collect(Collectors.toList()))).sort(ExpSort.init());
            return this.findAllInner(idCondition, null, null);
        }
        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    public long count() {
        Class javaType = this.entityInformation.getJavaType();
        PersistentEntity persistentEntity = this.context.getPersistentEntity(javaType);
        if (persistentEntity != null) {
            ExpQuery idCondition = new ExpQuery().sort(ExpSort.init());
            return ((Integer)this.get(this.entityFacade.count(persistentEntity.getSchema(), (ExpRel)idCondition, Optional.ofNullable(this.contextService).map(ContextService::getAll).orElse(Collections.emptyMap())))).intValue();
        }
        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    public void deleteById(Long aLong) {
        Class javaType = this.entityInformation.getJavaType();
        PersistentEntity persistentEntity = this.context.getPersistentEntity(javaType);
        if (persistentEntity != null) {
            this.deleteInner(persistentEntity.getSchema(), Arrays.asList(aLong));
            return;
        }
        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    public void delete(T entity) {
        this.deleteAll(Arrays.asList(entity));
    }

    private void deleteInner(IEntityClass entityClass, List<Long> ids) {
        List collect = ids.stream().map(id -> this.entityFacade.deleteOne(entityClass, id, Optional.ofNullable(this.contextService).map(ContextService::getAll).orElse(Collections.emptyMap())).toCompletableFuture()).collect(Collectors.toList());
        List sequence = (List)this.get(CompletableFutureUtils.sequence(collect));
        Optional<Either> queryError = sequence.stream().filter(x -> x.isLeft() && !((DeleteOneResult)x.getLeft()).getOriginCause().isMute()).findAny();
        queryError.ifPresent(integers -> {
            Integer cfr_ignored_0 = (Integer)integers.getOrElseThrow(x -> new RuntimeException(x.getMessage()));
        });
    }

    public void deleteAll(Iterable<? extends T> entities) {
        LinkedList<Long> ids = new LinkedList<Long>();
        Class javaType = this.entityInformation.getJavaType();
        PersistentEntity persistentEntity = this.context.getPersistentEntity(javaType);
        if (persistentEntity != null) {
            try {
                Method getId = ClassUtils.getMethod((Class)javaType, (String)"getId", (Class[])new Class[0]);
                for (T entity : entities) {
                    Object id = getId.invoke(entity, new Object[0]);
                    ids.add((Long)id);
                }
                this.deleteInner(persistentEntity.getSchema(), ids);
                return;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    public void deleteAll() {
        this.deleteAll((Iterable<? extends T>)this.findAll());
    }

    @Override
    public T newRecord() {
        Class javaType = this.entityInformation.getJavaType();
        PersistentEntity persistentEntity = this.context.getPersistentEntity(javaType);
        try {
            Object o = javaType.newInstance();
            List fields = persistentEntity.getSchema().fields();
            Method prepare = javaType.getMethod("prepare", Collection.class);
            Object invoke = prepare.invoke(o, fields);
            return o;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DataCollection<T> findByExpRel(ExpRel exp) {
        Class javaType = this.entityInformation.getJavaType();
        PersistentEntity persistentEntity = this.context.getPersistentEntity(javaType);
        if (persistentEntity != null) {
            IEntityClassGroup reader = this.entityFacade.getReader(persistentEntity.getSchema(), this.contextService.getAll());
            ExpContext expContext = new ExpContext().withContext(Optional.ofNullable(this.contextService).map(ContextService::getAll).orElseGet(Collections::emptyMap)).setSchema(reader);
            CompletionStage query = this.entityFacade.query(expContext, exp);
            return (DataCollection)((Either)this.get(query)).map(recordList -> {
                List collect = recordList.getRows().stream().map(record -> this.mappingToReturnType(javaType, (Record)record)).collect(Collectors.toList());
                DataCollection collection = new DataCollection(recordList.getRowNum(), collect);
                return collection;
            }).getOrElseThrow(x -> new RuntimeException(x.getMessage()));
        }
        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    @Override
    public DataCollection<T> findByConditionQueryRequest(ConditionQueryRequest request) {
        return this.findByExpRel((ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
    }

    private <S> ExpQuery toExpRel(IEntityClassGroup reader, Example<S> example) {
        Class exampleType = example.getProbeType();
        if (BaseEntity.class.isAssignableFrom(exampleType)) {
            BaseEntity probe = (BaseEntity)example.getProbe();
            Record record = probe.getRecord();
            return ExpFactory.createFrom((Map)record.toMap(null));
        }
        Object probe = example.getProbe();
        HashMap propertyMap = new HashMap();
        try {
            Map describe = PropertyUtils.describe((Object)probe);
            describe.forEach((k, v) -> {
                Optional columnName = PropertyHelperEx.getColumnName((IEntityClassGroup)reader, (String)k);
                columnName.ifPresent(x -> propertyMap.put(x, v));
            });
            return ExpFactory.createFrom(propertyMap);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot convert example to expRel, reason:" + e.getMessage());
        }
    }

    private <S extends T> CompletionStage<Either<String, DataCollection<Record>>> queryWithExample(Example<S> example, Sort sort, Pageable page) {
        Class javaType = this.entityInformation.getJavaType();
        PersistentEntity persistentEntity = this.context.getPersistentEntity(javaType);
        if (persistentEntity != null) {
            IEntityClassGroup reader = this.entityFacade.getReader(persistentEntity.getSchema(), this.contextService.getAll());
            ExpQuery expQuery = this.toExpRel(reader, example);
            ExpSort expSort = ExpSort.init();
            if (sort != null && sort.isSorted()) {
                this.appendSort(expSort, sort);
            }
            if (page != null && page.isPaged()) {
                this.appendPage(expQuery, page);
            }
            ExpContext expContext = new ExpContext().withContext(Optional.ofNullable(this.contextService).map(ContextService::getAll).orElseGet(Collections::emptyMap)).setSchema(reader);
            CompletionStage query = this.entityFacade.query(expContext, (ExpRel)expQuery);
            return query.thenApply(x -> x.mapLeft(ResultStatus::getMessage));
        }
        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        CompletionStage<Either<String, DataCollection<Record>>> query = this.queryWithExample(example, null, null);
        return this.get(query).toJavaOptional().map(recordList -> {
            if (recordList.getRowNum() > 1) {
                throw new RuntimeException("Found Record more than 1 with findOne");
            }
            Record record = (Record)recordList.getRows().get(0);
            return this.mappingToReturnType(example.getProbeType(), record);
        });
    }

    private <S extends T> DataCollection<S> findAll(Example<S> example, Sort sort, Pageable page) {
        CompletionStage<Either<String, DataCollection<Record>>> query = this.queryWithExample(example, sort, page);
        return this.get(query).toJavaOptional().map(recordList -> {
            List collect = recordList.getRows().stream().map(record -> this.mappingToReturnType(example.getProbeType(), (Record)record)).collect(Collectors.toList());
            DataCollection collection = new DataCollection(recordList.getRowNum(), collect);
            return collection;
        }).orElseGet(() -> {
            DataCollection dataCollection = new DataCollection(Integer.valueOf(0), Collections.emptyList());
            return dataCollection;
        });
    }

    public <S extends T> Iterable<S> findAll(Example<S> example) {
        return this.findAll(example, null, null).getRows();
    }

    public <S extends T> Iterable<S> findAll(Example<S> example, Sort sort) {
        return this.findAll(example, sort, null).getRows();
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        DataCollection<S> dc = this.findAll(example, null, pageable);
        List list = dc.getRows();
        Integer total = dc.getRowNum();
        return new PageImpl(list, pageable, (long)total.intValue());
    }

    public <S extends T> long count(Example<S> example) {
        return this.findAll(example, null, (Pageable)PageRequest.of((int)1, (int)1)).getRowNum().intValue();
    }

    public <S extends T> boolean exists(Example<S> example) {
        return this.count(example) > 0L;
    }

    private Object mappingToReturnType(Class<?> classType, Record record) {
        if (BaseEntity.class.isAssignableFrom(classType)) {
            try {
                Object o = classType.newInstance();
                Field[] allFields = FieldUtils.getAllFields(classType);
                Optional<Field> record2 = Arrays.stream(allFields).filter(field -> field.getName().equalsIgnoreCase("record")).findFirst();
                record2.ifPresent(recordField -> {
                    try {
                        recordField.setAccessible(true);
                        recordField.set(o, record);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                });
                return o;
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return null;
            }
        }
        return record.into(classType);
    }
}

