/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.oqsengine.sdk.reexploit.spring.query;

import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsMappingContext;
import com.xforceplus.oqsengine.sdk.reexploit.spring.annotation.OqsEntity;
import com.xforceplus.oqsengine.sdk.reexploit.spring.model.BaseEntity;
import com.xforceplus.oqsengine.sdk.reexploit.spring.model.Domain;
import com.xforceplus.oqsengine.sdk.reexploit.spring.query.OqsQueryCreator;
import com.xforceplus.oqsengine.sdk.reexploit.spring.query.OqsQueryMethod;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.ResultStatus;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpContext;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.ProfileFetcher;
import com.xforceplus.ultraman.oqsengine.sdk.utils.PropertyHelperEx;
import io.vavr.control.Either;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.OqsPartTree;
import org.springframework.data.util.DynamicEntityTypeInformation;
import org.springframework.util.Assert;

public class SimpleQuery
implements RepositoryQuery {
    protected OqsQueryMethod queryMethod;
    private OqsMappingContext mappingContext;
    private EntityFacade entityFacade;
    private ProfileFetcher fetcher;
    private OqsPartTree tree;

    public SimpleQuery(OqsQueryMethod method, EntityFacade entityFacade, RepositoryMetadata metadata, OqsMappingContext context) {
        this.queryMethod = method;
        this.mappingContext = context;
        this.entityFacade = context.getEntityService();
        Class domainType = metadata.getDomainType();
        OqsEntity annotation = domainType.getAnnotation(OqsEntity.class);
        if (annotation != null) {
            String code = annotation.value();
            Map all = context.getContextService().getAll();
            String profile = this.fetcher.getProfile(all);
            Optional iEntityClass = this.mappingContext.getEntityService().loadByCode(code, profile);
            IEntityClass realEntity = (IEntityClass)iEntityClass.orElseThrow(() -> new RuntimeException("Code not exists " + code));
            this.tree = new OqsPartTree(this.queryMethod.getName(), new DynamicEntityTypeInformation(entityFacade.getReader(realEntity, all), this.queryMethod.getResultProcessor().getReturnedType().getDomainType(), profile));
        } else {
            this.tree = new OqsPartTree(this.queryMethod.getName(), this.queryMethod.getResultProcessor().getReturnedType().getDomainType());
        }
    }

    public Object execute(Object[] parameters) {
        Class clazz = this.queryMethod.getResultProcessor().getReturnedType().getDomainType();
        Domain requiredDomain = this.mappingContext.getRequiredDomain(clazz);
        IEntityClass entityClass = requiredDomain.getEntityClass();
        Map all = this.mappingContext.getContextService().getAll();
        String profile = this.fetcher.getProfile(all);
        EntityFacade entityFacade = this.mappingContext.getEntityService();
        IEntityClassGroup reader = entityFacade.getReader(entityClass, all);
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        ExpQuery query = this.createQuery(accessor, reader);
        Assert.notNull((Object)query, (String)"unsupported query");
        Class returnedObjectType = this.queryMethod.getReturnedObjectType();
        Field[] allFields = FieldUtils.getAllFields((Class)returnedObjectType);
        List projections = Stream.of(allFields).map(x -> PropertyHelperEx.getColumnName((IEntityClassGroup)reader, (String)x.getName())).filter(Optional::isPresent).map(x -> ExpField.field((String)((String)x.get()))).collect(Collectors.toList());
        query.project(projections);
        ExpContext expContext = new ExpContext().withContext(Optional.ofNullable(this.mappingContext.getContextService().getAll()).orElse(Collections.emptyMap())).setSchema(reader);
        Either result = ((Either)entityFacade.query(expContext, (ExpRel)query).toCompletableFuture().join()).mapLeft(ResultStatus::getMessage);
        return result.map(data -> data.getRows().stream().map(x -> {
            ParametersParameterAccessor objects = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
            ResultProcessor resultProcessor = this.queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)objects);
            if (returnedObjectType == clazz) {
                try {
                    Object o = returnedObjectType.newInstance();
                    Field record = FieldUtils.getField((Class)returnedObjectType, (String)"record", (boolean)true);
                    record.set(o, x);
                    return o;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return resultProcessor.processResult(x, (Converter)new RecordConverter(resultProcessor.getReturnedType()));
        }).collect(Collectors.toList())).getOrElseThrow(x -> new RuntimeException((String)x));
    }

    private Object mappingToReturnType(Class<?> classType, Record record) {
        if (BaseEntity.class.isAssignableFrom(classType)) {
            try {
                Object o = classType.newInstance();
                Field[] allFields = FieldUtils.getAllFields(classType);
                Optional<Field> record2 = Arrays.stream(allFields).filter(field -> field.getName().equalsIgnoreCase("record")).findFirst();
                record2.ifPresent(recordField -> {
                    try {
                        recordField.setAccessible(true);
                        recordField.set(o, record);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                });
                return o;
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return null;
            }
        }
        return record.into(classType);
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    public ExpQuery createQuery(ParametersParameterAccessor accessor, IEntityClassGroup reader) {
        return (ExpQuery)new OqsQueryCreator(this.tree, (ParameterAccessor)accessor, reader).createQuery();
    }

    class RecordConverter
    implements Converter<Object, Object> {
        private final ReturnedType type;

        RecordConverter(ReturnedType type) {
            Assert.notNull((Object)type, (String)"Returned type must not be null!");
            this.type = type;
        }

        public Object convert(Object source) {
            return SimpleQuery.this.mappingToReturnType(this.type.getReturnedType(), (Record)source);
        }
    }
}

