/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.oqsengine.sdk.reexploit.spring;

import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsPersistentEntity;
import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsPersistentEntityImpl;
import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsPersistentProperty;
import com.xforceplus.oqsengine.sdk.reexploit.spring.annotation.OqsEntity;
import com.xforceplus.oqsengine.sdk.reexploit.spring.model.Domain;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.ProfileFetcher;
import com.xforceplus.ultraman.oqsengine.sdk.service.core.ExecutionConfig;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PersistentPropertyPaths;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.InvalidPersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextEvent;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.DynamicEntityTypeInformation;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class OqsMappingContext
implements MappingContext<OqsPersistentEntity<?>, OqsPersistentProperty>,
ApplicationEventPublisherAware,
ApplicationContextAware {
    private EntityFacade entityFacade;
    private ContextService contextService;
    private ProfileFetcher profileFetcher;
    private Map<Class<?>, Domain> domains = new HashMap();
    private Set<? extends Class<?>> initialEntitySet = new HashSet();
    private final Map<TypeInformation<?>, Optional<OqsPersistentEntity<?>>> persistentEntities = new HashMap();
    private SimpleTypeHolder simpleTypeHolder = SimpleTypeHolder.DEFAULT;
    private ApplicationEventPublisher applicationEventPublisher;
    private ApplicationContext applicationContext;
    private ExecutionConfig executionConfig;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock read = this.lock.readLock();
    private final Lock write = this.lock.writeLock();

    public OqsMappingContext(EntityFacade entityFacade, ContextService contextService, ProfileFetcher fetcher, ExecutionConfig config) {
        this.entityFacade = entityFacade;
        this.contextService = contextService;
        this.executionConfig = config;
        this.profileFetcher = fetcher;
    }

    public void initialize() {
        this.initialEntitySet.forEach(this::addPersistentEntity);
    }

    public void init() {
        this.initialize();
        this.domains = this.getManagedTypes().stream().map(TypeInformation::getType).filter(clz -> clz.isAnnotationPresent(OqsEntity.class)).collect(Collectors.toMap(clz -> clz, clz -> new Domain(this, (Class<?>)clz)));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public Collection<OqsPersistentEntity<?>> getPersistentEntities() {
        try {
            this.read.lock();
            Collection collection = this.persistentEntities.values().stream().flatMap(xva$0 -> Optionals.toStream((Optional[])new Optional[]{xva$0})).collect(Collectors.toSet());
            return collection;
        }
        finally {
            this.read.unlock();
        }
    }

    public OqsPersistentEntity getPersistentEntity(Class<?> type) {
        OqsEntity annotation = type.getAnnotation(OqsEntity.class);
        if (annotation == null) {
            return null;
        }
        String code = annotation.value();
        String profile = this.profileFetcher.getProfile(Collections.emptyMap());
        Optional iEntityClass = this.entityFacade.loadByCode(code, profile);
        return iEntityClass.map(x -> this.getPersistentEntity(new DynamicEntityTypeInformation(this.entityFacade.getReader(x, this.contextService.getAll()), type, profile))).orElse(null);
    }

    public boolean hasPersistentEntityFor(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        OqsEntity annotation = type.getAnnotation(OqsEntity.class);
        if (annotation == null) {
            return false;
        }
        String code = annotation.value();
        String profile = this.profileFetcher.getProfile(Collections.emptyMap());
        Optional iEntityClass = this.entityFacade.loadByCode(code, profile);
        Map context = this.contextService.getAll();
        return iEntityClass.map(x -> {
            Optional<OqsPersistentEntity<?>> oqsPersistentEntity = this.persistentEntities.get(new DynamicEntityTypeInformation(this.entityFacade.getReader(x, context), type, profile));
            return oqsPersistentEntity != null && oqsPersistentEntity.isPresent();
        }).orElse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OqsPersistentEntity getPersistentEntity(TypeInformation<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        try {
            this.read.lock();
            Optional<OqsPersistentEntity<?>> entity = this.persistentEntities.get(type);
            if (entity != null) {
                OqsPersistentEntity oqsPersistentEntity = entity.orElse(null);
                return oqsPersistentEntity;
            }
        }
        finally {
            this.read.unlock();
        }
        throw new RuntimeException("No Related Entity Found ");
    }

    public OqsPersistentEntity getPersistentEntity(OqsPersistentProperty persistentProperty) {
        Assert.notNull((Object)persistentProperty, (String)"PersistentProperty must not be null!");
        if (!persistentProperty.isEntity()) {
            return null;
        }
        TypeInformation typeInfo = persistentProperty.getTypeInformation();
        return this.getPersistentEntity(typeInfo.getRequiredActualType());
    }

    public PersistentPropertyPath<OqsPersistentProperty> getPersistentPropertyPath(PropertyPath propertyPath) throws InvalidPersistentPropertyPath {
        return null;
    }

    public PersistentPropertyPath<OqsPersistentProperty> getPersistentPropertyPath(String propertyPath, Class<?> type) throws InvalidPersistentPropertyPath {
        return null;
    }

    public <T> PersistentPropertyPaths<T, OqsPersistentProperty> findPersistentPropertyPaths(Class<T> type, Predicate<? super OqsPersistentProperty> predicate) {
        return this.doFindPersistentPropertyPaths(type, predicate, it -> !it.isAssociation());
    }

    protected final <T> PersistentPropertyPaths<T, OqsPersistentProperty> doFindPersistentPropertyPaths(Class<T> type, Predicate<? super OqsPersistentProperty> predicate, Predicate<OqsPersistentProperty> traversalGuard) {
        return null;
    }

    public Collection<TypeInformation<?>> getManagedTypes() {
        try {
            this.read.lock();
            Set<TypeInformation<?>> set = Collections.unmodifiableSet(new HashSet(this.persistentEntities.keySet()));
            return set;
        }
        finally {
            this.read.unlock();
        }
    }

    protected Optional<OqsPersistentEntity<?>> addPersistentEntity(Class<?> type) {
        OqsEntity annotation = type.getAnnotation(OqsEntity.class);
        if (annotation == null) {
            return null;
        }
        String code = annotation.value();
        String profile = this.profileFetcher.getProfile(Collections.emptyMap());
        Optional iEntityClass = this.entityFacade.loadByCode(code, profile);
        return iEntityClass.flatMap(x -> this.addPersistentEntity(new DynamicEntityTypeInformation(this.entityFacade.getReader(x, this.contextService.getAll()), type, profile)));
    }

    private OqsPersistentEntity createPersistentEntity(TypeInformation<?> typeInformation) {
        OqsPersistentEntityImpl entity = new OqsPersistentEntityImpl((DynamicEntityTypeInformation)typeInformation);
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<OqsPersistentEntity<?>> addPersistentEntity(TypeInformation<?> typeInformation) {
        Assert.notNull(typeInformation, (String)"TypeInformation must not be null!");
        try {
            this.read.lock();
            Optional<OqsPersistentEntity<?>> persistentEntity = this.persistentEntities.get(typeInformation);
            if (persistentEntity != null) {
                Optional<OqsPersistentEntity<?>> optional = persistentEntity;
                return optional;
            }
        }
        finally {
            this.read.unlock();
        }
        Class type = typeInformation.getType();
        OqsPersistentEntity entity = null;
        try {
            this.write.lock();
            entity = this.createPersistentEntity(typeInformation);
            this.persistentEntities.put(typeInformation, Optional.of(entity));
        }
        catch (BeansException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.write.unlock();
        }
        if (this.applicationEventPublisher != null && entity != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new MappingContextEvent((MappingContext)this, (PersistentEntity)entity));
        }
        return Optional.of(entity);
    }

    public void setInitialEntitySet(Set<? extends Class<?>> initialEntitySet) {
        this.initialEntitySet = initialEntitySet;
    }

    public EntityFacade getEntityService() {
        return this.entityFacade;
    }

    public Domain getDomain(Class<?> entityClass) {
        return this.domains.get(entityClass);
    }

    public Domain getRequiredDomain(Class<?> entityClass) {
        Domain domain = this.getDomain(entityClass);
        if (null == domain) {
            throw new MappingException("Could not find Domain for type: " + entityClass);
        }
        return domain;
    }

    public ContextService getContextService() {
        return this.contextService;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public void setExecutionConfig(ExecutionConfig executionConfig) {
        this.executionConfig = executionConfig;
    }
}

