/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.oqsengine.sdk.reexploit.spring;

import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsEntityPersistentPropertyImpl;
import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsPersistentEntity;
import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsPersistentProperty;
import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsPersistentPropertyAccessorFactory;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.mapping.Alias;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.PersistentPropertyAccessorFactory;
import org.springframework.data.util.DynamicEntityTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public class OqsPersistentEntityImpl<T>
implements OqsPersistentEntity<T> {
    private IEntityClass entityClass;
    private FieldNamingStrategy fieldNamingStrategy;
    private IEntityClassGroup reader;
    private Map<String, Association> associationMap;
    private Map<String, OqsPersistentProperty> mapping;
    private final Map<Class<? extends Annotation>, Optional<Annotation>> annotationCache;
    private PersistentPropertyAccessorFactory propertyAccessorFactory;
    private Class<T> type;
    private TypeInformation<T> dynamicTypeInformation;
    private static final String TYPE_MISMATCH = "Target bean of type %s is not of type of the persistent entity (%s)!";

    public OqsPersistentEntityImpl(DynamicEntityTypeInformation typeInformation) {
        this.entityClass = typeInformation.getEntityClass();
        this.dynamicTypeInformation = typeInformation;
        this.reader = typeInformation.getReader();
        this.associationMap = new ConcurrentHashMap<String, Association>();
        this.annotationCache = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);
        this.propertyAccessorFactory = new OqsPersistentPropertyAccessorFactory();
        this.mapping = new HashMap<String, OqsPersistentProperty>();
        this.reader.columns().forEach(x -> this.mapping.put(x.name(), new OqsEntityPersistentPropertyImpl(x.name(), this)));
        this.entityClass.relations().forEach(x -> {
            OqsPersistentProperty oqsPersistentProperty = this.mapping.get(x.getName() + ".id");
            OqsPersistentProperty id = this.mapping.get("id");
            this.associationMap.put(x.getName(), new Association((PersistentProperty)oqsPersistentProperty, (PersistentProperty)id));
        });
    }

    @Override
    public Class<?> getIdClass() {
        return Long.class;
    }

    @Override
    public IEntityClass getSchema() {
        return this.entityClass;
    }

    public String getName() {
        return this.entityClass.name();
    }

    public PreferredConstructor<T, OqsPersistentProperty> getPersistenceConstructor() {
        return null;
    }

    public boolean isConstructorArgument(PersistentProperty<?> property) {
        return false;
    }

    public boolean isIdProperty(PersistentProperty<?> property) {
        return property.getName().equals("id");
    }

    public boolean isVersionProperty(PersistentProperty<?> property) {
        return false;
    }

    public OqsPersistentProperty getIdProperty() {
        return this.mapping.get("id");
    }

    public OqsPersistentProperty getVersionProperty() {
        return null;
    }

    public OqsPersistentProperty getPersistentProperty(String name) {
        return this.mapping.get(name);
    }

    public Iterable<OqsPersistentProperty> getPersistentProperties(Class<? extends Annotation> annotationType) {
        return this.mapping.values();
    }

    public boolean hasIdProperty() {
        return this.mapping.containsKey("id");
    }

    public boolean hasVersionProperty() {
        return false;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Alias getTypeAlias() {
        return Alias.empty();
    }

    public TypeInformation<T> getTypeInformation() {
        return this.dynamicTypeInformation;
    }

    public void doWithProperties(PropertyHandler<OqsPersistentProperty> handler) {
        this.mapping.values().forEach(arg_0 -> handler.doWithPersistentProperty(arg_0));
    }

    public void doWithProperties(SimplePropertyHandler handler) {
        this.mapping.values().forEach(arg_0 -> ((SimplePropertyHandler)handler).doWithPersistentProperty(arg_0));
    }

    public void doWithAssociations(AssociationHandler<OqsPersistentProperty> handler) {
        this.associationMap.values().forEach(x -> handler.doWithAssociation(x));
    }

    public void doWithAssociations(SimpleAssociationHandler handler) {
        this.associationMap.values().forEach(x -> handler.doWithAssociation(x));
    }

    public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
        return (A)((Annotation)this.doFindAnnotation(annotationType).orElse(null));
    }

    private <A extends Annotation> Optional<A> doFindAnnotation(Class<A> annotationType) {
        return this.annotationCache.computeIfAbsent(annotationType, it -> Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation(this.getType(), (Class)it)));
    }

    public <A extends Annotation> boolean isAnnotationPresent(Class<A> annotationType) {
        return false;
    }

    public <B> PersistentPropertyAccessor<B> getPropertyAccessor(B bean) {
        return this.propertyAccessorFactory.getPropertyAccessor((PersistentEntity)this, bean);
    }

    public IdentifierAccessor getIdentifierAccessor(Object bean) {
        return null;
    }

    private final void verifyBeanType(Object bean) {
        Assert.notNull((Object)bean, (String)"Target bean must not be null!");
        Assert.isInstanceOf(this.getType(), (Object)bean, () -> String.format(TYPE_MISMATCH, bean.getClass().getName(), this.getType().getName()));
    }

    public boolean isNew(Object bean) {
        return false;
    }

    public boolean isImmutable() {
        return false;
    }

    public boolean requiresPropertyPopulation() {
        return false;
    }

    public Iterator<OqsPersistentProperty> iterator() {
        return this.mapping.values().iterator();
    }
}

