package com.xforceplus.oqsengine.sdk.reexploit.spring;

import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.QueryByExampleExecutor;

@org.springframework.stereotype.Repository
public interface EntityRepository<T> extends PagingAndSortingRepository<T, Long>, QueryByExampleExecutor<T> {

    T newRecord();

    DataCollection<T> findByExpRel(ExpRel exp);

    DataCollection<T> findByConditionQueryRequest(ConditionQueryRequest request);

}
