package com.xforceplus.oqsengine.sdk.reexploit.spring;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;


public class EntityRepositoryConfigExtension extends RepositoryConfigurationExtensionSupport {

    @Override
    protected String getModulePrefix() {
        return null;
    }

    @Override
    public String getModuleName() {
        return "OqsEngine";
    }


    @Override
    public String getRepositoryFactoryBeanClassName() {
        return OqsEntityRepositoryFactoryBean.class.getName();
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("operations", "entityFacade");
        builder.addPropertyReference("context", "oqsMappingContext");
    }
}
