package com.xforceplus.oqsengine.sdk.reexploit.spring;

import org.springframework.data.domain.Persistable;
import org.springframework.data.repository.core.support.AbstractEntityInformation;

/**
 *
 * @param <T>
 * @param <ID>
 */
public abstract class OqsEntityInformationSupport<T, ID> extends AbstractEntityInformation<T, ID>
        implements OqsEntityInformation<T, ID> {

    private OqsEntityMetadata<T> metadata;

    /**
     * domain class generated class
     * @param domainClass
     */
    public OqsEntityInformationSupport(Class<T> domainClass) {
        super(domainClass);
        this.metadata = new DefaultOqsEntityMetadata<>(domainClass);
    }

    /**
     * TODO
     * Entry to create a entity information
     * @param domainClass
     * @param <T>
     * @return
     */
    public static <T> OqsEntityInformation<T, ?> getEntityInformation(Class<T> domainClass) {

        /**
         * domain or vo
         */
//        if (Persistable.class.isAssignableFrom(domainClass)) {
            return new OqsEntityPersistableEntityInformation(domainClass);
//        }
//        return new MybatisMappingContextEntityInformation<>(domainClass, mappingContext);
    }

    @Override
    public String getEntityName() {
        return this.metadata.getEntityName();
    }

}
