package com.xforceplus.oqsengine.sdk.reexploit.spring;

import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.TransactionalRepositoryFactoryBeanSupport;
import org.springframework.util.Assert;

public class OqsEntityRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
        extends RepositoryFactoryBeanSupport<T, S, ID> {

    private EntityFacade operations;

    private OqsMappingContext context;

    /**
     * Creates a new {@link TransactionalRepositoryFactoryBeanSupport} for the given repository interface.
     *
     * @param repositoryInterface must not be {@literal null}.
     */
    protected OqsEntityRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setExecutionService(EntityFacade operations) {
        Assert.notNull(operations, "ElasticsearchOperations must not be null!");
        this.operations = operations;
    }

    public void setContext(OqsMappingContext context) {
        this.context = context;
    }

    public void setOperations(EntityFacade operations) {
        this.operations = operations;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull(operations, "OqsOperations must be configured!");
    }

    @Override
    protected RepositoryFactorySupport createRepositoryFactory() {
        EntityRepositoryFactory repositoryFactory = new EntityRepositoryFactory(operations, context);
        return repositoryFactory;
    }
}
