/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.oqsengine.sdk.reexploit.spring.mapping;

import com.xforceplus.oqsengine.sdk.reexploit.spring.annotation.OqsEntity;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class EntityClassScanner {
    private Set<String> entityBasePackages = new HashSet<String>();
    private Set<Class<?>> entityBasePackageClasses = new HashSet();
    @Nullable
    private ClassLoader beanClassLoader;

    public static Set<Class<?>> scan(String ... entityBasePackages) throws ClassNotFoundException {
        return new EntityClassScanner(entityBasePackages).scanForEntityClasses();
    }

    public static Set<Class<?>> scan(Class<?> ... entityBasePackageClasses) throws ClassNotFoundException {
        return new EntityClassScanner(entityBasePackageClasses).scanForEntityClasses();
    }

    public static Set<Class<?>> scan(Collection<String> entityBasePackages) throws ClassNotFoundException {
        return new EntityClassScanner(entityBasePackages).scanForEntityClasses();
    }

    public static Set<Class<?>> scan(Collection<String> entityBasePackages, Collection<Class<?>> entityBasePackageClasses) throws ClassNotFoundException {
        return new EntityClassScanner(entityBasePackages, entityBasePackageClasses).scanForEntityClasses();
    }

    public EntityClassScanner() {
    }

    public EntityClassScanner(Class<?> ... entityBasePackages) {
        this.setEntityBasePackageClasses(Arrays.asList(entityBasePackages));
    }

    public EntityClassScanner(String ... entityBasePackages) {
        this(Arrays.asList(entityBasePackages));
    }

    public EntityClassScanner(Collection<String> entityBasePackages) {
        this.setEntityBasePackages(entityBasePackages);
    }

    public EntityClassScanner(Collection<String> entityBasePackages, Collection<Class<?>> entityBasePackageClasses) {
        this.setEntityBasePackages(entityBasePackages);
        this.setEntityBasePackageClasses(entityBasePackageClasses);
    }

    public Set<Class<?>> scanForEntityClasses() throws ClassNotFoundException {
        HashSet classes = new HashSet();
        for (String string : this.getEntityBasePackages()) {
            classes.addAll(this.scanBasePackageForEntities(string));
        }
        for (Class clazz : this.getEntityBasePackageClasses()) {
            classes.addAll(this.scanBasePackageForEntities(clazz.getPackage().getName()));
        }
        return classes;
    }

    protected Set<Class<?>> scanBasePackageForEntities(String basePackage) throws ClassNotFoundException {
        HashSet classes = new HashSet();
        if (StringUtils.isEmpty((Object)basePackage)) {
            return classes;
        }
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
        for (Class<? extends Annotation> annotation : this.getEntityAnnotations()) {
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotation));
        }
        for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
            if (null == candidate.getBeanClassName()) continue;
            classes.add(ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)this.beanClassLoader));
        }
        return classes;
    }

    protected Class<? extends Annotation>[] getEntityAnnotations() {
        return new Class[]{OqsEntity.class};
    }

    public Set<String> getEntityBasePackages() {
        return Collections.unmodifiableSet(this.entityBasePackages);
    }

    public void setEntityBasePackages(Collection<String> entityBasePackages) {
        this.entityBasePackages = new HashSet<String>(entityBasePackages);
    }

    public Set<Class<?>> getEntityBasePackageClasses() {
        return Collections.unmodifiableSet(this.entityBasePackageClasses);
    }

    public void setEntityBasePackageClasses(Collection<Class<?>> entityBasePackageClasses) {
        this.entityBasePackageClasses = new HashSet(entityBasePackageClasses);
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }
}

