package com.xforceplus.oqsengine.sdk.reexploit.spring;

import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.data.repository.config.DefaultRepositoryBaseClass;
import org.springframework.data.repository.query.QueryLookupStrategy;

import java.lang.annotation.*;

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
@Import(EntityRepositoryRegistrar.class)
public @interface EnableEntityRepositories {

    /**
     * Alias for the {@link #basePackages()} attribute. Allows for more concise annotation
     * declarations e.g.: {@code @EnableMybatisRepositories("org.my.pkg")} instead of
     * {@code @EnableMybatisRepositories(basePackages="org.my.pkg")}.
     * @return packages
     */
    String[] value() default {};

    /**
     * Base packages to scan for annotated components. {@link #value()} is an alias for
     * (and mutually exclusive with) this attribute. Use {@link #basePackageClasses()} for
     * a type-safe alternative to String-based package names.
     * @return base packages
     */
    String[] basePackages() default {};

    /**
     * Type-safe alternative to {@link #basePackages()} for specifying the packages to
     * scan for annotated components. The package of each class specified will be scanned.
     * Consider creating a special no-op marker class or interface in each package that
     * serves no purpose other than being referenced by this attribute.
     * @return base package classes
     */
    Class<?>[] basePackageClasses() default {};

    /**
     * Specifies which types are eligible for component scanning. Further narrows the set
     * of candidate components from everything in {@link #basePackages()} to everything in
     * the base packages that matches the given filter or filters.
     * @return include filters
     */
    ComponentScan.Filter[] includeFilters() default {};

    /**
     * Specifies which types are not eligible for component scanning.
     * @return exclude filters
     */
    ComponentScan.Filter[] excludeFilters() default {};

    Class<?> repositoryFactoryBeanClass() default OqsEntityRepositoryFactoryBean.class;

    String namedQueriesLocation() default "";

    String repositoryImplementationPostfix() default "Impl";

    Class<?> repositoryBaseClass() default DefaultRepositoryBaseClass.class;

    QueryLookupStrategy.Key queryLookupStrategy() default QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND;

}
