package com.xforceplus.oqsengine.sdk.reexploit.spring;

import com.xforceplus.oqsengine.sdk.reexploit.spring.query.OqsQueryMethod;
import com.xforceplus.oqsengine.sdk.reexploit.spring.query.SimpleQuery;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.lang.Nullable;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Optional;

/**
 * TODO add EntityService
 */
public class EntityRepositoryFactory extends RepositoryFactorySupport {

    private final EntityFacade entityFacade;

    private final OqsMappingContext context;

    public EntityRepositoryFactory(EntityFacade entityFacade, OqsMappingContext context) {
        this.entityFacade = entityFacade;
        this.context = context;
    }

    @Override
    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return (OqsEntityInformation<T, ID>) OqsEntityInformationSupport.getEntityInformation(domainClass);
    }

    @Override
    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
//        return SimpleOqs;

        return SimpleEntityRepository.class;
    }

    @Override
    protected EntityRepository getTargetRepository(RepositoryInformation information) {

        EntityInformation<?, Serializable> entityInformation = this
                .getEntityInformation(information.getDomainType());
        Object repository = this.getTargetRepositoryViaReflection(information, entityInformation, information, context, entityFacade);
        return (EntityRepository) repository;
    }

    @Override
    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key,
                                                                   QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new OqsQueryLookupStrategy());
    }

    private class OqsQueryLookupStrategy implements QueryLookupStrategy {

        @Override
        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory,
                                            NamedQueries namedQueries) {
            OqsQueryMethod queryMethod = new OqsQueryMethod(method, metadata, factory);
            return new SimpleQuery(queryMethod, entityFacade, metadata, context);
        }
    }
}
