package com.xforceplus.oqsengine.sdk.reexploit.spring;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.mapping.*;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.PersistentPropertyAccessorFactory;
import org.springframework.data.util.DynamicEntityTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class OqsPersistentEntityImpl<T> implements OqsPersistentEntity<T> {

    private IEntityClass entityClass;

    private FieldNamingStrategy fieldNamingStrategy;

    private IEntityClassGroup reader;

    private Map<String, Association> associationMap;

    private Map<String, OqsPersistentProperty> mapping;

    private final Map<Class<? extends Annotation>, Optional<Annotation>> annotationCache;

    private PersistentPropertyAccessorFactory propertyAccessorFactory;

    private Class<T> type;

    private TypeInformation<T> dynamicTypeInformation;

    private static final String TYPE_MISMATCH = "Target bean of type %s is not of type of the persistent entity (%s)!";

    public OqsPersistentEntityImpl(DynamicEntityTypeInformation typeInformation) {
        this.entityClass = typeInformation.getEntityClass();
        this.dynamicTypeInformation = typeInformation;
        this.reader = typeInformation.getReader();
        this.associationMap = new ConcurrentHashMap<>();

        //build property

        this.annotationCache = new ConcurrentReferenceHashMap<>(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);

        propertyAccessorFactory = new OqsPersistentPropertyAccessorFactory();

        mapping = new HashMap<>();

        //convert columns to property
        //TODO
        reader.columns().forEach(x -> {
            mapping.put(x.name(), new OqsEntityPersistentPropertyImpl(x.name(), this));
        });

        //TODO
        entityClass.relations().forEach(x -> {
            OqsPersistentProperty oqsPersistentProperty = mapping.get(x.getName() + ".id");
            OqsPersistentProperty id = mapping.get("id");
            associationMap.put(x.getName(), new Association<>(oqsPersistentProperty, id));
        });
    }

    @Override
    public Class<?> getIdClass() {
        return Long.class;
    }

    @Override
    public IEntityClass getSchema() {
        return entityClass;
    }

    @Override
    public String getName() {
        return entityClass.name();
    }

    @Override
    public PreferredConstructor<T, OqsPersistentProperty> getPersistenceConstructor() {
        return null;
    }

    @Override
    public boolean isConstructorArgument(PersistentProperty<?> property) {
        return false;
    }

    @Override
    public boolean isIdProperty(PersistentProperty<?> property) {
        return property.getName().equals("id");
    }

    @Override
    public boolean isVersionProperty(PersistentProperty<?> property) {
        return false;
    }

    @Override
    public OqsPersistentProperty getIdProperty() {
        return mapping.get("id");
    }

    @Override
    public OqsPersistentProperty getVersionProperty() {
        return null;
    }

    @Override
    public OqsPersistentProperty getPersistentProperty(String name) {
        return mapping.get(name);
    }

    /**
     * TODO filter
     * no annotation type
     *
     * @param annotationType
     * @return
     */
    @Override
    public Iterable<OqsPersistentProperty> getPersistentProperties(Class<? extends Annotation> annotationType) {
        return mapping.values();
    }

    @Override
    public boolean hasIdProperty() {
        return mapping.containsKey("id");
    }

    @Override
    public boolean hasVersionProperty() {
        return false;
    }

    @Override
    public Class<T> getType() {
        return type;
    }

    @Override
    public Alias getTypeAlias() {
        return Alias.empty();
    }

    @Override
    public TypeInformation<T> getTypeInformation() {
        return dynamicTypeInformation;
    }

    @Override
    public void doWithProperties(PropertyHandler<OqsPersistentProperty> handler) {
        mapping.values().forEach(handler::doWithPersistentProperty);
    }

    @Override
    public void doWithProperties(SimplePropertyHandler handler) {
        mapping.values().forEach(handler::doWithPersistentProperty);
    }

    @Override
    public void doWithAssociations(AssociationHandler<OqsPersistentProperty> handler) {
        associationMap.values().forEach(x -> handler.doWithAssociation(x));
    }

    @Override
    public void doWithAssociations(SimpleAssociationHandler handler) {
        associationMap.values().forEach(x -> handler.doWithAssociation(x));
    }

    @Override
    public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
        return doFindAnnotation(annotationType).orElse(null);
    }

    private <A extends Annotation> Optional<A> doFindAnnotation(Class<A> annotationType) {

        return (Optional<A>) annotationCache.computeIfAbsent(annotationType,
                it -> Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation(getType(), it)));
    }

    @Override
    public <A extends Annotation> boolean isAnnotationPresent(Class<A> annotationType) {
        return false;
    }

    @Override
    public <B> PersistentPropertyAccessor<B> getPropertyAccessor(B bean) {
        return propertyAccessorFactory.getPropertyAccessor(this, bean);
    }

    /**
     * TODO
     * @param bean
     * @param <B>
     * @return
     */
    @Override
    public <B> PersistentPropertyPathAccessor<B> getPropertyPathAccessor(B bean) {
        return null;
    }

    @Override
    public IdentifierAccessor getIdentifierAccessor(Object bean) {
        return null;
    }

    private final void verifyBeanType(Object bean) {

        Assert.notNull(bean, "Target bean must not be null!");
        Assert.isInstanceOf(getType(), bean,
                () -> String.format(TYPE_MISMATCH, bean.getClass().getName(), getType().getName()));
    }

    @Override
    public boolean isNew(Object bean) {
        return false;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean requiresPropertyPopulation() {
        return false;
    }

    @Override
    public Iterator<OqsPersistentProperty> iterator() {
        return mapping.values().iterator();
    }
}
